/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Locale;
import libcore.io.OsConstants;

class CommonTimeUtils {
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -4;
    public static final int ERROR_DEAD_OBJECT = -7;
    private IBinder mRemote;
    private String mInterfaceDesc;

    public CommonTimeUtils(IBinder remote, String interfaceDesc) {
        this.mRemote = remote;
        this.mInterfaceDesc = interfaceDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transactGetInt(int method_code, int error_ret_val) throws RemoteException {
        int ret_val;
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken(this.mInterfaceDesc);
            this.mRemote.transact(method_code, data, reply, 0);
            int res = reply.readInt();
            ret_val = 0 == res ? reply.readInt() : error_ret_val;
        }
        finally {
            reply.recycle();
            data.recycle();
        }
        return ret_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transactSetInt(int method_code, int val) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken(this.mInterfaceDesc);
            data.writeInt(val);
            this.mRemote.transact(method_code, data, reply, 0);
            int n = reply.readInt();
            return n;
        }
        catch (RemoteException e) {
            int n = -7;
            return n;
        }
        finally {
            reply.recycle();
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transactGetLong(int method_code, long error_ret_val) throws RemoteException {
        long ret_val;
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken(this.mInterfaceDesc);
            this.mRemote.transact(method_code, data, reply, 0);
            int res = reply.readInt();
            ret_val = 0 == res ? reply.readLong() : error_ret_val;
        }
        finally {
            reply.recycle();
            data.recycle();
        }
        return ret_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transactSetLong(int method_code, long val) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken(this.mInterfaceDesc);
            data.writeLong(val);
            this.mRemote.transact(method_code, data, reply, 0);
            int n = reply.readInt();
            return n;
        }
        catch (RemoteException e) {
            int n = -7;
            return n;
        }
        finally {
            reply.recycle();
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transactGetString(int method_code, String error_ret_val) throws RemoteException {
        String ret_val;
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken(this.mInterfaceDesc);
            this.mRemote.transact(method_code, data, reply, 0);
            int res = reply.readInt();
            ret_val = 0 == res ? reply.readString() : error_ret_val;
        }
        finally {
            reply.recycle();
            data.recycle();
        }
        return ret_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transactSetString(int method_code, String val) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInterfaceToken(this.mInterfaceDesc);
            data.writeString(val);
            this.mRemote.transact(method_code, data, reply, 0);
            int n = reply.readInt();
            return n;
        }
        catch (RemoteException e) {
            int n = -7;
            return n;
        }
        finally {
            reply.recycle();
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress transactGetSockaddr(int method_code) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        InetSocketAddress ret_val = null;
        try {
            data.writeInterfaceToken(this.mInterfaceDesc);
            this.mRemote.transact(method_code, data, reply, 0);
            int res = reply.readInt();
            if (0 == res) {
                int port = 0;
                String addrStr = null;
                int type = reply.readInt();
                if (OsConstants.AF_INET == type) {
                    int addr = reply.readInt();
                    port = reply.readInt();
                    addrStr = String.format(Locale.US, "%d.%d.%d.%d", addr >> 24 & 0xFF, addr >> 16 & 0xFF, addr >> 8 & 0xFF, addr & 0xFF);
                } else if (OsConstants.AF_INET6 == type) {
                    int addr1 = reply.readInt();
                    int addr2 = reply.readInt();
                    int addr3 = reply.readInt();
                    int addr4 = reply.readInt();
                    port = reply.readInt();
                    int flowinfo = reply.readInt();
                    int scope_id = reply.readInt();
                    addrStr = String.format(Locale.US, "[%04X:%04X:%04X:%04X:%04X:%04X:%04X:%04X]", addr1 >> 16 & 0xFFFF, addr1 & 0xFFFF, addr2 >> 16 & 0xFFFF, addr2 & 0xFFFF, addr3 >> 16 & 0xFFFF, addr3 & 0xFFFF, addr4 >> 16 & 0xFFFF, addr4 & 0xFFFF);
                }
                if (null != addrStr) {
                    ret_val = new InetSocketAddress(addrStr, port);
                }
            }
        }
        finally {
            reply.recycle();
            data.recycle();
        }
        return ret_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transactSetSockaddr(int method_code, InetSocketAddress addr) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        int ret_val = -1;
        try {
            data.writeInterfaceToken(this.mInterfaceDesc);
            if (null == addr) {
                data.writeInt(0);
            } else {
                data.writeInt(1);
                InetAddress a = addr.getAddress();
                byte[] b = a.getAddress();
                int p = addr.getPort();
                if (a instanceof Inet4Address) {
                    int v4addr = (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
                    data.writeInt(OsConstants.AF_INET);
                    data.writeInt(v4addr);
                    data.writeInt(p);
                } else if (a instanceof Inet6Address) {
                    Inet6Address v6 = (Inet6Address)a;
                    data.writeInt(OsConstants.AF_INET6);
                    for (int i = 0; i < 4; ++i) {
                        int aword = (b[i * 4 + 0] & 0xFF) << 24 | (b[i * 4 + 1] & 0xFF) << 16 | (b[i * 4 + 2] & 0xFF) << 8 | b[i * 4 + 3] & 0xFF;
                        data.writeInt(aword);
                    }
                    data.writeInt(p);
                    data.writeInt(0);
                    data.writeInt(v6.getScopeId());
                } else {
                    int n = -4;
                    return n;
                }
            }
            this.mRemote.transact(method_code, data, reply, 0);
            ret_val = reply.readInt();
        }
        catch (RemoteException e) {
            ret_val = -7;
        }
        finally {
            reply.recycle();
            data.recycle();
        }
        return ret_val;
    }
}

