/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Binder
implements IBinder {
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    private static final String TAG = "Binder";
    private static String sDumpDisabled = null;
    private long mObject;
    private IInterface mOwner;
    private String mDescriptor;

    public static int getCallingPid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingPid()I", true, null);
    }

    public static int getCallingUid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingUid()I", true, null);
    }

    public static UserHandle getCallingUserHandle() {
        return new UserHandle(UserHandle.getUserId(Binder.getCallingUid()));
    }

    public static long clearCallingIdentity() {
        return OverrideMethod.invokeL("android.os.Binder#clearCallingIdentity()J", true, null);
    }

    public static void restoreCallingIdentity(long l) {
        OverrideMethod.invokeV("android.os.Binder#restoreCallingIdentity(J)V", true, null);
    }

    public static void setThreadStrictModePolicy(int n) {
        OverrideMethod.invokeV("android.os.Binder#setThreadStrictModePolicy(I)V", true, null);
    }

    public static int getThreadStrictModePolicy() {
        return OverrideMethod.invokeI("android.os.Binder#getThreadStrictModePolicy()I", true, null);
    }

    public static void flushPendingCommands() {
        OverrideMethod.invokeV("android.os.Binder#flushPendingCommands()V", true, null);
    }

    public static void joinThreadPool() {
        OverrideMethod.invokeV("android.os.Binder#joinThreadPool()V", true, null);
    }

    public static boolean isProxy(IInterface iface) {
        return iface.asBinder() != iface;
    }

    public Binder() {
        this.init();
    }

    public void attachInterface(IInterface owner, String descriptor) {
        this.mOwner = owner;
        this.mDescriptor = descriptor;
    }

    public String getInterfaceDescriptor() {
        return this.mDescriptor;
    }

    public boolean pingBinder() {
        return true;
    }

    public boolean isBinderAlive() {
        return true;
    }

    public IInterface queryLocalInterface(String descriptor) {
        if (this.mDescriptor.equals(descriptor)) {
            return this.mOwner;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDumpDisabled(String msg) {
        Class<Binder> clazz = Binder.class;
        synchronized (Binder.class) {
            sDumpDisabled = msg;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == 1598968902) {
            reply.writeString(this.getInterfaceDescriptor());
            return true;
        }
        if (code == 1598311760) {
            ParcelFileDescriptor fd = data.readFileDescriptor();
            String[] args = data.readStringArray();
            if (fd != null) {
                try {
                    this.dump(fd.getFileDescriptor(), args);
                }
                finally {
                    try {
                        fd.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (reply != null) {
                reply.writeNoException();
            } else {
                StrictMode.clearGatheredViolations();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dump(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        try {
            Class<Binder> clazz = Binder.class;
            synchronized (Binder.class) {
                String disabled = sDumpDisabled;
                // ** MonitorExit[var6_5] (shouldn't be in output)
                if (disabled == null) {
                    try {
                        this.dump(fd, pw, args);
                        return;
                    }
                    catch (SecurityException e) {
                        pw.println("Security exception: " + e.getMessage());
                        throw e;
                    }
                    catch (Throwable e) {
                        ((PrintWriter)pw).println();
                        pw.println("Exception occurred while dumping:");
                        e.printStackTrace(pw);
                        return;
                    }
                }
                pw.println(sDumpDisabled);
                return;
            }
        }
        finally {
            ((PrintWriter)pw).flush();
        }
    }

    public void dumpAsync(final FileDescriptor fd, final String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        final FastPrintWriter pw = new FastPrintWriter(fout);
        Thread thr = new Thread("Binder.dumpAsync"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Binder.this.dump(fd, pw, args);
                }
                finally {
                    pw.flush();
                }
            }
        };
        thr.start();
    }

    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
    }

    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (data != null) {
            data.setDataPosition(0);
        }
        boolean r = this.onTransact(code, data, reply, flags);
        if (reply != null) {
            reply.setDataPosition(0);
        }
        return r;
    }

    public void linkToDeath(IBinder.DeathRecipient recipient, int flags) {
    }

    public boolean unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    private void init() {
        OverrideMethod.invokeV("android.os.Binder#init()V", true, this);
    }

    private void destroy() {
        OverrideMethod.invokeV("android.os.Binder#destroy()V", true, this);
    }

    private boolean execTransact(int code, long dataObj, long replyObj, int flags) {
        boolean res;
        Parcel data = Parcel.obtain(dataObj);
        Parcel reply = Parcel.obtain(replyObj);
        try {
            res = this.onTransact(code, data, reply, flags);
        }
        catch (RemoteException e) {
            if ((flags & 1) != 0) {
                Log.w(TAG, "Binder call failed.", e);
            }
            reply.setDataPosition(0);
            reply.writeException(e);
            res = true;
        }
        catch (RuntimeException e) {
            if ((flags & 1) != 0) {
                Log.w(TAG, "Caught a RuntimeException from the binder stub implementation.", e);
            }
            reply.setDataPosition(0);
            reply.writeException(e);
            res = true;
        }
        catch (OutOfMemoryError e) {
            Log.e(TAG, "Caught an OutOfMemoryError from the binder stub implementation.", e);
            RuntimeException re = new RuntimeException("Out of memory", e);
            reply.setDataPosition(0);
            reply.writeException(re);
            res = true;
        }
        reply.recycle();
        data.recycle();
        return res;
    }
}

