/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.os.Looper;
import android.util.Log;
import com.google.android.gles_jni.EGLImpl;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

public abstract class ManagedEGLContext {
    static final String TAG = "ManagedEGLContext";
    static final ArrayList<ManagedEGLContext> sActive = new ArrayList();
    final EGLContext mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedEGLContext(EGLContext context) {
        this.mContext = context;
        ArrayList<ManagedEGLContext> arrayList = sActive;
        synchronized (arrayList) {
            sActive.add(this);
        }
    }

    public EGLContext getContext() {
        return this.mContext;
    }

    public void terminate() {
        this.execTerminate();
    }

    void execTerminate() {
        this.onTerminate(this.mContext);
    }

    public abstract void onTerminate(EGLContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doTerminate() {
        ArrayList<ManagedEGLContext> active;
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("Called on wrong thread");
        }
        ArrayList<ManagedEGLContext> arrayList = sActive;
        synchronized (arrayList) {
            if (sActive.size() <= 0) {
                return false;
            }
            EGL10 egl = (EGL10)EGLContext.getEGL();
            EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (display == EGL10.EGL_NO_DISPLAY) {
                Log.w(TAG, "doTerminate failed: no display");
                return false;
            }
            if (EGLImpl.getInitCount(display) != sActive.size()) {
                Log.w(TAG, "doTerminate failed: EGL count is " + EGLImpl.getInitCount(display) + " but managed count is " + sActive.size());
                return false;
            }
            active = new ArrayList<ManagedEGLContext>(sActive);
            sActive.clear();
        }
        for (int i = 0; i < active.size(); ++i) {
            active.get(i).execTerminate();
        }
        return true;
    }
}

