/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.net.Uri;
import android.nfc.NdefMessage;
import android.os.Parcel;
import android.os.Parcelable;

public class BeamShareData
implements Parcelable {
    public final NdefMessage ndefMessage;
    public final Uri[] uris;
    public final int flags;
    public static final Parcelable.Creator<BeamShareData> CREATOR = new Parcelable.Creator<BeamShareData>(){

        @Override
        public BeamShareData createFromParcel(Parcel source) {
            Uri[] uris = null;
            NdefMessage msg = (NdefMessage)source.readParcelable(NdefMessage.class.getClassLoader());
            int numUris = source.readInt();
            if (numUris > 0) {
                uris = new Uri[numUris];
                source.readTypedArray(uris, Uri.CREATOR);
            }
            int flags = source.readInt();
            return new BeamShareData(msg, uris, flags);
        }

        public BeamShareData[] newArray(int size) {
            return new BeamShareData[size];
        }
    };

    public BeamShareData(NdefMessage msg, Uri[] uris, int flags) {
        this.ndefMessage = msg;
        this.uris = uris;
        this.flags = flags;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        int urisLength = this.uris != null ? this.uris.length : 0;
        dest.writeParcelable(this.ndefMessage, 0);
        dest.writeInt(urisLength);
        if (urisLength > 0) {
            dest.writeTypedArray(this.uris, 0);
        }
        dest.writeInt(this.flags);
    }
}

