/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.BatchedScanSettings;
import android.net.wifi.WpsInfo;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;
import java.util.Locale;

public class WifiNative {
    private static final boolean DBG = false;
    private final String mTAG;
    private static final int DEFAULT_GROUP_OWNER_INTENT = 6;
    static final int BLUETOOTH_COEXISTENCE_MODE_ENABLED = 0;
    static final int BLUETOOTH_COEXISTENCE_MODE_DISABLED = 1;
    static final int BLUETOOTH_COEXISTENCE_MODE_SENSE = 2;
    static final int SCAN_WITHOUT_CONNECTION_SETUP = 1;
    static final int SCAN_WITH_CONNECTION_SETUP = 2;
    static final Object mLock = new Object();
    public final String mInterfaceName;
    public final String mInterfacePrefix;
    private boolean mSuspendOptEnabled = false;
    private static final LocalLog mLocalLog = new LocalLog(1024);
    private int mCmdId;

    public static boolean loadDriver() {
        return OverrideMethod.invokeI("android.net.wifi.WifiNative#loadDriver()Z", true, null) != 0;
    }

    public static boolean isDriverLoaded() {
        return OverrideMethod.invokeI("android.net.wifi.WifiNative#isDriverLoaded()Z", true, null) != 0;
    }

    public static boolean unloadDriver() {
        return OverrideMethod.invokeI("android.net.wifi.WifiNative#unloadDriver()Z", true, null) != 0;
    }

    public static boolean startSupplicant(boolean bl) {
        return OverrideMethod.invokeI("android.net.wifi.WifiNative#startSupplicant(Z)Z", true, null) != 0;
    }

    public static boolean killSupplicant(boolean bl) {
        return OverrideMethod.invokeI("android.net.wifi.WifiNative#killSupplicant(Z)Z", true, null) != 0;
    }

    private boolean connectToSupplicantNative() {
        return OverrideMethod.invokeI("android.net.wifi.WifiNative#connectToSupplicantNative()Z", true, this) != 0;
    }

    private void closeSupplicantConnectionNative() {
        OverrideMethod.invokeV("android.net.wifi.WifiNative#closeSupplicantConnectionNative()V", true, this);
    }

    private String waitForEventNative() {
        return (String)OverrideMethod.invokeA("android.net.wifi.WifiNative#waitForEventNative()Ljava/lang/String;", true, this);
    }

    private boolean doBooleanCommandNative(String string2) {
        return OverrideMethod.invokeI("android.net.wifi.WifiNative#doBooleanCommandNative(Ljava/lang/String;)Z", true, this) != 0;
    }

    private int doIntCommandNative(String string2) {
        return OverrideMethod.invokeI("android.net.wifi.WifiNative#doIntCommandNative(Ljava/lang/String;)I", true, this);
    }

    private String doStringCommandNative(String string2) {
        return (String)OverrideMethod.invokeA("android.net.wifi.WifiNative#doStringCommandNative(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    public WifiNative(String interfaceName) {
        this.mInterfaceName = interfaceName;
        this.mTAG = "WifiNative-" + interfaceName;
        this.mInterfacePrefix = !interfaceName.equals("p2p0") ? "IFNAME=" + interfaceName + " " : "";
    }

    public LocalLog getLocalLog() {
        return mLocalLog;
    }

    private int getNewCmdIdLocked() {
        return this.mCmdId++;
    }

    private void localLog(String s) {
        if (mLocalLog != null) {
            mLocalLog.log(this.mInterfaceName + ": " + s);
        }
    }

    public boolean connectToSupplicant() {
        this.localLog(this.mInterfacePrefix + "connectToSupplicant");
        return this.connectToSupplicantNative();
    }

    public void closeSupplicantConnection() {
        this.localLog(this.mInterfacePrefix + "closeSupplicantConnection");
        this.closeSupplicantConnectionNative();
    }

    public String waitForEvent() {
        return this.waitForEventNative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doBooleanCommand(String command) {
        Object object = mLock;
        synchronized (object) {
            int cmdId = this.getNewCmdIdLocked();
            this.localLog(cmdId + "->" + this.mInterfacePrefix + command);
            boolean result = this.doBooleanCommandNative(this.mInterfacePrefix + command);
            this.localLog(cmdId + "<-" + result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doIntCommand(String command) {
        Object object = mLock;
        synchronized (object) {
            int cmdId = this.getNewCmdIdLocked();
            this.localLog(cmdId + "->" + this.mInterfacePrefix + command);
            int result = this.doIntCommandNative(this.mInterfacePrefix + command);
            this.localLog(cmdId + "<-" + result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doStringCommand(String command) {
        Object object = mLock;
        synchronized (object) {
            int cmdId = this.getNewCmdIdLocked();
            this.localLog(cmdId + "->" + this.mInterfacePrefix + command);
            String result = this.doStringCommandNative(this.mInterfacePrefix + command);
            this.localLog(cmdId + "<-" + result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doStringCommandWithoutLogging(String command) {
        Object object = mLock;
        synchronized (object) {
            return this.doStringCommandNative(this.mInterfacePrefix + command);
        }
    }

    public boolean ping() {
        String pong = this.doStringCommand("PING");
        return pong != null && pong.equals("PONG");
    }

    public boolean scan(int type) {
        if (type == 1) {
            return this.doBooleanCommand("SCAN TYPE=ONLY");
        }
        if (type == 2) {
            return this.doBooleanCommand("SCAN");
        }
        throw new IllegalArgumentException("Invalid scan type");
    }

    public boolean stopSupplicant() {
        return this.doBooleanCommand("TERMINATE");
    }

    public String listNetworks() {
        return this.doStringCommand("LIST_NETWORKS");
    }

    public int addNetwork() {
        return this.doIntCommand("ADD_NETWORK");
    }

    public boolean setNetworkVariable(int netId, String name, String value) {
        if (TextUtils.isEmpty(name) || TextUtils.isEmpty(value)) {
            return false;
        }
        return this.doBooleanCommand("SET_NETWORK " + netId + " " + name + " " + value);
    }

    public String getNetworkVariable(int netId, String name) {
        if (TextUtils.isEmpty(name)) {
            return null;
        }
        return this.doStringCommandWithoutLogging("GET_NETWORK " + netId + " " + name);
    }

    public boolean removeNetwork(int netId) {
        return this.doBooleanCommand("REMOVE_NETWORK " + netId);
    }

    public boolean enableNetwork(int netId, boolean disableOthers) {
        if (disableOthers) {
            return this.doBooleanCommand("SELECT_NETWORK " + netId);
        }
        return this.doBooleanCommand("ENABLE_NETWORK " + netId);
    }

    public boolean disableNetwork(int netId) {
        return this.doBooleanCommand("DISABLE_NETWORK " + netId);
    }

    public boolean reconnect() {
        return this.doBooleanCommand("RECONNECT");
    }

    public boolean reassociate() {
        return this.doBooleanCommand("REASSOCIATE");
    }

    public boolean disconnect() {
        return this.doBooleanCommand("DISCONNECT");
    }

    public String status() {
        return this.doStringCommand("STATUS");
    }

    public String getMacAddress() {
        String[] tokens;
        String ret = this.doStringCommand("DRIVER MACADDR");
        if (!TextUtils.isEmpty(ret) && (tokens = ret.split(" = ")).length == 2) {
            return tokens[1];
        }
        return null;
    }

    public String scanResults(int sid) {
        return this.doStringCommandWithoutLogging("BSS RANGE=" + sid + "- MASK=0x21987");
    }

    public String setBatchedScanSettings(BatchedScanSettings settings) {
        if (settings == null) {
            return this.doStringCommand("DRIVER WLS_BATCHING STOP");
        }
        String cmd = "DRIVER WLS_BATCHING SET SCANFREQ=" + settings.scanIntervalSec;
        cmd = cmd + " MSCAN=" + settings.maxScansPerBatch;
        if (settings.maxApPerScan != Integer.MAX_VALUE) {
            cmd = cmd + " BESTN=" + settings.maxApPerScan;
        }
        if (settings.channelSet != null && !settings.channelSet.isEmpty()) {
            cmd = cmd + " CHANNEL=<";
            int i = 0;
            for (String channel : settings.channelSet) {
                cmd = cmd + (i > 0 ? "," : "") + channel;
                ++i;
            }
            cmd = cmd + ">";
        }
        if (settings.maxApForDistance != Integer.MAX_VALUE) {
            cmd = cmd + " RTT=" + settings.maxApForDistance;
        }
        return this.doStringCommand(cmd);
    }

    public String getBatchedScanResults() {
        return this.doStringCommand("DRIVER WLS_BATCHING GET");
    }

    public boolean startDriver() {
        return this.doBooleanCommand("DRIVER START");
    }

    public boolean stopDriver() {
        return this.doBooleanCommand("DRIVER STOP");
    }

    public boolean startFilteringMulticastV4Packets() {
        return this.doBooleanCommand("DRIVER RXFILTER-STOP") && this.doBooleanCommand("DRIVER RXFILTER-REMOVE 2") && this.doBooleanCommand("DRIVER RXFILTER-START");
    }

    public boolean stopFilteringMulticastV4Packets() {
        return this.doBooleanCommand("DRIVER RXFILTER-STOP") && this.doBooleanCommand("DRIVER RXFILTER-ADD 2") && this.doBooleanCommand("DRIVER RXFILTER-START");
    }

    public boolean startFilteringMulticastV6Packets() {
        return this.doBooleanCommand("DRIVER RXFILTER-STOP") && this.doBooleanCommand("DRIVER RXFILTER-REMOVE 3") && this.doBooleanCommand("DRIVER RXFILTER-START");
    }

    public boolean stopFilteringMulticastV6Packets() {
        return this.doBooleanCommand("DRIVER RXFILTER-STOP") && this.doBooleanCommand("DRIVER RXFILTER-ADD 3") && this.doBooleanCommand("DRIVER RXFILTER-START");
    }

    public int getBand() {
        String ret = this.doStringCommand("DRIVER GETBAND");
        if (!TextUtils.isEmpty(ret)) {
            String[] tokens = ret.split(" ");
            try {
                if (tokens.length == 2) {
                    return Integer.parseInt(tokens[1]);
                }
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public boolean setBand(int band) {
        return this.doBooleanCommand("DRIVER SETBAND " + band);
    }

    public boolean setBluetoothCoexistenceMode(int mode) {
        return this.doBooleanCommand("DRIVER BTCOEXMODE " + mode);
    }

    public boolean setBluetoothCoexistenceScanMode(boolean setCoexScanMode) {
        if (setCoexScanMode) {
            return this.doBooleanCommand("DRIVER BTCOEXSCAN-START");
        }
        return this.doBooleanCommand("DRIVER BTCOEXSCAN-STOP");
    }

    public boolean saveConfig() {
        return this.doBooleanCommand("SAVE_CONFIG");
    }

    public boolean addToBlacklist(String bssid) {
        if (TextUtils.isEmpty(bssid)) {
            return false;
        }
        return this.doBooleanCommand("BLACKLIST " + bssid);
    }

    public boolean clearBlacklist() {
        return this.doBooleanCommand("BLACKLIST clear");
    }

    public boolean setSuspendOptimizations(boolean enabled) {
        if (this.mSuspendOptEnabled == enabled) {
            return true;
        }
        this.mSuspendOptEnabled = enabled;
        if (enabled) {
            return this.doBooleanCommand("DRIVER SETSUSPENDMODE 1");
        }
        return this.doBooleanCommand("DRIVER SETSUSPENDMODE 0");
    }

    public boolean setCountryCode(String countryCode) {
        return this.doBooleanCommand("DRIVER COUNTRY " + countryCode.toUpperCase(Locale.ROOT));
    }

    public void enableBackgroundScan(boolean enable) {
        if (enable) {
            this.doBooleanCommand("SET pno 1");
        } else {
            this.doBooleanCommand("SET pno 0");
        }
    }

    public void setScanInterval(int scanInterval) {
        this.doBooleanCommand("SCAN_INTERVAL " + scanInterval);
    }

    public void startTdls(String macAddr, boolean enable) {
        if (enable) {
            this.doBooleanCommand("TDLS_DISCOVER " + macAddr);
            this.doBooleanCommand("TDLS_SETUP " + macAddr);
        } else {
            this.doBooleanCommand("TDLS_TEARDOWN " + macAddr);
        }
    }

    public String signalPoll() {
        return this.doStringCommandWithoutLogging("SIGNAL_POLL");
    }

    public String pktcntPoll() {
        return this.doStringCommand("PKTCNT_POLL");
    }

    public void bssFlush() {
        this.doBooleanCommand("BSS_FLUSH 0");
    }

    public boolean startWpsPbc(String bssid) {
        if (TextUtils.isEmpty(bssid)) {
            return this.doBooleanCommand("WPS_PBC");
        }
        return this.doBooleanCommand("WPS_PBC " + bssid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startWpsPbc(String iface, String bssid) {
        Object object = mLock;
        synchronized (object) {
            if (TextUtils.isEmpty(bssid)) {
                return this.doBooleanCommandNative("IFNAME=" + iface + " WPS_PBC");
            }
            return this.doBooleanCommandNative("IFNAME=" + iface + " WPS_PBC " + bssid);
        }
    }

    public boolean startWpsPinKeypad(String pin) {
        if (TextUtils.isEmpty(pin)) {
            return false;
        }
        return this.doBooleanCommand("WPS_PIN any " + pin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startWpsPinKeypad(String iface, String pin) {
        if (TextUtils.isEmpty(pin)) {
            return false;
        }
        Object object = mLock;
        synchronized (object) {
            return this.doBooleanCommandNative("IFNAME=" + iface + " WPS_PIN any " + pin);
        }
    }

    public String startWpsPinDisplay(String bssid) {
        if (TextUtils.isEmpty(bssid)) {
            return this.doStringCommand("WPS_PIN any");
        }
        return this.doStringCommand("WPS_PIN " + bssid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startWpsPinDisplay(String iface, String bssid) {
        Object object = mLock;
        synchronized (object) {
            if (TextUtils.isEmpty(bssid)) {
                return this.doStringCommandNative("IFNAME=" + iface + " WPS_PIN any");
            }
            return this.doStringCommandNative("IFNAME=" + iface + " WPS_PIN " + bssid);
        }
    }

    public boolean startWpsRegistrar(String bssid, String pin) {
        if (TextUtils.isEmpty(bssid) || TextUtils.isEmpty(pin)) {
            return false;
        }
        return this.doBooleanCommand("WPS_REG " + bssid + " " + pin);
    }

    public boolean cancelWps() {
        return this.doBooleanCommand("WPS_CANCEL");
    }

    public boolean setPersistentReconnect(boolean enabled) {
        int value = enabled ? 1 : 0;
        return this.doBooleanCommand("SET persistent_reconnect " + value);
    }

    public boolean setDeviceName(String name) {
        return this.doBooleanCommand("SET device_name " + name);
    }

    public boolean setDeviceType(String type) {
        return this.doBooleanCommand("SET device_type " + type);
    }

    public boolean setConfigMethods(String cfg) {
        return this.doBooleanCommand("SET config_methods " + cfg);
    }

    public boolean setManufacturer(String value) {
        return this.doBooleanCommand("SET manufacturer " + value);
    }

    public boolean setModelName(String value) {
        return this.doBooleanCommand("SET model_name " + value);
    }

    public boolean setModelNumber(String value) {
        return this.doBooleanCommand("SET model_number " + value);
    }

    public boolean setSerialNumber(String value) {
        return this.doBooleanCommand("SET serial_number " + value);
    }

    public boolean setP2pSsidPostfix(String postfix) {
        return this.doBooleanCommand("SET p2p_ssid_postfix " + postfix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setP2pGroupIdle(String iface, int time) {
        Object object = mLock;
        synchronized (object) {
            return this.doBooleanCommandNative("IFNAME=" + iface + " SET p2p_group_idle " + time);
        }
    }

    public void setPowerSave(boolean enabled) {
        if (enabled) {
            this.doBooleanCommand("SET ps 1");
        } else {
            this.doBooleanCommand("SET ps 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setP2pPowerSave(String iface, boolean enabled) {
        Object object = mLock;
        synchronized (object) {
            if (enabled) {
                return this.doBooleanCommandNative("IFNAME=" + iface + " P2P_SET ps 1");
            }
            return this.doBooleanCommandNative("IFNAME=" + iface + " P2P_SET ps 0");
        }
    }

    public boolean setWfdEnable(boolean enable) {
        return this.doBooleanCommand("SET wifi_display " + (enable ? "1" : "0"));
    }

    public boolean setWfdDeviceInfo(String hex) {
        return this.doBooleanCommand("WFD_SUBELEM_SET 0 " + hex);
    }

    public boolean setConcurrencyPriority(String s) {
        return this.doBooleanCommand("P2P_SET conc_pref " + s);
    }

    public boolean p2pFind() {
        return this.doBooleanCommand("P2P_FIND");
    }

    public boolean p2pFind(int timeout) {
        if (timeout <= 0) {
            return this.p2pFind();
        }
        return this.doBooleanCommand("P2P_FIND " + timeout);
    }

    public boolean p2pStopFind() {
        return this.doBooleanCommand("P2P_STOP_FIND");
    }

    public boolean p2pListen() {
        return this.doBooleanCommand("P2P_LISTEN");
    }

    public boolean p2pListen(int timeout) {
        if (timeout <= 0) {
            return this.p2pListen();
        }
        return this.doBooleanCommand("P2P_LISTEN " + timeout);
    }

    public boolean p2pExtListen(boolean enable, int period, int interval) {
        if (enable && interval < period) {
            return false;
        }
        return this.doBooleanCommand("P2P_EXT_LISTEN" + (enable ? " " + period + " " + interval : ""));
    }

    public boolean p2pSetChannel(int lc, int oc) {
        if (lc >= 1 && lc <= 11 ? !this.doBooleanCommand("P2P_SET listen_channel " + lc) : lc != 0) {
            return false;
        }
        if (oc >= 1 && oc <= 165) {
            int freq = (oc <= 14 ? 2407 : 5000) + oc * 5;
            return this.doBooleanCommand("P2P_SET disallow_freq 1000-" + (freq - 5) + "," + (freq + 5) + "-6000");
        }
        if (oc == 0) {
            return this.doBooleanCommand("P2P_SET disallow_freq \"\"");
        }
        return false;
    }

    public boolean p2pFlush() {
        return this.doBooleanCommand("P2P_FLUSH");
    }

    public String p2pConnect(WifiP2pConfig config, boolean joinExistingGroup) {
        if (config == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        WpsInfo wps = config.wps;
        args.add(config.deviceAddress);
        switch (wps.setup) {
            case 0: {
                args.add("pbc");
                break;
            }
            case 1: {
                if (TextUtils.isEmpty(wps.pin)) {
                    args.add("pin");
                } else {
                    args.add(wps.pin);
                }
                args.add("display");
                break;
            }
            case 2: {
                args.add(wps.pin);
                args.add("keypad");
                break;
            }
            case 3: {
                args.add(wps.pin);
                args.add("label");
            }
        }
        if (config.netId == -2) {
            args.add("persistent");
        }
        if (joinExistingGroup) {
            args.add("join");
        } else {
            int groupOwnerIntent = config.groupOwnerIntent;
            if (groupOwnerIntent < 0 || groupOwnerIntent > 15) {
                groupOwnerIntent = 6;
            }
            args.add("go_intent=" + groupOwnerIntent);
        }
        String command = "P2P_CONNECT ";
        for (String s : args) {
            command = command + s + " ";
        }
        return this.doStringCommand(command);
    }

    public boolean p2pCancelConnect() {
        return this.doBooleanCommand("P2P_CANCEL");
    }

    public boolean p2pProvisionDiscovery(WifiP2pConfig config) {
        if (config == null) {
            return false;
        }
        switch (config.wps.setup) {
            case 0: {
                return this.doBooleanCommand("P2P_PROV_DISC " + config.deviceAddress + " pbc");
            }
            case 1: {
                return this.doBooleanCommand("P2P_PROV_DISC " + config.deviceAddress + " keypad");
            }
            case 2: {
                return this.doBooleanCommand("P2P_PROV_DISC " + config.deviceAddress + " display");
            }
        }
        return false;
    }

    public boolean p2pGroupAdd(boolean persistent) {
        if (persistent) {
            return this.doBooleanCommand("P2P_GROUP_ADD persistent");
        }
        return this.doBooleanCommand("P2P_GROUP_ADD");
    }

    public boolean p2pGroupAdd(int netId) {
        return this.doBooleanCommand("P2P_GROUP_ADD persistent=" + netId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean p2pGroupRemove(String iface) {
        if (TextUtils.isEmpty(iface)) {
            return false;
        }
        Object object = mLock;
        synchronized (object) {
            return this.doBooleanCommandNative("IFNAME=" + iface + " P2P_GROUP_REMOVE " + iface);
        }
    }

    public boolean p2pReject(String deviceAddress) {
        return this.doBooleanCommand("P2P_REJECT " + deviceAddress);
    }

    public boolean p2pInvite(WifiP2pGroup group, String deviceAddress) {
        if (TextUtils.isEmpty(deviceAddress)) {
            return false;
        }
        if (group == null) {
            return this.doBooleanCommand("P2P_INVITE peer=" + deviceAddress);
        }
        return this.doBooleanCommand("P2P_INVITE group=" + group.getInterface() + " peer=" + deviceAddress + " go_dev_addr=" + group.getOwner().deviceAddress);
    }

    public boolean p2pReinvoke(int netId, String deviceAddress) {
        if (TextUtils.isEmpty(deviceAddress) || netId < 0) {
            return false;
        }
        return this.doBooleanCommand("P2P_INVITE persistent=" + netId + " peer=" + deviceAddress);
    }

    public String p2pGetSsid(String deviceAddress) {
        return this.p2pGetParam(deviceAddress, "oper_ssid");
    }

    public String p2pGetDeviceAddress() {
        String[] tokens;
        String status = this.status();
        if (status == null) {
            return "";
        }
        for (String token : tokens = status.split("\n")) {
            if (!token.startsWith("p2p_device_address=")) continue;
            String[] nameValue = token.split("=");
            if (nameValue.length != 2) break;
            return nameValue[1];
        }
        return "";
    }

    public int getGroupCapability(String deviceAddress) {
        String[] tokens;
        int gc = 0;
        if (TextUtils.isEmpty(deviceAddress)) {
            return gc;
        }
        String peerInfo = this.p2pPeer(deviceAddress);
        if (TextUtils.isEmpty(peerInfo)) {
            return gc;
        }
        for (String token : tokens = peerInfo.split("\n")) {
            if (!token.startsWith("group_capab=")) continue;
            String[] nameValue = token.split("=");
            if (nameValue.length != 2) break;
            try {
                return Integer.decode(nameValue[1]);
            }
            catch (NumberFormatException e) {
                return gc;
            }
        }
        return gc;
    }

    public String p2pPeer(String deviceAddress) {
        return this.doStringCommand("P2P_PEER " + deviceAddress);
    }

    private String p2pGetParam(String deviceAddress, String key) {
        if (deviceAddress == null) {
            return null;
        }
        String peerInfo = this.p2pPeer(deviceAddress);
        if (peerInfo == null) {
            return null;
        }
        String[] tokens = peerInfo.split("\n");
        key = key + "=";
        for (String token : tokens) {
            if (!token.startsWith(key)) continue;
            String[] nameValue = token.split("=");
            if (nameValue.length != 2) break;
            return nameValue[1];
        }
        return null;
    }

    public boolean p2pServiceAdd(WifiP2pServiceInfo servInfo) {
        for (String s : servInfo.getSupplicantQueryList()) {
            String command = "P2P_SERVICE_ADD";
            if (this.doBooleanCommand(command = command + " " + s)) continue;
            return false;
        }
        return true;
    }

    public boolean p2pServiceDel(WifiP2pServiceInfo servInfo) {
        for (String s : servInfo.getSupplicantQueryList()) {
            String command = "P2P_SERVICE_DEL ";
            String[] data = s.split(" ");
            if (data.length < 2) {
                return false;
            }
            if ("upnp".equals(data[0])) {
                command = command + s;
            } else if ("bonjour".equals(data[0])) {
                command = command + data[0];
                command = command + " " + data[1];
            } else {
                return false;
            }
            if (this.doBooleanCommand(command)) continue;
            return false;
        }
        return true;
    }

    public boolean p2pServiceFlush() {
        return this.doBooleanCommand("P2P_SERVICE_FLUSH");
    }

    public String p2pServDiscReq(String addr, String query) {
        String command = "P2P_SERV_DISC_REQ";
        command = command + " " + addr;
        command = command + " " + query;
        return this.doStringCommand(command);
    }

    public boolean p2pServDiscCancelReq(String id2) {
        return this.doBooleanCommand("P2P_SERV_DISC_CANCEL_REQ " + id2);
    }

    public void setMiracastMode(int mode) {
        this.doBooleanCommand("DRIVER MIRACAST " + mode);
    }
}

