/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.media.IRemoteControlDisplay;
import android.media.MediaFocusControl;
import android.media.MediaMetadataEditor;
import android.media.Rating;
import android.media.RemoteControlClient;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.ref.WeakReference;

public class RemoteController {
    private static final int MAX_BITMAP_DIMENSION = 512;
    private static final int TRANSPORT_UNKNOWN = 0;
    private static final String TAG = "RemoteController";
    private static final boolean DEBUG = false;
    private static final Object mGenLock = new Object();
    private static final Object mInfoLock = new Object();
    private final RcDisplay mRcd;
    private final Context mContext;
    private final AudioManager mAudioManager;
    private final int mMaxBitmapDimension;
    private MetadataEditor mMetadataEditor;
    private int mClientGenerationIdCurrent = 0;
    private boolean mIsRegistered = false;
    private PendingIntent mClientPendingIntentCurrent;
    private OnClientUpdateListener mOnClientUpdateListener;
    private PlaybackInfo mLastPlaybackInfo;
    private int mArtworkWidth = -1;
    private int mArtworkHeight = -1;
    private boolean mEnabled = true;
    public static final int POSITION_SYNCHRONIZATION_NONE = 0;
    public static final int POSITION_SYNCHRONIZATION_CHECK = 1;
    private final EventHandler mEventHandler;
    private static final int MSG_NEW_PENDING_INTENT = 0;
    private static final int MSG_NEW_PLAYBACK_INFO = 1;
    private static final int MSG_NEW_TRANSPORT_INFO = 2;
    private static final int MSG_NEW_METADATA = 3;
    private static final int MSG_CLIENT_CHANGE = 4;
    private static final int MSG_DISPLAY_ENABLE = 5;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;

    public RemoteController(Context context, OnClientUpdateListener updateListener) throws IllegalArgumentException {
        this(context, updateListener, null);
    }

    public RemoteController(Context context, OnClientUpdateListener updateListener, Looper looper) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("Invalid null Context");
        }
        if (updateListener == null) {
            throw new IllegalArgumentException("Invalid null OnClientUpdateListener");
        }
        if (looper != null) {
            this.mEventHandler = new EventHandler(this, looper);
        } else {
            Looper l = Looper.myLooper();
            if (l != null) {
                this.mEventHandler = new EventHandler(this, l);
            } else {
                throw new IllegalArgumentException("Calling thread not associated with a looper");
            }
        }
        this.mOnClientUpdateListener = updateListener;
        this.mContext = context;
        this.mRcd = new RcDisplay(this);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.mMaxBitmapDimension = 512;
        } else {
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            this.mMaxBitmapDimension = Math.max(dm.widthPixels, dm.heightPixels);
        }
    }

    public String getRemoteControlClientPackageName() {
        return this.mClientPendingIntentCurrent != null ? this.mClientPendingIntentCurrent.getCreatorPackage() : null;
    }

    public long getEstimatedMediaPosition() {
        if (this.mLastPlaybackInfo != null) {
            if (!RemoteControlClient.playbackPositionShouldMove(this.mLastPlaybackInfo.mState)) {
                return this.mLastPlaybackInfo.mCurrentPosMs;
            }
            long thenPos = this.mLastPlaybackInfo.mCurrentPosMs;
            if (thenPos < 0L) {
                return -1L;
            }
            long now = SystemClock.elapsedRealtime();
            long then = this.mLastPlaybackInfo.mStateChangeTimeMs;
            long sinceThen = now - then;
            long scaledSinceThen = (long)((float)sinceThen * this.mLastPlaybackInfo.mSpeed);
            return thenPos + scaledSinceThen;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMediaKeyEvent(KeyEvent keyEvent) throws IllegalArgumentException {
        PendingIntent pi;
        if (!MediaFocusControl.isMediaKeyCode(keyEvent.getKeyCode())) {
            throw new IllegalArgumentException("not a media key event");
        }
        Object object = mInfoLock;
        synchronized (object) {
            if (!this.mIsRegistered) {
                Log.e(TAG, "Cannot use sendMediaKeyEvent() from an unregistered RemoteController");
                return false;
            }
            if (!this.mEnabled) {
                Log.e(TAG, "Cannot use sendMediaKeyEvent() from a disabled RemoteController");
                return false;
            }
            pi = this.mClientPendingIntentCurrent;
        }
        if (pi != null) {
            Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
            intent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
            try {
                pi.send(this.mContext, 0, intent);
            }
            catch (PendingIntent.CanceledException e) {
                Log.e(TAG, "Error sending intent for media button down: ", e);
                return false;
            }
        } else {
            Log.i(TAG, "No-op when sending key click, no receiver right now");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean seekTo(long timeMs) throws IllegalArgumentException {
        int genId;
        if (!this.mEnabled) {
            Log.e(TAG, "Cannot use seekTo() from a disabled RemoteController");
            return false;
        }
        if (timeMs < 0L) {
            throw new IllegalArgumentException("illegal negative time value");
        }
        Object object = mGenLock;
        synchronized (object) {
            genId = this.mClientGenerationIdCurrent;
        }
        this.mAudioManager.setRemoteControlClientPlaybackPosition(genId, timeMs);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setArtworkConfiguration(boolean wantBitmap, int width, int height) throws IllegalArgumentException {
        Object object = mInfoLock;
        synchronized (object) {
            if (wantBitmap) {
                if (width <= 0 || height <= 0) throw new IllegalArgumentException("Invalid dimensions");
                if (width > this.mMaxBitmapDimension) {
                    width = this.mMaxBitmapDimension;
                }
                if (height > this.mMaxBitmapDimension) {
                    height = this.mMaxBitmapDimension;
                }
                this.mArtworkWidth = width;
                this.mArtworkHeight = height;
            } else {
                this.mArtworkWidth = -1;
                this.mArtworkHeight = -1;
            }
            if (!this.mIsRegistered) return true;
            this.mAudioManager.remoteControlDisplayUsesBitmapSize(this.mRcd, this.mArtworkWidth, this.mArtworkHeight);
            return true;
        }
    }

    public boolean setArtworkConfiguration(int width, int height) throws IllegalArgumentException {
        return this.setArtworkConfiguration(true, width, height);
    }

    public boolean clearArtworkConfiguration() {
        return this.setArtworkConfiguration(false, -1, -1);
    }

    public boolean setSynchronizationMode(int sync) throws IllegalArgumentException {
        if (sync != 0 && sync != 1) {
            throw new IllegalArgumentException("Unknown synchronization mode " + sync);
        }
        if (!this.mIsRegistered) {
            Log.e(TAG, "Cannot set synchronization mode on an unregistered RemoteController");
            return false;
        }
        this.mAudioManager.remoteControlDisplayWantsPlaybackPositionSync(this.mRcd, 1 == sync);
        return true;
    }

    public MetadataEditor editMetadata() {
        MetadataEditor editor = new MetadataEditor();
        editor.mEditorMetadata = new Bundle();
        editor.mEditorArtwork = null;
        editor.mMetadataChanged = true;
        editor.mArtworkChanged = true;
        editor.mEditableKeys = 0L;
        return editor;
    }

    private static void sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delayMs) {
        if (handler == null) {
            Log.e(TAG, "null event handler, will not deliver message " + msg);
            return;
        }
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delayMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewPendingIntent(int genId, PendingIntent pi) {
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        object = mInfoLock;
        synchronized (object) {
            this.mClientPendingIntentCurrent = pi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewPlaybackInfo(int genId, PlaybackInfo pi) {
        OnClientUpdateListener l;
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        Object object2 = mInfoLock;
        synchronized (object2) {
            l = this.mOnClientUpdateListener;
            this.mLastPlaybackInfo = pi;
        }
        if (l != null) {
            if (pi.mCurrentPosMs == -9216204211029966080L) {
                l.onClientPlaybackStateUpdate(pi.mState);
            } else {
                l.onClientPlaybackStateUpdate(pi.mState, pi.mStateChangeTimeMs, pi.mCurrentPosMs, pi.mSpeed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewTransportInfo(int genId, int transportControlFlags) {
        OnClientUpdateListener l;
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        Object object2 = mInfoLock;
        synchronized (object2) {
            l = this.mOnClientUpdateListener;
        }
        if (l != null) {
            l.onClientTransportControlUpdate(transportControlFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewMetadata(int genId, Bundle metadata) {
        MetadataEditor metadataEditor;
        OnClientUpdateListener l;
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        long editableKeys = metadata.getLong(String.valueOf(0x1FFFFFFF), 0L);
        if (editableKeys != 0L) {
            metadata.remove(String.valueOf(0x1FFFFFFF));
        }
        Object object2 = mInfoLock;
        synchronized (object2) {
            l = this.mOnClientUpdateListener;
            if (this.mMetadataEditor != null && this.mMetadataEditor.mEditorMetadata != null) {
                if (this.mMetadataEditor.mEditorMetadata != metadata) {
                    this.mMetadataEditor.mEditorMetadata.putAll(metadata);
                }
                this.mMetadataEditor.putBitmap(100, (Bitmap)metadata.getParcelable(String.valueOf(100)));
                this.mMetadataEditor.cleanupBitmapFromBundle(100);
            } else {
                this.mMetadataEditor = new MetadataEditor(metadata, editableKeys);
            }
            metadataEditor = this.mMetadataEditor;
        }
        if (l != null) {
            l.onClientMetadataUpdate(metadataEditor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClientChange(int genId, boolean clearing) {
        OnClientUpdateListener l;
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        Object object2 = mInfoLock;
        synchronized (object2) {
            l = this.mOnClientUpdateListener;
            this.mMetadataEditor = null;
        }
        if (l != null) {
            l.onClientChange(clearing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisplayEnable(boolean enabled) {
        Object object = mInfoLock;
        synchronized (object) {
            this.mEnabled = enabled;
            OnClientUpdateListener l = this.mOnClientUpdateListener;
        }
        if (!enabled) {
            int genId;
            Object object2 = mGenLock;
            synchronized (object2) {
                genId = this.mClientGenerationIdCurrent;
            }
            PlaybackInfo pi = new PlaybackInfo(1, SystemClock.elapsedRealtime(), 0L, 0.0f);
            RemoteController.sendMsg(this.mEventHandler, 1, 0, genId, 0, pi, 0);
            RemoteController.sendMsg(this.mEventHandler, 2, 0, genId, 0, null, 0);
            Bundle metadata = new Bundle(3);
            metadata.putString(String.valueOf(7), "");
            metadata.putString(String.valueOf(2), "");
            metadata.putLong(String.valueOf(9), 0L);
            RemoteController.sendMsg(this.mEventHandler, 3, 2, genId, 0, metadata, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsRegistered(boolean registered) {
        Object object = mInfoLock;
        synchronized (object) {
            this.mIsRegistered = registered;
        }
    }

    RcDisplay getRcDisplay() {
        return this.mRcd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getArtworkSize() {
        Object object = mInfoLock;
        synchronized (object) {
            int[] size = new int[]{this.mArtworkWidth, this.mArtworkHeight};
            return size;
        }
    }

    OnClientUpdateListener getUpdateListener() {
        return this.mOnClientUpdateListener;
    }

    private static class PlaybackInfo {
        int mState;
        long mStateChangeTimeMs;
        long mCurrentPosMs;
        float mSpeed;

        PlaybackInfo(int state, long stateChangeTimeMs, long currentPosMs, float speed) {
            this.mState = state;
            this.mStateChangeTimeMs = stateChangeTimeMs;
            this.mCurrentPosMs = currentPosMs;
            this.mSpeed = speed;
        }
    }

    private class EventHandler
    extends Handler {
        public EventHandler(RemoteController rc, Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    RemoteController.this.onNewPendingIntent(msg.arg1, (PendingIntent)msg.obj);
                    break;
                }
                case 1: {
                    RemoteController.this.onNewPlaybackInfo(msg.arg1, (PlaybackInfo)msg.obj);
                    break;
                }
                case 2: {
                    RemoteController.this.onNewTransportInfo(msg.arg1, msg.arg2);
                    break;
                }
                case 3: {
                    RemoteController.this.onNewMetadata(msg.arg1, (Bundle)msg.obj);
                    break;
                }
                case 4: {
                    RemoteController.this.onClientChange(msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 5: {
                    RemoteController.this.onDisplayEnable(msg.arg1 == 1);
                    break;
                }
                default: {
                    Log.e(RemoteController.TAG, "unknown event " + msg.what);
                }
            }
        }
    }

    private static class RcDisplay
    extends IRemoteControlDisplay.Stub {
        private final WeakReference<RemoteController> mController;

        RcDisplay(RemoteController rc) {
            this.mController = new WeakReference<RemoteController>(rc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCurrentClientId(int genId, PendingIntent clientMediaIntent, boolean clearing) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            boolean isNew = false;
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    rc.mClientGenerationIdCurrent = genId;
                    isNew = true;
                }
            }
            if (clientMediaIntent != null) {
                RemoteController.sendMsg(rc.mEventHandler, 0, 0, genId, 0, clientMediaIntent, 0);
            }
            if (isNew || clearing) {
                RemoteController.sendMsg(rc.mEventHandler, 4, 0, genId, clearing ? 1 : 0, null, 0);
            }
        }

        public void setEnabled(boolean enabled) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            RemoteController.sendMsg(rc.mEventHandler, 5, 0, enabled ? 1 : 0, 0, null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPlaybackState(int genId, int state, long stateChangeTimeMs, long currentPosMs, float speed) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            PlaybackInfo playbackInfo = new PlaybackInfo(state, stateChangeTimeMs, currentPosMs, speed);
            RemoteController.sendMsg(rc.mEventHandler, 1, 0, genId, 0, playbackInfo, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTransportControlInfo(int genId, int transportControlFlags, int posCapabilities) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            RemoteController.sendMsg(rc.mEventHandler, 2, 0, genId, transportControlFlags, null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMetadata(int genId, Bundle metadata) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            if (metadata == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            RemoteController.sendMsg(rc.mEventHandler, 3, 2, genId, 0, metadata, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setArtwork(int genId, Bitmap artwork) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            Bundle metadata = new Bundle(1);
            metadata.putParcelable(String.valueOf(100), artwork);
            RemoteController.sendMsg(rc.mEventHandler, 3, 2, genId, 0, metadata, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAllMetadata(int genId, Bundle metadata, Bitmap artwork) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            if (metadata == null && artwork == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            if (metadata == null) {
                metadata = new Bundle(1);
            }
            if (artwork != null) {
                metadata.putParcelable(String.valueOf(100), artwork);
            }
            RemoteController.sendMsg(rc.mEventHandler, 3, 2, genId, 0, metadata, 0);
        }
    }

    public class MetadataEditor
    extends MediaMetadataEditor {
        protected MetadataEditor() {
        }

        protected MetadataEditor(Bundle metadata, long editableKeys) {
            this.mEditorMetadata = metadata;
            this.mEditableKeys = editableKeys;
            this.mEditorArtwork = (Bitmap)metadata.getParcelable(String.valueOf(100));
            if (this.mEditorArtwork != null) {
                this.cleanupBitmapFromBundle(100);
            }
            this.mMetadataChanged = true;
            this.mArtworkChanged = true;
            this.mApplied = false;
        }

        private void cleanupBitmapFromBundle(int key) {
            if (METADATA_KEYS_TYPE.get(key, -1) == 2) {
                this.mEditorMetadata.remove(String.valueOf(key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void apply() {
            int genId;
            if (!this.mMetadataChanged) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                genId = RemoteController.this.mClientGenerationIdCurrent;
            }
            object = mInfoLock;
            synchronized (object) {
                if (this.mEditorMetadata.containsKey(String.valueOf(0x10000001))) {
                    Rating rating = (Rating)this.getObject(0x10000001, null);
                    RemoteController.this.mAudioManager.updateRemoteControlClientMetadata(genId, 0x10000001, rating);
                } else {
                    Log.e(RemoteController.TAG, "no metadata to apply");
                }
                this.mApplied = false;
            }
        }
    }

    public static interface OnClientUpdateListener {
        public void onClientChange(boolean var1);

        public void onClientPlaybackStateUpdate(int var1);

        public void onClientPlaybackStateUpdate(int var1, long var2, long var4, float var6);

        public void onClientTransportControlUpdate(int var1);

        public void onClientMetadataUpdate(MetadataEditor var1);
    }
}

