/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.media.MediaFormat;
import android.media.MediaTimeProvider;
import android.media.Metadata;
import android.media.SubtitleController;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.TimedText;
import android.net.ProxyProperties;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaPlayer
implements SubtitleController.Listener {
    public static final boolean METADATA_UPDATE_ONLY = true;
    public static final boolean METADATA_ALL = false;
    public static final boolean APPLY_METADATA_FILTER = true;
    public static final boolean BYPASS_METADATA_FILTER = false;
    private static final String TAG = "MediaPlayer";
    private static final String IMEDIA_PLAYER = "android.media.IMediaPlayer";
    private long mNativeContext;
    private long mNativeSurfaceTexture;
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private static final int INVOKE_ID_GET_TRACK_INFO = 1;
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE = 2;
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE_FD = 3;
    private static final int INVOKE_ID_SELECT_TRACK = 4;
    private static final int INVOKE_ID_DESELECT_TRACK = 5;
    private static final int INVOKE_ID_SET_VIDEO_SCALE_MODE = 6;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static final String MEDIA_MIMETYPE_TEXT_SUBRIP = "application/x-subrip";
    public static final String MEDIA_MIMETYPE_TEXT_VTT = "text/vtt";
    private SubtitleController mSubtitleController;
    private SubtitleTrack[] mInbandSubtitleTracks;
    private int mSelectedSubtitleTrackIndex = -1;
    private Vector<SubtitleTrack> mOutOfBandSubtitleTracks;
    private Vector<InputStream> mOpenSubtitleSources;
    private OnSubtitleDataListener mSubtitleDataListener = new OnSubtitleDataListener(){

        public void onSubtitleData(MediaPlayer mp, SubtitleData data) {
            int index = data.getTrackIndex();
            if (index >= MediaPlayer.this.mInbandSubtitleTracks.length) {
                return;
            }
            SubtitleTrack track = MediaPlayer.this.mInbandSubtitleTracks[index];
            if (track != null) {
                try {
                    long runID = data.getStartTimeUs() + 1L;
                    track.onData(new String(data.getData(), "UTF-8"), true, runID);
                    track.setRunDiscardTimeMs(runID, (data.getStartTimeUs() + data.getDurationUs()) / 1000L);
                }
                catch (UnsupportedEncodingException e) {
                    Log.w(MediaPlayer.TAG, "subtitle data for track " + index + " is not UTF-8 encoded: " + e);
                }
            }
        }
    };
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_STARTED = 6;
    private static final int MEDIA_PAUSED = 7;
    private static final int MEDIA_STOPPED = 8;
    private static final int MEDIA_SKIPPED = 9;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private static final int MEDIA_SUBTITLE_DATA = 201;
    private TimeProvider mTimeProvider;
    private OnPreparedListener mOnPreparedListener;
    private OnCompletionListener mOnCompletionListener;
    private OnBufferingUpdateListener mOnBufferingUpdateListener;
    private OnSeekCompleteListener mOnSeekCompleteListener;
    private OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private OnTimedTextListener mOnTimedTextListener;
    private OnSubtitleDataListener mOnSubtitleDataListener;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static final int MEDIA_ERROR_IO = -1004;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_UNSUPPORTED = -1010;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    private OnErrorListener mOnErrorListener;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_STARTED_AS_NEXT = 2;
    public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_METADATA_UPDATE = 802;
    public static final int MEDIA_INFO_EXTERNAL_METADATA_UPDATE = 803;
    public static final int MEDIA_INFO_TIMED_TEXT_ERROR = 900;
    public static final int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901;
    public static final int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902;
    private OnInfoListener mOnInfoListener;
    private Context mProxyContext = null;
    private ProxyReceiver mProxyReceiver = null;

    public MediaPlayer() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mTimeProvider = new TimeProvider(this);
        this.mOutOfBandSubtitleTracks = new Vector();
        this.mOpenSubtitleSources = new Vector();
        this.mInbandSubtitleTracks = new SubtitleTrack[0];
        this.native_setup(new WeakReference<MediaPlayer>(this));
    }

    private void _setVideoSurface(Surface surface) {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setVideoSurface(Landroid/view/Surface;)V", true, this);
    }

    public Parcel newRequest() {
        Parcel parcel = Parcel.obtain();
        parcel.writeInterfaceToken(IMEDIA_PLAYER);
        return parcel;
    }

    public void invoke(Parcel request, Parcel reply) {
        int retcode = this.native_invoke(request, reply);
        reply.setDataPosition(0);
        if (retcode != 0) {
            throw new RuntimeException("failure code: " + retcode);
        }
    }

    public void setDisplay(SurfaceHolder sh) {
        this.mSurfaceHolder = sh;
        Surface surface = sh != null ? sh.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoScalingMode(int mode) {
        if (!this.isVideoScalingModeSupported(mode)) {
            String msg = "Scaling mode " + mode + " is not supported";
            throw new IllegalArgumentException(msg);
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(6);
            request.writeInt(mode);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public static MediaPlayer create(Context context, Uri uri) {
        return MediaPlayer.create(context, uri, null);
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder) {
        try {
            MediaPlayer mp = new MediaPlayer();
            mp.setDataSource(context, uri);
            if (holder != null) {
                mp.setDisplay(holder);
            }
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    public static MediaPlayer create(Context context, int resid) {
        try {
            AssetFileDescriptor afd = context.getResources().openRawResourceFd(resid);
            if (afd == null) {
                return null;
            }
            MediaPlayer mp = new MediaPlayer();
            mp.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.disableProxyListener();
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            if (fd != null) {
                fd.close();
            }
        }
        Log.d(TAG, "Couldn't open file on client side, trying server side");
        this.setDataSource(uri.toString(), headers);
        if (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https")) {
            this.setupProxyListener(context);
        }
    }

    public void setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(path, null, null);
    }

    public void setDataSource(String path, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.setDataSource(path, keys, values);
    }

    private void setDataSource(String path, String[] keys, String[] values) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        File file;
        this.disableProxyListener();
        Uri uri = Uri.parse(path);
        if ("file".equals(uri.getScheme())) {
            path = uri.getPath();
        }
        if ((file = new File(path)).exists()) {
            FileInputStream is = new FileInputStream(file);
            FileDescriptor fd = is.getFD();
            this.setDataSource(fd);
            is.close();
        } else {
            this._setDataSource(path, keys, values);
        }
    }

    private void _setDataSource(String string2, String[] stringArray, String[] stringArray2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setDataSource(Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    public void setDataSource(FileDescriptor fd) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public void setDataSource(FileDescriptor fd, long offset, long length) throws IOException, IllegalArgumentException, IllegalStateException {
        this.disableProxyListener();
        this._setDataSource(fd, offset, length);
    }

    private void _setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException, IllegalArgumentException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setDataSource(Ljava/io/FileDescriptor;JJ)V", true, this);
    }

    public void prepare() throws IOException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#prepare()V", true, this);
    }

    public void prepareAsync() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#prepareAsync()V", true, this);
    }

    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    private void _start() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_start()V", true, this);
    }

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    private void _stop() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_stop()V", true, this);
    }

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    private void _pause() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_pause()V", true, this);
    }

    public void setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, MediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    private void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    public int getVideoWidth() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getVideoWidth()I", true, this);
    }

    public int getVideoHeight() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getVideoHeight()I", true, this);
    }

    public boolean isPlaying() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#isPlaying()Z", true, this) != 0;
    }

    public void seekTo(int n) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#seekTo(I)V", true, this);
    }

    public int getCurrentPosition() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getCurrentPosition()I", true, this);
    }

    public int getDuration() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getDuration()I", true, this);
    }

    public Metadata getMetadata(boolean update_only, boolean apply_filter) {
        Parcel reply = Parcel.obtain();
        Metadata data = new Metadata();
        if (!this.native_getMetadata(update_only, apply_filter, reply)) {
            reply.recycle();
            return null;
        }
        if (!data.parse(reply)) {
            reply.recycle();
            return null;
        }
        return data;
    }

    public int setMetadataFilter(Set<Integer> allow, Set<Integer> block) {
        Parcel request = this.newRequest();
        int capacity = request.dataSize() + 4 * (1 + allow.size() + 1 + block.size());
        if (request.dataCapacity() < capacity) {
            request.setDataCapacity(capacity);
        }
        request.writeInt(allow.size());
        for (Integer t : allow) {
            request.writeInt(t);
        }
        request.writeInt(block.size());
        for (Integer t : block) {
            request.writeInt(t);
        }
        return this.native_setMetadataFilter(request);
    }

    public void setNextMediaPlayer(MediaPlayer mediaPlayer) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setNextMediaPlayer(Landroid/media/MediaPlayer;)V", true, this);
    }

    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
        this.mOnVideoSizeChangedListener = null;
        this.mOnTimedTextListener = null;
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.mOnSubtitleDataListener = null;
        this._release();
    }

    private void _release() {
        OverrideMethod.invokeV("android.media.MediaPlayer#_release()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.mSelectedSubtitleTrackIndex = -1;
        Vector<InputStream> vector = this.mOpenSubtitleSources;
        synchronized (vector) {
            for (InputStream is : this.mOpenSubtitleSources) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            this.mOpenSubtitleSources.clear();
        }
        this.mOutOfBandSubtitleTracks.clear();
        this.mInbandSubtitleTracks = new SubtitleTrack[0];
        if (this.mSubtitleController != null) {
            this.mSubtitleController.reset();
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.stayAwake(false);
        this._reset();
        if (this.mEventHandler != null) {
            this.mEventHandler.removeCallbacksAndMessages(null);
        }
        this.disableProxyListener();
    }

    private void _reset() {
        OverrideMethod.invokeV("android.media.MediaPlayer#_reset()V", true, this);
    }

    public void setAudioStreamType(int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setAudioStreamType(I)V", true, this);
    }

    public void setLooping(boolean bl) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setLooping(Z)V", true, this);
    }

    public boolean isLooping() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#isLooping()Z", true, this) != 0;
    }

    public void setVolume(float f, float f2) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setVolume(FF)V", true, this);
    }

    public void setVolume(float volume) {
        this.setVolume(volume, volume);
    }

    public void setAudioSessionId(int n) throws IllegalArgumentException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#setAudioSessionId(I)V", true, this);
    }

    public int getAudioSessionId() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getAudioSessionId()I", true, this);
    }

    public void attachAuxEffect(int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#attachAuxEffect(I)V", true, this);
    }

    public void setAuxEffectSendLevel(float f) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setAuxEffectSendLevel(F)V", true, this);
    }

    private int native_invoke(Parcel parcel, Parcel parcel2) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_invoke(Landroid/os/Parcel;Landroid/os/Parcel;)I", true, this);
    }

    private boolean native_getMetadata(boolean bl, boolean bl2, Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_getMetadata(ZZLandroid/os/Parcel;)Z", true, this) != 0;
    }

    private int native_setMetadataFilter(Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_setMetadataFilter(Landroid/os/Parcel;)I", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_init()V", true, null);
    }

    private void native_setup(Object object) {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_setup(Ljava/lang/Object;)V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_finalize()V", true, this);
    }

    public TrackInfo[] getTrackInfo() throws IllegalStateException {
        TrackInfo[] trackInfo = this.getInbandTrackInfo();
        TrackInfo[] allTrackInfo = new TrackInfo[trackInfo.length + this.mOutOfBandSubtitleTracks.size()];
        System.arraycopy(trackInfo, 0, allTrackInfo, 0, trackInfo.length);
        int i = trackInfo.length;
        for (SubtitleTrack track : this.mOutOfBandSubtitleTracks) {
            allTrackInfo[i] = new TrackInfo(4, track.getFormat());
            ++i;
        }
        return allTrackInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackInfo[] getInbandTrackInfo() throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            TrackInfo[] trackInfo;
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(1);
            this.invoke(request, reply);
            TrackInfo[] trackInfoArray = trackInfo = reply.createTypedArray(TrackInfo.CREATOR);
            return trackInfoArray;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private static boolean availableMimeTypeForExternalSource(String mimeType) {
        return mimeType == MEDIA_MIMETYPE_TEXT_SUBRIP;
    }

    public void setSubtitleAnchor(SubtitleController controller, SubtitleController.Anchor anchor) {
        this.mSubtitleController = controller;
        this.mSubtitleController.setAnchor(anchor);
    }

    @Override
    public void onSubtitleTrackSelected(SubtitleTrack track) {
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, false);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            this.mSelectedSubtitleTrackIndex = -1;
        }
        this.setOnSubtitleDataListener(null);
        if (track == null) {
            return;
        }
        for (int i = 0; i < this.mInbandSubtitleTracks.length; ++i) {
            if (this.mInbandSubtitleTracks[i] != track) continue;
            Log.v(TAG, "Selecting subtitle track " + i);
            this.mSelectedSubtitleTrackIndex = i;
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, true);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.setOnSubtitleDataListener(this.mSubtitleDataListener);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubtitleSource(InputStream is, MediaFormat format) throws IllegalStateException {
        final InputStream fIs = is;
        final MediaFormat fFormat = format;
        Vector<InputStream> vector = this.mOpenSubtitleSources;
        synchronized (vector) {
            this.mOpenSubtitleSources.add(is);
        }
        final HandlerThread thread = new HandlerThread("SubtitleReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int addTrack() {
                if (fIs == null || MediaPlayer.this.mSubtitleController == null) {
                    return 901;
                }
                SubtitleTrack track = MediaPlayer.this.mSubtitleController.addTrack(fFormat);
                if (track == null) {
                    return 901;
                }
                Scanner scanner = new Scanner(fIs, "UTF-8");
                String contents = scanner.useDelimiter("\\A").next();
                Vector vector = MediaPlayer.this.mOpenSubtitleSources;
                synchronized (vector) {
                    MediaPlayer.this.mOpenSubtitleSources.remove(fIs);
                }
                scanner.close();
                MediaPlayer.this.mOutOfBandSubtitleTracks.add(track);
                track.onData(contents, true, -1L);
                return 803;
            }

            public void run() {
                int res = this.addTrack();
                if (MediaPlayer.this.mEventHandler != null) {
                    Message m = MediaPlayer.this.mEventHandler.obtainMessage(200, res, 0, null);
                    MediaPlayer.this.mEventHandler.sendMessage(m);
                }
                thread.getLooper().quitSafely();
            }
        });
    }

    private void scanInternalSubtitleTracks() {
        if (this.mSubtitleController == null) {
            Log.e(TAG, "Should have subtitle controller already set");
            return;
        }
        TrackInfo[] tracks = this.getInbandTrackInfo();
        SubtitleTrack[] inbandTracks = new SubtitleTrack[tracks.length];
        for (int i = 0; i < tracks.length; ++i) {
            SubtitleTrack track;
            if (tracks[i].getTrackType() != 4) continue;
            inbandTracks[i] = i < this.mInbandSubtitleTracks.length ? this.mInbandSubtitleTracks[i] : (track = this.mSubtitleController.addTrack(tracks[i].getFormat()));
        }
        this.mInbandSubtitleTracks = inbandTracks;
        this.mSubtitleController.selectDefaultTrack();
    }

    public void addTimedTextSource(String path, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        if (!MediaPlayer.availableMimeTypeForExternalSource(mimeType)) {
            String msg = "Illegal mimeType for timed text source: " + mimeType;
            throw new IllegalArgumentException(msg);
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException(path);
        }
        FileInputStream is = new FileInputStream(file);
        FileDescriptor fd = is.getFD();
        this.addTimedTextSource(fd, mimeType);
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimedTextSource(Context context, Uri uri, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.addTimedTextSource(uri.getPath(), mimeType);
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            this.addTimedTextSource(fd.getFileDescriptor(), mimeType);
            return;
        }
        catch (SecurityException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            if (fd != null) {
                fd.close();
            }
        }
    }

    public void addTimedTextSource(FileDescriptor fd, String mimeType) throws IllegalArgumentException, IllegalStateException {
        this.addTimedTextSource(fd, 0L, 0x7FFFFFFFFFFFFFFL, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimedTextSource(FileDescriptor fd, long offset, long length, String mimeType) throws IllegalArgumentException, IllegalStateException {
        if (!MediaPlayer.availableMimeTypeForExternalSource(mimeType)) {
            throw new IllegalArgumentException("Illegal mimeType for timed text source: " + mimeType);
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(3);
            request.writeFileDescriptor(fd);
            request.writeLong(offset);
            request.writeLong(length);
            request.writeString(mimeType);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public void selectTrack(int index) throws IllegalStateException {
        this.selectOrDeselectTrack(index, true);
    }

    public void deselectTrack(int index) throws IllegalStateException {
        this.selectOrDeselectTrack(index, false);
    }

    private void selectOrDeselectTrack(int index, boolean select) throws IllegalStateException {
        SubtitleTrack track = null;
        if (index < this.mInbandSubtitleTracks.length) {
            track = this.mInbandSubtitleTracks[index];
        } else if (index < this.mInbandSubtitleTracks.length + this.mOutOfBandSubtitleTracks.size()) {
            track = this.mOutOfBandSubtitleTracks.get(index - this.mInbandSubtitleTracks.length);
        }
        if (this.mSubtitleController != null && track != null) {
            if (select) {
                this.mSubtitleController.selectTrack(track);
            } else if (this.mSubtitleController.getSelectedTrack() == track) {
                this.mSubtitleController.selectTrack(null);
            } else {
                Log.w(TAG, "trying to deselect track that was not selected");
            }
            return;
        }
        this.selectOrDeselectInbandTrack(index, select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectOrDeselectInbandTrack(int index, boolean select) throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(select ? 4 : 5);
            request.writeInt(index);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public static int native_pullBatteryData(Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_pullBatteryData(Landroid/os/Parcel;)I", true, null);
    }

    public void setRetransmitEndpoint(InetSocketAddress endpoint) throws IllegalStateException, IllegalArgumentException {
        int ret;
        String addrString = null;
        int port = 0;
        if (null != endpoint) {
            addrString = endpoint.getAddress().getHostAddress();
            port = endpoint.getPort();
        }
        if ((ret = this.native_setRetransmitEndpoint(addrString, port)) != 0) {
            throw new IllegalArgumentException("Illegal re-transmit endpoint; native ret " + ret);
        }
    }

    private int native_setRetransmitEndpoint(String string2, int n) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_setRetransmitEndpoint(Ljava/lang/String;I)I", true, this);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public MediaTimeProvider getMediaTimeProvider() {
        if (this.mTimeProvider == null) {
            this.mTimeProvider = new TimeProvider(this);
        }
        return this.mTimeProvider;
    }

    private static void postEventFromNative(Object mediaplayer_ref, int what, int arg1, int arg2, Object obj) {
        MediaPlayer mp = (MediaPlayer)((WeakReference)mediaplayer_ref).get();
        if (mp == null) {
            return;
        }
        if (what == 200 && arg1 == 2) {
            mp.start();
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.sendMessage(m);
        }
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    public void setOnCompletionListener(OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
    }

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
    }

    public void setOnTimedTextListener(OnTimedTextListener listener) {
        this.mOnTimedTextListener = listener;
    }

    public void setOnSubtitleDataListener(OnSubtitleDataListener listener) {
        this.mOnSubtitleDataListener = listener;
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    public void setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    private boolean isVideoScalingModeSupported(int mode) {
        return mode == 1 || mode == 2;
    }

    private void setupProxyListener(Context context) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PROXY_CHANGE");
        this.mProxyReceiver = new ProxyReceiver();
        this.mProxyContext = context;
        Intent currentProxy = context.getApplicationContext().registerReceiver(this.mProxyReceiver, filter);
        if (currentProxy != null) {
            this.handleProxyBroadcast(currentProxy);
        }
    }

    private void disableProxyListener() {
        if (this.mProxyReceiver == null) {
            return;
        }
        Context appContext = this.mProxyContext.getApplicationContext();
        if (appContext != null) {
            appContext.unregisterReceiver(this.mProxyReceiver);
        }
        this.mProxyReceiver = null;
        this.mProxyContext = null;
    }

    private void handleProxyBroadcast(Intent intent) {
        ProxyProperties props = (ProxyProperties)intent.getExtra("proxy");
        if (props == null || props.getHost() == null) {
            this.updateProxyConfig(null);
        } else {
            this.updateProxyConfig(props);
        }
    }

    private void updateProxyConfig(ProxyProperties proxyProperties) {
        OverrideMethod.invokeV("android.media.MediaPlayer#updateProxyConfig(Landroid/net/ProxyProperties;)V", true, this);
    }

    static {
        System.loadLibrary("media_jni");
        MediaPlayer.native_init();
    }

    static class TimeProvider
    implements OnSeekCompleteListener,
    MediaTimeProvider {
        private static final String TAG = "MTP";
        private static final long MAX_NS_WITHOUT_POSITION_CHECK = 5000000000L;
        private static final long MAX_EARLY_CALLBACK_US = 1000L;
        private static final long TIME_ADJUSTMENT_RATE = 2L;
        private long mLastTimeUs = 0L;
        private MediaPlayer mPlayer;
        private boolean mPaused = true;
        private boolean mStopped = true;
        private long mLastReportedTime;
        private long mTimeAdjustment;
        private MediaTimeProvider.OnMediaTimeListener[] mListeners;
        private long[] mTimes;
        private long mLastNanoTime;
        private Handler mEventHandler;
        private boolean mRefresh = false;
        private boolean mPausing = false;
        private boolean mSeeking = false;
        private static final int NOTIFY = 1;
        private static final int NOTIFY_TIME = 0;
        private static final int REFRESH_AND_NOTIFY_TIME = 1;
        private static final int NOTIFY_STOP = 2;
        private static final int NOTIFY_SEEK = 3;
        private HandlerThread mHandlerThread;
        public boolean DEBUG = false;

        public TimeProvider(MediaPlayer mp) {
            this.mPlayer = mp;
            try {
                this.getCurrentTimeUs(true, false);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
            }
            Looper looper = Looper.myLooper();
            if (looper == null && (looper = Looper.getMainLooper()) == null) {
                this.mHandlerThread = new HandlerThread("MediaPlayerMTPEventThread", -2);
                this.mHandlerThread.start();
                looper = this.mHandlerThread.getLooper();
            }
            this.mEventHandler = new EventHandler(looper);
            this.mListeners = new MediaTimeProvider.OnMediaTimeListener[0];
            this.mTimes = new long[0];
            this.mLastTimeUs = 0L;
            this.mTimeAdjustment = 0L;
        }

        private void scheduleNotification(int type, long delayUs) {
            if (this.mSeeking && (type == 0 || type == 1)) {
                return;
            }
            if (this.DEBUG) {
                Log.v(TAG, "scheduleNotification " + type + " in " + delayUs);
            }
            this.mEventHandler.removeMessages(1);
            Message msg = this.mEventHandler.obtainMessage(1, type, 0);
            this.mEventHandler.sendMessageDelayed(msg, (int)(delayUs / 1000L));
        }

        public void close() {
            this.mEventHandler.removeMessages(1);
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread = null;
            }
        }

        protected void finalize() {
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPaused(boolean paused) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onPaused: " + paused);
                }
                if (this.mStopped) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.scheduleNotification(3, 0L);
                } else {
                    this.mPausing = paused;
                    this.mSeeking = false;
                    this.scheduleNotification(1, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStopped() {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onStopped");
                }
                this.mPaused = true;
                this.mStopped = true;
                this.mSeeking = false;
                this.scheduleNotification(2, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSeekComplete(MediaPlayer mp) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                this.mStopped = false;
                this.mSeeking = true;
                this.scheduleNotification(3, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewPlayer() {
            if (this.mRefresh) {
                TimeProvider timeProvider = this;
                synchronized (timeProvider) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.scheduleNotification(3, 0L);
                }
            }
        }

        private synchronized void notifySeek() {
            this.mSeeking = false;
            try {
                long timeUs = this.getCurrentTimeUs(true, false);
                if (this.DEBUG) {
                    Log.d(TAG, "onSeekComplete at " + timeUs);
                }
                for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                    if (listener == null) break;
                    listener.onSeek(timeUs);
                }
            }
            catch (IllegalStateException e) {
                if (this.DEBUG) {
                    Log.d(TAG, "onSeekComplete but no player");
                }
                this.mPausing = true;
                this.notifyTimedEvent(false);
            }
        }

        private synchronized void notifyStop() {
            for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                if (listener == null) break;
                listener.onStop();
            }
        }

        private int registerListener(MediaTimeProvider.OnMediaTimeListener listener) {
            int i;
            for (i = 0; i < this.mListeners.length && this.mListeners[i] != listener && this.mListeners[i] != null; ++i) {
            }
            if (i >= this.mListeners.length) {
                MediaTimeProvider.OnMediaTimeListener[] newListeners = new MediaTimeProvider.OnMediaTimeListener[i + 1];
                long[] newTimes = new long[i + 1];
                System.arraycopy(this.mListeners, 0, newListeners, 0, this.mListeners.length);
                System.arraycopy(this.mTimes, 0, newTimes, 0, this.mTimes.length);
                this.mListeners = newListeners;
                this.mTimes = newTimes;
            }
            if (this.mListeners[i] == null) {
                this.mListeners[i] = listener;
                this.mTimes[i] = -1L;
            }
            return i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyAt(long timeUs, MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "notifyAt " + timeUs);
                }
                this.mTimes[this.registerListener((MediaTimeProvider.OnMediaTimeListener)listener)] = timeUs;
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleUpdate(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "scheduleUpdate");
                }
                int i = this.registerListener(listener);
                if (this.mStopped) {
                    this.scheduleNotification(2, 0L);
                } else {
                    this.mTimes[i] = 0L;
                    this.scheduleNotification(0, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelNotifications(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                for (int i = 0; i < this.mListeners.length; ++i) {
                    if (this.mListeners[i] == listener) {
                        System.arraycopy(this.mListeners, i + 1, this.mListeners, i, this.mListeners.length - i - 1);
                        System.arraycopy(this.mTimes, i + 1, this.mTimes, i, this.mTimes.length - i - 1);
                        this.mListeners[this.mListeners.length - 1] = null;
                        this.mTimes[this.mTimes.length - 1] = -1L;
                        break;
                    }
                    if (this.mListeners[i] == null) break;
                }
                this.scheduleNotification(0, 0L);
            }
        }

        private synchronized void notifyTimedEvent(boolean refreshTime) {
            long nowUs;
            try {
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
                this.mPausing = true;
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            long nextTimeUs = nowUs;
            if (this.mSeeking) {
                return;
            }
            if (this.DEBUG) {
                StringBuilder sb = new StringBuilder();
                sb.append("notifyTimedEvent(").append(this.mLastTimeUs).append(" -> ").append(nowUs).append(") from {");
                boolean first = true;
                for (long time : this.mTimes) {
                    if (time == -1L) continue;
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(time);
                    first = false;
                }
                sb.append("}");
                Log.d(TAG, sb.toString());
            }
            Vector<MediaTimeProvider.OnMediaTimeListener> activatedListeners = new Vector<MediaTimeProvider.OnMediaTimeListener>();
            for (int ix = 0; ix < this.mTimes.length && this.mListeners[ix] != null; ++ix) {
                if (this.mTimes[ix] <= -1L) continue;
                if (this.mTimes[ix] <= nowUs + 1000L) {
                    activatedListeners.add(this.mListeners[ix]);
                    if (this.DEBUG) {
                        Log.d(TAG, "removed");
                    }
                    this.mTimes[ix] = -1L;
                    continue;
                }
                if (nextTimeUs != nowUs && this.mTimes[ix] >= nextTimeUs) continue;
                nextTimeUs = this.mTimes[ix];
            }
            if (nextTimeUs > nowUs && !this.mPaused) {
                if (this.DEBUG) {
                    Log.d(TAG, "scheduling for " + nextTimeUs + " and " + nowUs);
                }
                this.scheduleNotification(0, nextTimeUs - nowUs);
            } else {
                this.mEventHandler.removeMessages(1);
            }
            for (MediaTimeProvider.OnMediaTimeListener listener : activatedListeners) {
                listener.onTimedEvent(nowUs);
            }
        }

        private long getEstimatedTime(long nanoTime, boolean monotonic) {
            if (this.mPaused) {
                this.mLastReportedTime = this.mLastTimeUs + this.mTimeAdjustment;
            } else {
                long timeSinceRead = (nanoTime - this.mLastNanoTime) / 1000L;
                this.mLastReportedTime = this.mLastTimeUs + timeSinceRead;
                if (this.mTimeAdjustment > 0L) {
                    long adjustment = this.mTimeAdjustment - timeSinceRead / 2L;
                    if (adjustment <= 0L) {
                        this.mTimeAdjustment = 0L;
                    } else {
                        this.mLastReportedTime += adjustment;
                    }
                }
            }
            return this.mLastReportedTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getCurrentTimeUs(boolean refreshTime, boolean monotonic) throws IllegalStateException {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.mPaused && !refreshTime) {
                    return this.mLastReportedTime;
                }
                long nanoTime = System.nanoTime();
                if (refreshTime || nanoTime >= this.mLastNanoTime + 5000000000L) {
                    try {
                        this.mLastTimeUs = (long)this.mPlayer.getCurrentPosition() * 1000L;
                        boolean bl = this.mPaused = !this.mPlayer.isPlaying();
                        if (this.DEBUG) {
                            Log.v(TAG, (this.mPaused ? "paused" : "playing") + " at " + this.mLastTimeUs);
                        }
                    }
                    catch (IllegalStateException e) {
                        if (this.mPausing) {
                            this.mPausing = false;
                            this.getEstimatedTime(nanoTime, monotonic);
                            this.mPaused = true;
                            if (this.DEBUG) {
                                Log.d(TAG, "illegal state, but pausing: estimating at " + this.mLastReportedTime);
                            }
                            return this.mLastReportedTime;
                        }
                        throw e;
                    }
                    this.mLastNanoTime = nanoTime;
                    if (monotonic && this.mLastTimeUs < this.mLastReportedTime) {
                        this.mTimeAdjustment = this.mLastReportedTime - this.mLastTimeUs;
                        if (this.mTimeAdjustment > 1000000L) {
                            this.mStopped = false;
                            this.mSeeking = true;
                            this.scheduleNotification(3, 0L);
                        }
                    } else {
                        this.mTimeAdjustment = 0L;
                    }
                }
                return this.getEstimatedTime(nanoTime, monotonic);
            }
        }

        private class EventHandler
        extends Handler {
            public EventHandler(Looper looper) {
                super(looper);
            }

            public void handleMessage(Message msg) {
                if (msg.what == 1) {
                    switch (msg.arg1) {
                        case 0: {
                            TimeProvider.this.notifyTimedEvent(false);
                            break;
                        }
                        case 1: {
                            TimeProvider.this.notifyTimedEvent(true);
                            break;
                        }
                        case 2: {
                            TimeProvider.this.notifyStop();
                            break;
                        }
                        case 3: {
                            TimeProvider.this.notifySeek();
                        }
                    }
                }
            }
        }
    }

    private class ProxyReceiver
    extends BroadcastReceiver {
        private ProxyReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.PROXY_CHANGE")) {
                MediaPlayer.this.handleProxyBroadcast(intent);
            }
        }
    }

    public static interface OnInfoListener {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnSubtitleDataListener {
        public void onSubtitleData(MediaPlayer var1, SubtitleData var2);
    }

    public static interface OnTimedTextListener {
        public void onTimedText(MediaPlayer var1, TimedText var2);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static interface OnCompletionListener {
        public void onCompletion(MediaPlayer var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared(MediaPlayer var1);
    }

    private class EventHandler
    extends Handler {
        private MediaPlayer mMediaPlayer;

        public EventHandler(MediaPlayer mp, Looper looper) {
            super(looper);
            this.mMediaPlayer = mp;
        }

        public void handleMessage(Message msg) {
            if (this.mMediaPlayer.mNativeContext == 0L) {
                Log.w(MediaPlayer.TAG, "mediaplayer went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: {
                    MediaPlayer.this.scanInternalSubtitleTracks();
                    if (MediaPlayer.this.mOnPreparedListener != null) {
                        MediaPlayer.this.mOnPreparedListener.onPrepared(this.mMediaPlayer);
                    }
                    return;
                }
                case 2: {
                    if (MediaPlayer.this.mOnCompletionListener != null) {
                        MediaPlayer.this.mOnCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 8: {
                    if (MediaPlayer.this.mTimeProvider == null) break;
                    MediaPlayer.this.mTimeProvider.onStopped();
                    break;
                }
                case 6: 
                case 7: {
                    if (MediaPlayer.this.mTimeProvider == null) break;
                    MediaPlayer.this.mTimeProvider.onPaused(msg.what == 7);
                    break;
                }
                case 3: {
                    if (MediaPlayer.this.mOnBufferingUpdateListener != null) {
                        MediaPlayer.this.mOnBufferingUpdateListener.onBufferingUpdate(this.mMediaPlayer, msg.arg1);
                    }
                    return;
                }
                case 4: {
                    if (MediaPlayer.this.mOnSeekCompleteListener != null) {
                        MediaPlayer.this.mOnSeekCompleteListener.onSeekComplete(this.mMediaPlayer);
                    }
                }
                case 9: {
                    if (MediaPlayer.this.mTimeProvider != null) {
                        MediaPlayer.this.mTimeProvider.onSeekComplete(this.mMediaPlayer);
                    }
                    return;
                }
                case 5: {
                    if (MediaPlayer.this.mOnVideoSizeChangedListener != null) {
                        MediaPlayer.this.mOnVideoSizeChangedListener.onVideoSizeChanged(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 100: {
                    Log.e(MediaPlayer.TAG, "Error (" + msg.arg1 + "," + msg.arg2 + ")");
                    boolean error_was_handled = false;
                    if (MediaPlayer.this.mOnErrorListener != null) {
                        error_was_handled = MediaPlayer.this.mOnErrorListener.onError(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    if (MediaPlayer.this.mOnCompletionListener != null && !error_was_handled) {
                        MediaPlayer.this.mOnCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 200: {
                    switch (msg.arg1) {
                        case 700: {
                            Log.i(MediaPlayer.TAG, "Info (" + msg.arg1 + "," + msg.arg2 + ")");
                            break;
                        }
                        case 802: {
                            MediaPlayer.this.scanInternalSubtitleTracks();
                        }
                        case 803: {
                            msg.arg1 = 802;
                            MediaPlayer.this.mSubtitleController.selectDefaultTrack();
                        }
                    }
                    if (MediaPlayer.this.mOnInfoListener != null) {
                        MediaPlayer.this.mOnInfoListener.onInfo(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 99: {
                    if (MediaPlayer.this.mOnTimedTextListener == null) {
                        return;
                    }
                    if (msg.obj == null) {
                        MediaPlayer.this.mOnTimedTextListener.onTimedText(this.mMediaPlayer, null);
                    } else if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        TimedText text = new TimedText(parcel);
                        parcel.recycle();
                        MediaPlayer.this.mOnTimedTextListener.onTimedText(this.mMediaPlayer, text);
                    }
                    return;
                }
                case 201: {
                    if (MediaPlayer.this.mOnSubtitleDataListener == null) {
                        return;
                    }
                    if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        SubtitleData data = new SubtitleData(parcel);
                        parcel.recycle();
                        MediaPlayer.this.mOnSubtitleDataListener.onSubtitleData(this.mMediaPlayer, data);
                    }
                    return;
                }
                case 0: {
                    break;
                }
                default: {
                    Log.e(MediaPlayer.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
        }
    }

    public static class TrackInfo
    implements Parcelable {
        public static final int MEDIA_TRACK_TYPE_UNKNOWN = 0;
        public static final int MEDIA_TRACK_TYPE_VIDEO = 1;
        public static final int MEDIA_TRACK_TYPE_AUDIO = 2;
        public static final int MEDIA_TRACK_TYPE_TIMEDTEXT = 3;
        public static final int MEDIA_TRACK_TYPE_SUBTITLE = 4;
        final int mTrackType;
        final MediaFormat mFormat;
        static final Parcelable.Creator<TrackInfo> CREATOR = new Parcelable.Creator<TrackInfo>(){

            @Override
            public TrackInfo createFromParcel(Parcel in) {
                return new TrackInfo(in);
            }

            public TrackInfo[] newArray(int size) {
                return new TrackInfo[size];
            }
        };

        public int getTrackType() {
            return this.mTrackType;
        }

        public String getLanguage() {
            String language = this.mFormat.getString("language");
            return language == null ? "und" : language;
        }

        public MediaFormat getFormat() {
            if (this.mTrackType == 3 || this.mTrackType == 4) {
                return this.mFormat;
            }
            return null;
        }

        TrackInfo(Parcel in) {
            this.mTrackType = in.readInt();
            String language = in.readString();
            if (this.mTrackType == 3) {
                this.mFormat = MediaFormat.createSubtitleFormat(MediaPlayer.MEDIA_MIMETYPE_TEXT_SUBRIP, language);
            } else if (this.mTrackType == 4) {
                this.mFormat = MediaFormat.createSubtitleFormat(MediaPlayer.MEDIA_MIMETYPE_TEXT_VTT, language);
                this.mFormat.setInteger("is-autoselect", in.readInt());
                this.mFormat.setInteger("is-default", in.readInt());
                this.mFormat.setInteger("is-forced-subtitle", in.readInt());
            } else {
                this.mFormat = new MediaFormat();
                this.mFormat.setString("language", language);
            }
        }

        TrackInfo(int type, MediaFormat format) {
            this.mTrackType = type;
            this.mFormat = format;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mTrackType);
            dest.writeString(this.getLanguage());
            if (this.mTrackType == 4) {
                dest.writeInt(this.mFormat.getInteger("is-autoselect"));
                dest.writeInt(this.mFormat.getInteger("is-default"));
                dest.writeInt(this.mFormat.getInteger("is-forced-subtitle"));
            }
        }
    }
}

