/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IAudioFocusDispatcher;
import android.media.MediaFocusControl;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.PrintWriter;
import java.util.NoSuchElementException;

class FocusRequester {
    private static final String TAG = "MediaFocusControl";
    private static final boolean DEBUG = false;
    private MediaFocusControl.AudioFocusDeathHandler mDeathHandler;
    private final IAudioFocusDispatcher mFocusDispatcher;
    private final IBinder mSourceRef;
    private final String mClientId;
    private final String mPackageName;
    private final int mCallingUid;
    private final int mFocusGainRequest;
    private int mFocusLossReceived;
    private final int mStreamType;

    FocusRequester(int streamType, int focusRequest, IAudioFocusDispatcher afl, IBinder source, String id2, MediaFocusControl.AudioFocusDeathHandler hdlr, String pn, int uid) {
        this.mStreamType = streamType;
        this.mFocusDispatcher = afl;
        this.mSourceRef = source;
        this.mClientId = id2;
        this.mDeathHandler = hdlr;
        this.mPackageName = pn;
        this.mCallingUid = uid;
        this.mFocusGainRequest = focusRequest;
        this.mFocusLossReceived = 0;
    }

    boolean hasSameClient(String otherClient) {
        try {
            return this.mClientId.compareTo(otherClient) == 0;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    boolean hasSameBinder(IBinder ib) {
        return this.mSourceRef != null && this.mSourceRef.equals(ib);
    }

    boolean hasSamePackage(String pack) {
        try {
            return this.mPackageName.compareTo(pack) == 0;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    boolean hasSameUid(int uid) {
        return this.mCallingUid == uid;
    }

    int getGainRequest() {
        return this.mFocusGainRequest;
    }

    int getStreamType() {
        return this.mStreamType;
    }

    private static String focusChangeToString(int focus) {
        switch (focus) {
            case 0: {
                return "none";
            }
            case 1: {
                return "GAIN";
            }
            case 2: {
                return "GAIN_TRANSIENT";
            }
            case 3: {
                return "GAIN_TRANSIENT_MAY_DUCK";
            }
            case 4: {
                return "GAIN_TRANSIENT_EXCLUSIVE";
            }
            case -1: {
                return "LOSS";
            }
            case -2: {
                return "LOSS_TRANSIENT";
            }
            case -3: {
                return "LOSS_TRANSIENT_CAN_DUCK";
            }
        }
        return "[invalid focus change" + focus + "]";
    }

    private String focusGainToString() {
        return FocusRequester.focusChangeToString(this.mFocusGainRequest);
    }

    private String focusLossToString() {
        return FocusRequester.focusChangeToString(this.mFocusLossReceived);
    }

    void dump(PrintWriter pw) {
        pw.println("  source:" + this.mSourceRef + " -- pack: " + this.mPackageName + " -- client: " + this.mClientId + " -- gain: " + this.focusGainToString() + " -- loss: " + this.focusLossToString() + " -- uid: " + this.mCallingUid + " -- stream: " + this.mStreamType);
    }

    void release() {
        try {
            if (this.mSourceRef != null && this.mDeathHandler != null) {
                this.mSourceRef.unlinkToDeath(this.mDeathHandler, 0);
                this.mDeathHandler = null;
            }
        }
        catch (NoSuchElementException e) {
            Log.e(TAG, "FocusRequester.release() hit ", e);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    private int focusLossForGainRequest(int gainRequest) {
        switch (gainRequest) {
            case 1: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case -2: 
                    case -1: 
                    case 0: {
                        return -1;
                    }
                }
            }
            case 2: 
            case 4: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case -2: 
                    case 0: {
                        return -2;
                    }
                    case -1: {
                        return -1;
                    }
                }
            }
            case 3: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case 0: {
                        return -3;
                    }
                    case -2: {
                        return -2;
                    }
                    case -1: {
                        return -1;
                    }
                }
            }
        }
        Log.e(TAG, "focusLossForGainRequest() for invalid focus request " + gainRequest);
        return 0;
    }

    void handleExternalFocusGain(int focusGain) {
        int focusLoss = this.focusLossForGainRequest(focusGain);
        this.handleFocusLoss(focusLoss);
    }

    void handleFocusGain(int focusGain) {
        try {
            if (this.mFocusDispatcher != null) {
                this.mFocusDispatcher.dispatchAudioFocusChange(focusGain, this.mClientId);
            }
            this.mFocusLossReceived = 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failure to signal gain of audio focus due to: ", e);
        }
    }

    void handleFocusLoss(int focusLoss) {
        try {
            if (focusLoss != this.mFocusLossReceived) {
                if (this.mFocusDispatcher != null) {
                    this.mFocusDispatcher.dispatchAudioFocusChange(focusLoss, this.mClientId);
                }
                this.mFocusLossReceived = focusLoss;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failure to signal loss of audio focus due to:", e);
        }
    }
}

