/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public class HdmiCecMessage
implements Parcelable {
    private static final int MAX_MESSAGE_LENGTH = 16;
    private final int mSource;
    private final int mDestination;
    private final int mOpcode;
    private final byte[] mParams;
    public static final Parcelable.Creator<HdmiCecMessage> CREATOR = new Parcelable.Creator<HdmiCecMessage>(){

        @Override
        public HdmiCecMessage createFromParcel(Parcel p) {
            int source = p.readInt();
            int destination = p.readInt();
            int opcode = p.readInt();
            byte[] params = new byte[p.readInt()];
            p.readByteArray(params);
            return new HdmiCecMessage(source, destination, opcode, params);
        }

        public HdmiCecMessage[] newArray(int size) {
            return new HdmiCecMessage[size];
        }
    };

    public HdmiCecMessage(int source, int destination, int opcode, byte[] params) {
        this.mSource = source;
        this.mDestination = destination;
        this.mOpcode = opcode;
        this.mParams = Arrays.copyOf(params, params.length);
    }

    public int getSource() {
        return this.mSource;
    }

    public int getDestination() {
        return this.mDestination;
    }

    public int getOpcode() {
        return this.mOpcode;
    }

    public byte[] getParams() {
        return this.mParams;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSource);
        dest.writeInt(this.mDestination);
        dest.writeInt(this.mOpcode);
        dest.writeInt(this.mParams.length);
        dest.writeByteArray(this.mParams);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(String.format("src: %d dst: %d op: %2X params: ", this.mSource, this.mDestination, this.mOpcode));
        for (byte data : this.mParams) {
            s.append(String.format("%02X ", data));
        }
        return s.toString();
    }
}

