/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiCecClient;
import android.hardware.hdmi.HdmiCecMessage;
import android.hardware.hdmi.IHdmiCecListener;
import android.hardware.hdmi.IHdmiCecService;
import android.os.IBinder;
import android.os.RemoteException;

public class HdmiCecManager {
    private final IHdmiCecService mService;

    public HdmiCecManager(IHdmiCecService service) {
        this.mService = service;
    }

    public HdmiCecClient getClient(int type, HdmiCecClient.Listener listener) {
        if (this.mService == null) {
            return null;
        }
        try {
            IBinder b = this.mService.allocateLogicalDevice(type, this.getListenerWrapper(listener));
            return HdmiCecClient.create(this.mService, b);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private IHdmiCecListener getListenerWrapper(HdmiCecClient.Listener listener) {
        return new IHdmiCecListener.Stub(){

            public void onMessageReceived(HdmiCecMessage message) {
            }

            public void onCableStatusChanged(boolean connected) {
            }
        };
    }
}

