/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiCecMessage;
import android.hardware.hdmi.IHdmiCecService;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public class HdmiCecClient {
    private static final String TAG = "HdmiCecClient";
    private final IHdmiCecService mService;
    private final IBinder mBinder;

    private HdmiCecClient(IHdmiCecService service, IBinder b) {
        this.mService = service;
        this.mBinder = b;
    }

    static HdmiCecClient create(IHdmiCecService service, IBinder b) {
        return new HdmiCecClient(service, b);
    }

    public void sendActiveSource() {
        try {
            this.mService.sendActiveSource(this.mBinder);
        }
        catch (RemoteException e) {
            Log.e(TAG, "sendActiveSource threw exception ", e);
        }
    }

    public void sendInactiveSource() {
        try {
            this.mService.sendInactiveSource(this.mBinder);
        }
        catch (RemoteException e) {
            Log.e(TAG, "sendInactiveSource threw exception ", e);
        }
    }

    public void sendTextViewOn() {
        try {
            this.mService.sendTextViewOn(this.mBinder);
        }
        catch (RemoteException e) {
            Log.e(TAG, "sendTextViewOn threw exception ", e);
        }
    }

    public void sendImageViewOn() {
        try {
            this.mService.sendImageViewOn(this.mBinder);
        }
        catch (RemoteException e) {
            Log.e(TAG, "sendImageViewOn threw exception ", e);
        }
    }

    public void sendGiveDevicePowerStatus(int address) {
        try {
            this.mService.sendGiveDevicePowerStatus(this.mBinder, address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "sendGiveDevicePowerStatus threw exception ", e);
        }
    }

    public boolean isTvOn() {
        try {
            return this.mService.isTvOn(this.mBinder);
        }
        catch (RemoteException e) {
            Log.e(TAG, "isTvOn threw exception ", e);
            return false;
        }
    }

    public static abstract class Listener {
        public void onMessageReceived(HdmiCecMessage message) {
        }

        public void onCableStatusChanged(boolean connected) {
        }
    }
}

