/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.content.Context;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraDevice;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.utils.BinderHolder;
import android.hardware.camera2.utils.CameraBinderDecorator;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraManager {
    private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
    private static final int USE_CALLING_UID = -1;
    private final ICameraService mCameraService;
    private ArrayList<String> mDeviceIdList;
    private final ArrayMap<AvailabilityListener, Handler> mListenerMap = new ArrayMap();
    private final Context mContext;
    private final Object mLock = new Object();

    public CameraManager(Context context) {
        this.mContext = context;
        IBinder cameraServiceBinder = ServiceManager.getService(CAMERA_SERVICE_BINDER_NAME);
        ICameraService cameraServiceRaw = ICameraService.Stub.asInterface(cameraServiceBinder);
        this.mCameraService = CameraBinderDecorator.newInstance(cameraServiceRaw);
        try {
            this.mCameraService.addListener(new CameraServiceListener());
        }
        catch (CameraRuntimeException e) {
            throw new IllegalStateException("Failed to register a camera service listener", e.asChecked());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public String[] getCameraIdList() throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            try {
                return this.getOrCreateDeviceIdListLocked().toArray(new String[0]);
            }
            catch (CameraAccessException e) {
                throw new IllegalStateException("Failed to query camera service for device ID list", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAvailabilityListener(AvailabilityListener listener, Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mListenerMap.put(listener, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAvailabilityListener(AvailabilityListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListenerMap.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraCharacteristics getCameraCharacteristics(String cameraId) throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.getOrCreateDeviceIdListLocked().contains(cameraId)) {
                throw new IllegalArgumentException(String.format("Camera id %s does not match any currently connected camera device", cameraId));
            }
        }
        CameraMetadataNative info = new CameraMetadataNative();
        try {
            this.mCameraService.getCameraCharacteristics(Integer.valueOf(cameraId), info);
        }
        catch (CameraRuntimeException e) {
            throw e.asChecked();
        }
        catch (RemoteException e) {
            return null;
        }
        return new CameraCharacteristics(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCameraDeviceUserAsync(String cameraId, CameraDevice.StateListener listener, Handler handler) throws CameraAccessException {
        try {
            Object object = this.mLock;
            synchronized (object) {
                CameraDevice device = new CameraDevice(cameraId, listener, handler);
                BinderHolder holder = new BinderHolder();
                this.mCameraService.connectDevice(device.getCallbacks(), Integer.parseInt(cameraId), this.mContext.getPackageName(), -1, holder);
                ICameraDeviceUser cameraUser = ICameraDeviceUser.Stub.asInterface(holder.getBinder());
                device.setRemoteDevice(cameraUser);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected cameraId to be numeric, but it was: " + cameraId);
        }
        catch (CameraRuntimeException e) {
            throw e.asChecked();
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void openCamera(String cameraId, CameraDevice.StateListener listener, Handler handler) throws CameraAccessException {
        if (cameraId == null) {
            throw new IllegalArgumentException("cameraId was null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener was null");
        }
        if (handler == null) {
            if (Looper.myLooper() != null) {
                handler = new Handler();
            } else {
                throw new IllegalArgumentException("Looper doesn't exist in the calling thread");
            }
        }
        this.openCameraDeviceUserAsync(cameraId, listener, handler);
    }

    private ArrayList<String> getOrCreateDeviceIdListLocked() throws CameraAccessException {
        if (this.mDeviceIdList == null) {
            int numCameras = 0;
            try {
                numCameras = this.mCameraService.getNumberOfCameras();
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return null;
            }
            this.mDeviceIdList = new ArrayList();
            CameraMetadataNative info = new CameraMetadataNative();
            for (int i = 0; i < numCameras; ++i) {
                boolean isDeviceSupported = false;
                try {
                    this.mCameraService.getCameraCharacteristics(i, info);
                    if (info.isEmpty()) {
                        throw new AssertionError((Object)"Expected to get non-empty characteristics");
                    }
                    isDeviceSupported = true;
                }
                catch (IllegalArgumentException e) {
                }
                catch (CameraRuntimeException e) {
                    throw e.asChecked();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                if (!isDeviceSupported) continue;
                this.mDeviceIdList.add(String.valueOf(i));
            }
        }
        return this.mDeviceIdList;
    }

    private class CameraServiceListener
    extends ICameraServiceListener.Stub {
        public static final int STATUS_NOT_PRESENT = 0;
        public static final int STATUS_PRESENT = 1;
        public static final int STATUS_ENUMERATING = 2;
        public static final int STATUS_NOT_AVAILABLE = Integer.MIN_VALUE;
        private final ArrayMap<String, Integer> mDeviceStatus = new ArrayMap();
        private static final String TAG = "CameraServiceListener";

        private CameraServiceListener() {
        }

        public IBinder asBinder() {
            return this;
        }

        private boolean isAvailable(int status) {
            switch (status) {
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private boolean validStatus(int status) {
            switch (status) {
                case -2147483648: 
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusChanged(int status, int cameraId) throws RemoteException {
            Object object = CameraManager.this.mLock;
            synchronized (object) {
                Log.v(TAG, String.format("Camera id %d has status changed to 0x%x", cameraId, status));
                final String id2 = String.valueOf(cameraId);
                if (!this.validStatus(status)) {
                    Log.e(TAG, String.format("Ignoring invalid device %d status 0x%x", cameraId, status));
                    return;
                }
                Integer oldStatus = this.mDeviceStatus.put(id2, status);
                if (oldStatus != null && oldStatus == status) {
                    Log.v(TAG, String.format("Device status changed to 0x%x, which is what it already was", status));
                    return;
                }
                if (oldStatus != null && this.isAvailable(status) == this.isAvailable(oldStatus)) {
                    Log.v(TAG, String.format("Device status was previously available (%d),  and is now again available (%d)so no new client visible update will be sent", this.isAvailable(status), this.isAvailable(status)));
                    return;
                }
                int listenerCount = CameraManager.this.mListenerMap.size();
                for (int i = 0; i < listenerCount; ++i) {
                    Handler handler = (Handler)CameraManager.this.mListenerMap.valueAt(i);
                    final AvailabilityListener listener = (AvailabilityListener)CameraManager.this.mListenerMap.keyAt(i);
                    if (this.isAvailable(status)) {
                        handler.post(new Runnable(){

                            public void run() {
                                listener.onCameraAvailable(id2);
                            }
                        });
                        continue;
                    }
                    handler.post(new Runnable(){

                        public void run() {
                            listener.onCameraUnavailable(id2);
                        }
                    });
                }
            }
        }
    }

    public static abstract class AvailabilityListener {
        public void onCameraAvailable(String cameraId) {
        }

        public void onCameraUnavailable(String cameraId) {
        }
    }
}

