/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.os.Handler;
import android.view.Surface;
import com.android.tools.layoutlib.java.AutoCloseable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CameraDevice
extends AutoCloseable {
    public static final int TEMPLATE_PREVIEW = 1;
    public static final int TEMPLATE_STILL_CAPTURE = 2;
    public static final int TEMPLATE_RECORD = 3;
    public static final int TEMPLATE_VIDEO_SNAPSHOT = 4;
    public static final int TEMPLATE_ZERO_SHUTTER_LAG = 5;
    public static final int TEMPLATE_MANUAL = 6;

    public String getId();

    public void configureOutputs(List<Surface> var1) throws CameraAccessException;

    public CaptureRequest.Builder createCaptureRequest(int var1) throws CameraAccessException;

    public int capture(CaptureRequest var1, CaptureListener var2, Handler var3) throws CameraAccessException;

    public int captureBurst(List<CaptureRequest> var1, CaptureListener var2, Handler var3) throws CameraAccessException;

    public int setRepeatingRequest(CaptureRequest var1, CaptureListener var2, Handler var3) throws CameraAccessException;

    public int setRepeatingBurst(List<CaptureRequest> var1, CaptureListener var2, Handler var3) throws CameraAccessException;

    public void stopRepeating() throws CameraAccessException;

    public void waitUntilIdle() throws CameraAccessException;

    public void flush() throws CameraAccessException;

    @Override
    public void close();

    public static abstract class StateListener {
        public static final int ERROR_CAMERA_IN_USE = 1;
        public static final int ERROR_MAX_CAMERAS_IN_USE = 2;
        public static final int ERROR_CAMERA_DISABLED = 3;
        public static final int ERROR_CAMERA_DEVICE = 4;
        public static final int ERROR_CAMERA_SERVICE = 5;

        public abstract void onOpened(CameraDevice var1);

        public void onUnconfigured(CameraDevice camera) {
        }

        public void onActive(CameraDevice camera) {
        }

        public void onBusy(CameraDevice camera) {
        }

        public void onClosed(CameraDevice camera) {
        }

        public void onIdle(CameraDevice camera) {
        }

        public abstract void onDisconnected(CameraDevice var1);

        public abstract void onError(CameraDevice var1, int var2);
    }

    public static abstract class CaptureListener {
        public void onCaptureStarted(CameraDevice camera, CaptureRequest request, long timestamp) {
        }

        public void onCapturePartial(CameraDevice camera, CaptureRequest request, CaptureResult result) {
        }

        public void onCaptureCompleted(CameraDevice camera, CaptureRequest request, CaptureResult result) {
        }

        public void onCaptureFailed(CameraDevice camera, CaptureRequest request, CaptureFailure failure) {
        }

        public void onCaptureSequenceCompleted(CameraDevice camera, int sequenceId, int frameNumber) {
        }
    }
}

