/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.Typeface_Delegate;
import android.util.LongSparseArray;
import android.util.SparseArray;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;

public class Typeface {
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    public static final Typeface MONOSPACE;
    static Typeface[] sDefaults;
    private static final LongSparseArray<SparseArray<Typeface>> sTypefaceCache;
    long native_instance;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    private int mStyle = 0;

    public int getStyle() {
        return this.mStyle;
    }

    public boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    public static Typeface create(String familyName, int style2) {
        return new Typeface(Typeface.nativeCreate(familyName, style2));
    }

    public static Typeface create(Typeface family, int style2) {
        Typeface typeface;
        SparseArray<Typeface> styles;
        long ni = 0L;
        if (family != null) {
            if (family.mStyle == style2) {
                return family;
            }
            ni = family.native_instance;
        }
        if ((styles = sTypefaceCache.get(ni)) != null && (typeface = styles.get(style2)) != null) {
            return typeface;
        }
        typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
        if (styles == null) {
            styles = new SparseArray(4);
            sTypefaceCache.put(ni, styles);
        }
        styles.put(style2, typeface);
        return typeface;
    }

    public static Typeface defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    public static Typeface createFromAsset(AssetManager mgr, String path) {
        return new Typeface(Typeface.nativeCreateFromAsset(mgr, path));
    }

    public static Typeface createFromFile(File path) {
        return new Typeface(Typeface.nativeCreateFromFile(path.getAbsolutePath()));
    }

    public static Typeface createFromFile(String path) {
        return new Typeface(Typeface.nativeCreateFromFile(path));
    }

    private Typeface(long ni) {
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mStyle = Typeface.nativeGetStyle(ni);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    @LayoutlibDelegate
    private static long nativeCreate(String string2, int n) {
        return Typeface_Delegate.nativeCreate(string2, n);
    }

    @LayoutlibDelegate
    private static long nativeCreateFromTypeface(long l, int n) {
        return Typeface_Delegate.nativeCreateFromTypeface(l, n);
    }

    @LayoutlibDelegate
    private static void nativeUnref(long l) {
        Typeface_Delegate.nativeUnref(l);
    }

    @LayoutlibDelegate
    private static int nativeGetStyle(long l) {
        return Typeface_Delegate.nativeGetStyle(l);
    }

    @LayoutlibDelegate
    private static long nativeCreateFromAsset(AssetManager assetManager, String string2) {
        return Typeface_Delegate.nativeCreateFromAsset(assetManager, string2);
    }

    @LayoutlibDelegate
    private static long nativeCreateFromFile(String string2) {
        return Typeface_Delegate.nativeCreateFromFile(string2);
    }

    static {
        sTypefaceCache = new LongSparseArray(3);
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }
}

