/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Gradient_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public class SweepGradient_Delegate
extends Gradient_Delegate {
    private Paint mJavaPaint;

    public Paint getJavaPaint() {
        return this.mJavaPaint;
    }

    @LayoutlibDelegate
    static long nativeCreate1(float f, float f2, int[] nArray, float[] fArray) {
        SweepGradient_Delegate sweepGradient_Delegate = new SweepGradient_Delegate(f, f2, nArray, fArray);
        return sManager.addNewDelegate(sweepGradient_Delegate);
    }

    @LayoutlibDelegate
    static long nativeCreate2(float f, float f2, int n, int n2) {
        return SweepGradient_Delegate.nativeCreate1(f, f2, new int[]{n, n2}, null);
    }

    @LayoutlibDelegate
    static long nativePostCreate1(long l, float f, float f2, int[] nArray, float[] fArray) {
        return 0L;
    }

    @LayoutlibDelegate
    static long nativePostCreate2(long l, float f, float f2, int n, int n2) {
        return 0L;
    }

    private SweepGradient_Delegate(float f, float f2, int[] nArray, float[] fArray) {
        super(nArray, fArray);
        this.mJavaPaint = new SweepGradientPaint(f, f2, this.mColors, this.mPositions);
    }

    private class SweepGradientPaint
    extends Gradient_Delegate.GradientPaint {
        private final float mCx;
        private final float mCy;

        public SweepGradientPaint(float f, float f2, int[] nArray, float[] fArray) {
            super(nArray, fArray, null);
            this.mCx = f;
            this.mCy = f2;
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            AffineTransform affineTransform2;
            this.precomputeGradientColors();
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in SweepGradient", (Throwable)noninvertibleTransformException, null);
                affineTransform2 = new AffineTransform();
            }
            AffineTransform affineTransform3 = SweepGradient_Delegate.this.getLocalMatrix();
            try {
                affineTransform3 = affineTransform3.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in SweepGradient", (Throwable)noninvertibleTransformException, null);
                affineTransform3 = new AffineTransform();
            }
            return new SweepGradientPaintContext(affineTransform2, affineTransform3, colorModel);
        }

        private class SweepGradientPaintContext
        implements PaintContext {
            private final AffineTransform mCanvasMatrix;
            private final AffineTransform mLocalMatrix;
            private final ColorModel mColorModel;

            public SweepGradientPaintContext(AffineTransform affineTransform, AffineTransform affineTransform2, ColorModel colorModel) {
                this.mCanvasMatrix = affineTransform;
                this.mLocalMatrix = affineTransform2;
                this.mColorModel = colorModel;
            }

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return this.mColorModel;
            }

            public Raster getRaster(int n, int n2, int n3, int n4) {
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
                int[] nArray = new int[n3 * n4];
                int n5 = 0;
                float[] fArray = new float[2];
                float[] fArray2 = new float[2];
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        float f;
                        fArray[0] = n + j;
                        fArray[1] = n2 + i;
                        this.mCanvasMatrix.transform(fArray, 0, fArray2, 0, 1);
                        fArray[0] = fArray2[0] - SweepGradientPaint.this.mCx;
                        fArray[1] = fArray2[1] - SweepGradientPaint.this.mCy;
                        this.mLocalMatrix.transform(fArray, 0, fArray2, 0, 1);
                        float f2 = fArray2[0];
                        float f3 = fArray2[1];
                        if (f2 == 0.0f) {
                            f = (float)(f3 < 0.0f ? 4.71238898038469 : 1.5707963267948966);
                        } else if (f3 == 0.0f) {
                            f = (float)(f2 < 0.0f ? Math.PI : 0.0);
                        } else {
                            f = (float)Math.atan(f3 / f2);
                            if (f2 > 0.0f) {
                                if (f3 < 0.0f) {
                                    f = (float)((double)f + Math.PI * 2);
                                }
                            } else {
                                f = (float)((double)f + Math.PI);
                            }
                        }
                        nArray[n5++] = SweepGradientPaint.this.getGradientColor((float)((double)f / (Math.PI * 2)));
                    }
                }
                bufferedImage.setRGB(0, 0, n3, n4, nArray, 0, n3);
                return bufferedImage.getRaster();
            }
        }
    }
}

