/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path_Delegate;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class Region_Delegate {
    protected static final DelegateManager<Region_Delegate> sManager = new DelegateManager<Region_Delegate>(Region_Delegate.class);
    private Area mArea = new Area();

    public static Region_Delegate getDelegate(long l) {
        return sManager.getDelegate(l);
    }

    public Area getJavaArea() {
        return this.mArea;
    }

    public static Area combineShapes(Shape shape, Shape shape2, int n) {
        if (n == Region.Op.DIFFERENCE.nativeInt) {
            if (shape == null) {
                return null;
            }
            Area area = new Area(shape);
            area.subtract(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return area;
        }
        if (n == Region.Op.INTERSECT.nativeInt) {
            if (shape == null) {
                return new Area(shape2);
            }
            Area area = new Area(shape);
            area.intersect(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return area;
        }
        if (n == Region.Op.UNION.nativeInt) {
            if (shape == null) {
                return new Area(shape2);
            }
            Area area = new Area(shape);
            area.add(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return area;
        }
        if (n == Region.Op.XOR.nativeInt) {
            if (shape == null) {
                return new Area(shape2);
            }
            Area area = new Area(shape);
            area.exclusiveOr(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return area;
        }
        if (n == Region.Op.REVERSE_DIFFERENCE.nativeInt) {
            Area area = new Area(shape2);
            if (shape != null) {
                area.subtract(shape instanceof Area ? (Area)shape : new Area(shape));
            }
            return area;
        }
        return null;
    }

    @LayoutlibDelegate
    static boolean isEmpty(Region region) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return true;
        }
        return region_Delegate.mArea.isEmpty();
    }

    @LayoutlibDelegate
    static boolean isRect(Region region) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return true;
        }
        return region_Delegate.mArea.isRectangular();
    }

    @LayoutlibDelegate
    static boolean isComplex(Region region) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return true;
        }
        return !region_Delegate.mArea.isSingular();
    }

    @LayoutlibDelegate
    static boolean contains(Region region, int n, int n2) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return false;
        }
        return region_Delegate.mArea.contains(n, n2);
    }

    @LayoutlibDelegate
    static boolean quickContains(Region region, int n, int n2, int n3, int n4) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return false;
        }
        return region_Delegate.mArea.isRectangular() && region_Delegate.mArea.contains(n, n2, n3 - n, n4 - n2);
    }

    @LayoutlibDelegate
    static boolean quickReject(Region region, int n, int n2, int n3, int n4) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return false;
        }
        return region_Delegate.mArea.isEmpty() || !region_Delegate.mArea.intersects(n, n2, n3 - n, n4 - n2);
    }

    @LayoutlibDelegate
    static boolean quickReject(Region region, Region region2) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return false;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(region2.mNativeRegion);
        if (region_Delegate2 == null) {
            return false;
        }
        return region_Delegate.mArea.isEmpty() || !region_Delegate.mArea.getBounds().intersects(region_Delegate2.mArea.getBounds());
    }

    @LayoutlibDelegate
    static void translate(Region region, int n, int n2, Region region2) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(region2.mNativeRegion);
        if (region_Delegate2 == null) {
            return;
        }
        if (region_Delegate.mArea.isEmpty()) {
            region_Delegate2.mArea = new Area();
        } else {
            region_Delegate2.mArea = new Area(region_Delegate.mArea);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            region_Delegate2.mArea.transform(affineTransform);
        }
    }

    @LayoutlibDelegate
    static void scale(Region region, float f, Region region2) {
        Region_Delegate region_Delegate = sManager.getDelegate(region.mNativeRegion);
        if (region_Delegate == null) {
            return;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(region2.mNativeRegion);
        if (region_Delegate2 == null) {
            return;
        }
        if (region_Delegate.mArea.isEmpty()) {
            region_Delegate2.mArea = new Area();
        } else {
            region_Delegate2.mArea = new Area(region_Delegate.mArea);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(f, f);
            region_Delegate2.mArea.transform(affineTransform);
        }
    }

    @LayoutlibDelegate
    static long nativeConstructor() {
        Region_Delegate region_Delegate = new Region_Delegate();
        return sManager.addNewDelegate(region_Delegate);
    }

    @LayoutlibDelegate
    static void nativeDestructor(long l) {
        sManager.removeJavaReferenceFor(l);
    }

    @LayoutlibDelegate
    static void nativeSetRegion(long l, long l2) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(l2);
        if (region_Delegate2 == null) {
            return;
        }
        region_Delegate.mArea.reset();
        region_Delegate.mArea.add(region_Delegate2.mArea);
    }

    @LayoutlibDelegate
    static boolean nativeSetRect(long l, int n, int n2, int n3, int n4) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return true;
        }
        region_Delegate.mArea = new Area(new Rectangle2D.Float(n, n2, n3 - n, n4 - n2));
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeSetPath(long l, long l2, long l3) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return true;
        }
        Path_Delegate path_Delegate = Path_Delegate.getDelegate(l2);
        if (path_Delegate == null) {
            return true;
        }
        region_Delegate.mArea = new Area(path_Delegate.getJavaShape());
        Region_Delegate region_Delegate2 = sManager.getDelegate(l3);
        if (region_Delegate2 != null) {
            region_Delegate.mArea.subtract(region_Delegate2.getJavaArea());
        }
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeGetBounds(long l, Rect rect) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return true;
        }
        Rectangle rectangle = region_Delegate.mArea.getBounds();
        if (rectangle.isEmpty()) {
            rect.bottom = 0;
            rect.right = 0;
            rect.top = 0;
            rect.left = 0;
            return false;
        }
        rect.left = rectangle.x;
        rect.top = rectangle.y;
        rect.right = rectangle.x + rectangle.width;
        rect.bottom = rectangle.y + rectangle.height;
        return true;
    }

    @LayoutlibDelegate
    static boolean nativeGetBoundaryPath(long l, long l2) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return false;
        }
        Path_Delegate path_Delegate = Path_Delegate.getDelegate(l2);
        if (path_Delegate == null) {
            return false;
        }
        if (region_Delegate.mArea.isEmpty()) {
            path_Delegate.reset();
            return false;
        }
        path_Delegate.setPathIterator(region_Delegate.mArea.getPathIterator(new AffineTransform()));
        return true;
    }

    @LayoutlibDelegate
    static boolean nativeOp(long l, int n, int n2, int n3, int n4, int n5) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return false;
        }
        region_Delegate.mArea = Region_Delegate.combineShapes(region_Delegate.mArea, new Rectangle2D.Float(n, n2, n3 - n, n4 - n2), n5);
        assert (region_Delegate.mArea != null);
        if (region_Delegate.mArea != null) {
            region_Delegate.mArea = new Area();
        }
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeOp(long l, Rect rect, long l2, int n) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return false;
        }
        region_Delegate.mArea = Region_Delegate.combineShapes(region_Delegate.mArea, new Rectangle2D.Float(rect.left, rect.top, rect.width(), rect.height()), n);
        assert (region_Delegate.mArea != null);
        if (region_Delegate.mArea != null) {
            region_Delegate.mArea = new Area();
        }
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeOp(long l, long l2, long l3, int n) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return true;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(l2);
        if (region_Delegate2 == null) {
            return false;
        }
        Region_Delegate region_Delegate3 = sManager.getDelegate(l3);
        if (region_Delegate3 == null) {
            return false;
        }
        region_Delegate.mArea = Region_Delegate.combineShapes(region_Delegate2.mArea, region_Delegate3.mArea, n);
        assert (region_Delegate.mArea != null);
        if (region_Delegate.mArea != null) {
            region_Delegate.mArea = new Area();
        }
        return !region_Delegate.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static long nativeCreateFromParcel(Parcel parcel) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Regions cannot be created from parcels.", null);
        return 0L;
    }

    @LayoutlibDelegate
    static boolean nativeWriteToParcel(long l, Parcel parcel) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Regions cannot be written to parcels.", null);
        return false;
    }

    @LayoutlibDelegate
    static boolean nativeEquals(long l, long l2) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return false;
        }
        Region_Delegate region_Delegate2 = sManager.getDelegate(l2);
        if (region_Delegate2 == null) {
            return false;
        }
        return region_Delegate.mArea.equals(region_Delegate2.mArea);
    }

    @LayoutlibDelegate
    static String nativeToString(long l) {
        Region_Delegate region_Delegate = sManager.getDelegate(l);
        if (region_Delegate == null) {
            return "not found";
        }
        return region_Delegate.mArea.toString();
    }
}

