/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix_Delegate;
import android.graphics.Path;
import android.graphics.RectF;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public final class Path_Delegate {
    private static final DelegateManager<Path_Delegate> sManager = new DelegateManager<Path_Delegate>(Path_Delegate.class);
    private Path.FillType mFillType = Path.FillType.WINDING;
    private GeneralPath mPath = new GeneralPath();
    private float mLastX = 0.0f;
    private float mLastY = 0.0f;

    public static Path_Delegate getDelegate(long l) {
        return sManager.getDelegate(l);
    }

    public Shape getJavaShape() {
        return this.mPath;
    }

    public void setJavaShape(Shape shape) {
        this.mPath.reset();
        this.mPath.append(shape, false);
    }

    public void reset() {
        this.mPath.reset();
    }

    public void setPathIterator(PathIterator pathIterator) {
        this.mPath.reset();
        this.mPath.append(pathIterator, false);
    }

    @LayoutlibDelegate
    static long init1() {
        Path_Delegate path_Delegate = new Path_Delegate();
        return sManager.addNewDelegate(path_Delegate);
    }

    @LayoutlibDelegate
    static long init2(long l) {
        Path_Delegate path_Delegate = new Path_Delegate();
        Path_Delegate path_Delegate2 = sManager.getDelegate(l);
        if (path_Delegate2 != null) {
            path_Delegate.set(path_Delegate2);
        }
        return sManager.addNewDelegate(path_Delegate);
    }

    @LayoutlibDelegate
    static void native_reset(long l) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.mPath.reset();
    }

    @LayoutlibDelegate
    static void native_rewind(long l) {
        Path_Delegate.native_reset(l);
    }

    @LayoutlibDelegate
    static void native_set(long l, long l2) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        Path_Delegate path_Delegate2 = sManager.getDelegate(l2);
        if (path_Delegate2 == null) {
            return;
        }
        path_Delegate.set(path_Delegate2);
    }

    @LayoutlibDelegate
    static int native_getFillType(long l) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return 0;
        }
        return path_Delegate.mFillType.nativeInt;
    }

    @LayoutlibDelegate
    static void native_setFillType(long l, int n) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.mFillType = Path.sFillTypeArray[n];
    }

    @LayoutlibDelegate
    static boolean native_isEmpty(long l) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return true;
        }
        return path_Delegate.isEmpty();
    }

    @LayoutlibDelegate
    static boolean native_isRect(long l, RectF rectF) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return false;
        }
        Area area = new Area(path_Delegate.mPath);
        if (area.isRectangular()) {
            if (rectF != null) {
                path_Delegate.fillBounds(rectF);
            }
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static void native_computeBounds(long l, RectF rectF) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.fillBounds(rectF);
    }

    @LayoutlibDelegate
    static void native_incReserve(long l, int n) {
    }

    @LayoutlibDelegate
    static void native_moveTo(long l, float f, float f2) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.moveTo(f, f2);
    }

    @LayoutlibDelegate
    static void native_rMoveTo(long l, float f, float f2) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.rMoveTo(f, f2);
    }

    @LayoutlibDelegate
    static void native_lineTo(long l, float f, float f2) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.lineTo(f, f2);
    }

    @LayoutlibDelegate
    static void native_rLineTo(long l, float f, float f2) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.rLineTo(f, f2);
    }

    @LayoutlibDelegate
    static void native_quadTo(long l, float f, float f2, float f3, float f4) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.quadTo(f, f2, f3, f4);
    }

    @LayoutlibDelegate
    static void native_rQuadTo(long l, float f, float f2, float f3, float f4) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.rQuadTo(f, f2, f3, f4);
    }

    @LayoutlibDelegate
    static void native_cubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.cubicTo(f, f2, f3, f4, f5, f6);
    }

    @LayoutlibDelegate
    static void native_rCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.rCubicTo(f, f2, f3, f4, f5, f6);
    }

    @LayoutlibDelegate
    static void native_arcTo(long l, RectF rectF, float f, float f2, boolean bl) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.arcTo(rectF, f, f2, bl);
    }

    @LayoutlibDelegate
    static void native_close(long l) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.close();
    }

    @LayoutlibDelegate
    static void native_addRect(long l, RectF rectF, int n) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.addRect(rectF.left, rectF.top, rectF.right, rectF.bottom, n);
    }

    @LayoutlibDelegate
    static void native_addRect(long l, float f, float f2, float f3, float f4, int n) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.addRect(f, f2, f3, f4, n);
    }

    @LayoutlibDelegate
    static void native_addOval(long l, RectF rectF, int n) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.mPath.append(new Ellipse2D.Float(rectF.left, rectF.top, rectF.width(), rectF.height()), false);
    }

    @LayoutlibDelegate
    static void native_addCircle(long l, float f, float f2, float f3, int n) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.mPath.append(new Ellipse2D.Float(f - f3, f2 - f3, f3 * 2.0f, f3 * 2.0f), false);
    }

    @LayoutlibDelegate
    static void native_addArc(long l, RectF rectF, float f, float f2) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.mPath.append(new Arc2D.Float(rectF.left, rectF.top, rectF.width(), rectF.height(), -f, -f2, 0), false);
    }

    @LayoutlibDelegate
    static void native_addRoundRect(long l, RectF rectF, float f, float f2, int n) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.mPath.append(new RoundRectangle2D.Float(rectF.left, rectF.top, rectF.width(), rectF.height(), f * 2.0f, f2 * 2.0f), false);
    }

    @LayoutlibDelegate
    static void native_addRoundRect(long l, RectF rectF, float[] fArray, int n) {
        Path_Delegate.native_addRoundRect(l, rectF, fArray[0], fArray[1], n);
        for (int i = 0; i < 3; ++i) {
            if (fArray[i * 2] == fArray[(i + 1) * 2] && fArray[i * 2 + 1] == fArray[(i + 1) * 2 + 1]) continue;
            Bridge.getLog().fidelityWarning("unsupported", "Different corner sizes are not supported in Path.addRoundRect.", null, null);
            break;
        }
    }

    @LayoutlibDelegate
    static void native_addPath(long l, long l2, float f, float f2) {
        Path_Delegate.addPath(l, l2, AffineTransform.getTranslateInstance(f, f2));
    }

    @LayoutlibDelegate
    static void native_addPath(long l, long l2) {
        Path_Delegate.addPath(l, l2, null);
    }

    @LayoutlibDelegate
    static void native_addPath(long l, long l2, long l3) {
        Matrix_Delegate matrix_Delegate = Matrix_Delegate.getDelegate(l3);
        if (matrix_Delegate == null) {
            return;
        }
        Path_Delegate.addPath(l, l2, matrix_Delegate.getAffineTransform());
    }

    @LayoutlibDelegate
    static void native_offset(long l, float f, float f2, long l2) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        Path_Delegate path_Delegate2 = sManager.getDelegate(l2);
        path_Delegate.offset(f, f2, path_Delegate2);
    }

    @LayoutlibDelegate
    static void native_offset(long l, float f, float f2) {
        Path_Delegate.native_offset(l, f, f2, 0L);
    }

    @LayoutlibDelegate
    static void native_setLastPoint(long l, float f, float f2) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        path_Delegate.mLastX = f;
        path_Delegate.mLastY = f2;
    }

    @LayoutlibDelegate
    static void native_transform(long l, long l2, long l3) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        Matrix_Delegate matrix_Delegate = Matrix_Delegate.getDelegate(l2);
        if (matrix_Delegate == null) {
            return;
        }
        Path_Delegate path_Delegate2 = sManager.getDelegate(l3);
        path_Delegate.transform(matrix_Delegate, path_Delegate2);
    }

    @LayoutlibDelegate
    static void native_transform(long l, long l2) {
        Path_Delegate.native_transform(l, l2, 0L);
    }

    @LayoutlibDelegate
    static boolean native_op(long l, long l2, int n, long l3) {
        Bridge.getLog().error("unsupported", "Path.op() not supported", null);
        return false;
    }

    @LayoutlibDelegate
    static void finalizer(long l) {
        sManager.removeJavaReferenceFor(l);
    }

    private void set(Path_Delegate path_Delegate) {
        this.mPath.reset();
        this.setFillType(path_Delegate.mFillType);
        this.mPath.append(path_Delegate.mPath, false);
    }

    private void setFillType(Path.FillType fillType) {
        this.mFillType = fillType;
        this.mPath.setWindingRule(Path_Delegate.getWindingRule(fillType));
    }

    private static int getWindingRule(Path.FillType fillType) {
        switch (fillType) {
            case WINDING: 
            case INVERSE_WINDING: {
                return 1;
            }
            case EVEN_ODD: 
            case INVERSE_EVEN_ODD: {
                return 0;
            }
        }
        assert (false);
        throw new IllegalArgumentException();
    }

    private static Path.Direction getDirection(int n) {
        for (Path.Direction direction : Path.Direction.values()) {
            if (n != direction.nativeInt) continue;
            return direction;
        }
        assert (false);
        return null;
    }

    private static void addPath(long l, long l2, AffineTransform affineTransform) {
        Path_Delegate path_Delegate = sManager.getDelegate(l);
        if (path_Delegate == null) {
            return;
        }
        Path_Delegate path_Delegate2 = sManager.getDelegate(l2);
        if (path_Delegate2 == null) {
            return;
        }
        if (affineTransform != null) {
            path_Delegate.mPath.append(path_Delegate2.mPath.getPathIterator(affineTransform), false);
        } else {
            path_Delegate.mPath.append(path_Delegate2.mPath, false);
        }
    }

    private boolean isEmpty() {
        return this.mPath.getCurrentPoint() == null;
    }

    private void fillBounds(RectF rectF) {
        Rectangle2D rectangle2D = this.mPath.getBounds2D();
        rectF.left = (float)rectangle2D.getMinX();
        rectF.right = (float)rectangle2D.getMaxX();
        rectF.top = (float)rectangle2D.getMinY();
        rectF.bottom = (float)rectangle2D.getMaxY();
    }

    private void moveTo(float f, float f2) {
        this.mLastX = f;
        this.mLastY = f2;
        this.mPath.moveTo(this.mLastX, this.mLastY);
    }

    private void rMoveTo(float f, float f2) {
        this.mLastX = f += this.mLastX;
        this.mLastY = f2 += this.mLastY;
        this.mPath.moveTo(this.mLastX, this.mLastY);
    }

    private void lineTo(float f, float f2) {
        this.mLastX = f;
        this.mLastY = f2;
        this.mPath.lineTo(this.mLastX, this.mLastY);
    }

    private void rLineTo(float f, float f2) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = f += this.mLastX;
        this.mLastY = f2 += this.mLastY;
        this.mPath.lineTo(this.mLastX, this.mLastY);
    }

    private void quadTo(float f, float f2, float f3, float f4) {
        this.mLastX = f3;
        this.mLastY = f4;
        this.mPath.quadTo(f, f2, this.mLastX, this.mLastY);
    }

    private void rQuadTo(float f, float f2, float f3, float f4) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = f3 += this.mLastX;
        this.mLastY = f4 += this.mLastY;
        this.mPath.quadTo(f += this.mLastX, f2 += this.mLastY, this.mLastX, this.mLastY);
    }

    private void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mLastX = f5;
        this.mLastY = f6;
        this.mPath.curveTo(f, f2, f3, f4, this.mLastX, this.mLastY);
    }

    private void rCubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isEmpty()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = f5 += this.mLastX;
        this.mLastY = f6 += this.mLastY;
        this.mPath.curveTo(f += this.mLastX, f2 += this.mLastY, f3 += this.mLastX, f4 += this.mLastY, this.mLastX, this.mLastY);
    }

    private void arcTo(RectF rectF, float f, float f2, boolean bl) {
        Arc2D.Float float_ = new Arc2D.Float(rectF.left, rectF.top, rectF.width(), rectF.height(), -f, -f2, 0);
        this.mPath.append(float_, true);
        this.resetLastPointFromPath();
    }

    private void close() {
        this.mPath.closePath();
    }

    private void resetLastPointFromPath() {
        Point2D point2D = this.mPath.getCurrentPoint();
        this.mLastX = (float)point2D.getX();
        this.mLastY = (float)point2D.getY();
    }

    private void addRect(float f, float f2, float f3, float f4, int n) {
        this.moveTo(f, f2);
        Path.Direction direction = Path_Delegate.getDirection(n);
        switch (direction) {
            case CW: {
                this.lineTo(f3, f2);
                this.lineTo(f3, f4);
                this.lineTo(f, f4);
                break;
            }
            case CCW: {
                this.lineTo(f, f4);
                this.lineTo(f3, f4);
                this.lineTo(f3, f2);
            }
        }
        this.close();
        this.resetLastPointFromPath();
    }

    public void offset(float f, float f2, Path_Delegate path_Delegate) {
        GeneralPath generalPath = new GeneralPath();
        PathIterator pathIterator = this.mPath.getPathIterator(new AffineTransform(0.0f, 0.0f, f, 0.0f, 0.0f, f2));
        generalPath.append(pathIterator, false);
        if (path_Delegate != null) {
            path_Delegate.mPath = generalPath;
        } else {
            this.mPath = generalPath;
        }
    }

    public void transform(Matrix_Delegate matrix_Delegate, Path_Delegate path_Delegate) {
        if (matrix_Delegate.hasPerspective()) {
            assert (false);
            Bridge.getLog().fidelityWarning("matrix.affine", "android.graphics.Path#transform() only supports affine transformations.", null, null);
        }
        GeneralPath generalPath = new GeneralPath();
        PathIterator pathIterator = this.mPath.getPathIterator(matrix_Delegate.getAffineTransform());
        generalPath.append(pathIterator, false);
        if (path_Delegate != null) {
            path_Delegate.mPath = generalPath;
        } else {
            this.mPath = generalPath;
        }
    }
}

