/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Path;
import com.android.tools.layoutlib.create.OverrideMethod;

public class PathMeasure {
    private Path mPath;
    public static final int POSITION_MATRIX_FLAG = 1;
    public static final int TANGENT_MATRIX_FLAG = 2;
    private final long native_instance;

    public PathMeasure() {
        this.mPath = null;
        this.native_instance = PathMeasure.native_create(0L, false);
    }

    public PathMeasure(Path path, boolean forceClosed) {
        this.mPath = path;
        this.native_instance = PathMeasure.native_create(path != null ? path.ni() : 0L, forceClosed);
    }

    public void setPath(Path path, boolean forceClosed) {
        this.mPath = path;
        PathMeasure.native_setPath(this.native_instance, path != null ? path.ni() : 0L, forceClosed);
    }

    public float getLength() {
        return PathMeasure.native_getLength(this.native_instance);
    }

    public boolean getPosTan(float distance, float[] pos, float[] tan) {
        if (pos != null && pos.length < 2 || tan != null && tan.length < 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return PathMeasure.native_getPosTan(this.native_instance, distance, pos, tan);
    }

    public boolean getMatrix(float distance, Matrix matrix, int flags) {
        return PathMeasure.native_getMatrix(this.native_instance, distance, matrix.native_instance, flags);
    }

    public boolean getSegment(float startD, float stopD, Path dst, boolean startWithMoveTo) {
        return PathMeasure.native_getSegment(this.native_instance, startD, stopD, dst.ni(), startWithMoveTo);
    }

    public boolean isClosed() {
        return PathMeasure.native_isClosed(this.native_instance);
    }

    public boolean nextContour() {
        return PathMeasure.native_nextContour(this.native_instance);
    }

    protected void finalize() throws Throwable {
        PathMeasure.native_destroy(this.native_instance);
    }

    private static long native_create(long l, boolean bl) {
        return OverrideMethod.invokeL("android.graphics.PathMeasure#native_create(JZ)J", true, null);
    }

    private static void native_setPath(long l, long l2, boolean bl) {
        OverrideMethod.invokeV("android.graphics.PathMeasure#native_setPath(JJZ)V", true, null);
    }

    private static float native_getLength(long l) {
        return OverrideMethod.invokeF("android.graphics.PathMeasure#native_getLength(J)F", true, null);
    }

    private static boolean native_getPosTan(long l, float f, float[] fArray, float[] fArray2) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_getPosTan(JF[F[F)Z", true, null) != 0;
    }

    private static boolean native_getMatrix(long l, float f, long l2, int n) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_getMatrix(JFJI)Z", true, null) != 0;
    }

    private static boolean native_getSegment(long l, float f, float f2, long l2, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_getSegment(JFFJZ)Z", true, null) != 0;
    }

    private static boolean native_isClosed(long l) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_isClosed(J)Z", true, null) != 0;
    }

    private static boolean native_nextContour(long l) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_nextContour(J)Z", true, null) != 0;
    }

    private static void native_destroy(long l) {
        OverrideMethod.invokeV("android.graphics.PathMeasure#native_destroy(J)V", true, null);
    }
}

