/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Path_Delegate;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.HardwareRenderer;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class Path {
    public final long mNativePath;
    public boolean isSimplePath = true;
    public Region rects;
    private boolean mDetectSimplePaths;
    private Direction mLastDirection = null;
    static final FillType[] sFillTypeArray = new FillType[]{FillType.WINDING, FillType.EVEN_ODD, FillType.INVERSE_WINDING, FillType.INVERSE_EVEN_ODD};

    public Path() {
        this.mNativePath = Path.init1();
        this.mDetectSimplePaths = HardwareRenderer.isAvailable();
    }

    public Path(Path src) {
        long valNative = 0L;
        if (src != null) {
            valNative = src.mNativePath;
            this.isSimplePath = src.isSimplePath;
            if (src.rects != null) {
                this.rects = new Region(src.rects);
            }
        }
        this.mNativePath = Path.init2(valNative);
        this.mDetectSimplePaths = HardwareRenderer.isAvailable();
    }

    public void reset() {
        this.isSimplePath = true;
        if (this.mDetectSimplePaths) {
            this.mLastDirection = null;
            if (this.rects != null) {
                this.rects.setEmpty();
            }
        }
        FillType fillType = this.getFillType();
        Path.native_reset(this.mNativePath);
        this.setFillType(fillType);
    }

    public void rewind() {
        this.isSimplePath = true;
        if (this.mDetectSimplePaths) {
            this.mLastDirection = null;
            if (this.rects != null) {
                this.rects.setEmpty();
            }
        }
        Path.native_rewind(this.mNativePath);
    }

    public void set(Path src) {
        if (this != src) {
            this.isSimplePath = src.isSimplePath;
            Path.native_set(this.mNativePath, src.mNativePath);
        }
    }

    public boolean op(Path path, Op op) {
        return this.op(this, path, op);
    }

    public boolean op(Path path1, Path path2, Op op) {
        if (Path.native_op(path1.mNativePath, path2.mNativePath, op.ordinal(), this.mNativePath)) {
            this.isSimplePath = false;
            this.rects = null;
            return true;
        }
        return false;
    }

    public FillType getFillType() {
        return sFillTypeArray[Path.native_getFillType(this.mNativePath)];
    }

    public void setFillType(FillType ft) {
        Path.native_setFillType(this.mNativePath, ft.nativeInt);
    }

    public boolean isInverseFillType() {
        int ft = Path.native_getFillType(this.mNativePath);
        return (ft & 2) != 0;
    }

    public void toggleInverseFillType() {
        int ft = Path.native_getFillType(this.mNativePath);
        Path.native_setFillType(this.mNativePath, ft ^= 2);
    }

    public boolean isEmpty() {
        return Path.native_isEmpty(this.mNativePath);
    }

    public boolean isRect(RectF rect) {
        return Path.native_isRect(this.mNativePath, rect);
    }

    public void computeBounds(RectF bounds, boolean exact) {
        Path.native_computeBounds(this.mNativePath, bounds);
    }

    public void incReserve(int extraPtCount) {
        Path.native_incReserve(this.mNativePath, extraPtCount);
    }

    public void moveTo(float x, float y) {
        Path.native_moveTo(this.mNativePath, x, y);
    }

    public void rMoveTo(float dx, float dy) {
        Path.native_rMoveTo(this.mNativePath, dx, dy);
    }

    public void lineTo(float x, float y) {
        this.isSimplePath = false;
        Path.native_lineTo(this.mNativePath, x, y);
    }

    public void rLineTo(float dx, float dy) {
        this.isSimplePath = false;
        Path.native_rLineTo(this.mNativePath, dx, dy);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.isSimplePath = false;
        Path.native_quadTo(this.mNativePath, x1, y1, x2, y2);
    }

    public void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        this.isSimplePath = false;
        Path.native_rQuadTo(this.mNativePath, dx1, dy1, dx2, dy2);
    }

    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.isSimplePath = false;
        Path.native_cubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.isSimplePath = false;
        Path.native_rCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.isSimplePath = false;
        Path.native_arcTo(this.mNativePath, oval, startAngle, sweepAngle, forceMoveTo);
    }

    public void arcTo(RectF oval, float startAngle, float sweepAngle) {
        this.isSimplePath = false;
        Path.native_arcTo(this.mNativePath, oval, startAngle, sweepAngle, false);
    }

    public void close() {
        this.isSimplePath = false;
        Path.native_close(this.mNativePath);
    }

    private void detectSimplePath(float left, float top, float right, float bottom, Direction dir) {
        if (this.mDetectSimplePaths) {
            if (this.mLastDirection == null) {
                this.mLastDirection = dir;
            }
            if (this.mLastDirection != dir) {
                this.isSimplePath = false;
            } else {
                if (this.rects == null) {
                    this.rects = new Region();
                }
                this.rects.op((int)left, (int)top, (int)right, (int)bottom, Region.Op.UNION);
            }
        }
    }

    public void addRect(RectF rect, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        this.detectSimplePath(rect.left, rect.top, rect.right, rect.bottom, dir);
        Path.native_addRect(this.mNativePath, rect, dir.nativeInt);
    }

    public void addRect(float left, float top, float right, float bottom, Direction dir) {
        this.detectSimplePath(left, top, right, bottom, dir);
        Path.native_addRect(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    public void addOval(RectF oval, Direction dir) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        this.isSimplePath = false;
        Path.native_addOval(this.mNativePath, oval, dir.nativeInt);
    }

    public void addCircle(float x, float y, float radius, Direction dir) {
        this.isSimplePath = false;
        Path.native_addCircle(this.mNativePath, x, y, radius, dir.nativeInt);
    }

    public void addArc(RectF oval, float startAngle, float sweepAngle) {
        if (oval == null) {
            throw new NullPointerException("need oval parameter");
        }
        this.isSimplePath = false;
        Path.native_addArc(this.mNativePath, oval, startAngle, sweepAngle);
    }

    public void addRoundRect(RectF rect, float rx, float ry, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        this.isSimplePath = false;
        Path.native_addRoundRect(this.mNativePath, rect, rx, ry, dir.nativeInt);
    }

    public void addRoundRect(RectF rect, float[] radii, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        this.isSimplePath = false;
        Path.native_addRoundRect(this.mNativePath, rect, radii, dir.nativeInt);
    }

    public void addPath(Path src, float dx, float dy) {
        this.isSimplePath = false;
        Path.native_addPath(this.mNativePath, src.mNativePath, dx, dy);
    }

    public void addPath(Path src) {
        this.isSimplePath = false;
        Path.native_addPath(this.mNativePath, src.mNativePath);
    }

    public void addPath(Path src, Matrix matrix) {
        if (!src.isSimplePath) {
            this.isSimplePath = false;
        }
        Path.native_addPath(this.mNativePath, src.mNativePath, matrix.native_instance);
    }

    public void offset(float dx, float dy, Path dst) {
        long dstNative = 0L;
        if (dst != null) {
            dstNative = dst.mNativePath;
            dst.isSimplePath = false;
        }
        Path.native_offset(this.mNativePath, dx, dy, dstNative);
    }

    public void offset(float dx, float dy) {
        this.isSimplePath = false;
        Path.native_offset(this.mNativePath, dx, dy);
    }

    public void setLastPoint(float dx, float dy) {
        this.isSimplePath = false;
        Path.native_setLastPoint(this.mNativePath, dx, dy);
    }

    public void transform(Matrix matrix, Path dst) {
        long dstNative = 0L;
        if (dst != null) {
            dst.isSimplePath = false;
            dstNative = dst.mNativePath;
        }
        Path.native_transform(this.mNativePath, matrix.native_instance, dstNative);
    }

    public void transform(Matrix matrix) {
        this.isSimplePath = false;
        Path.native_transform(this.mNativePath, matrix.native_instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Path.finalizer(this.mNativePath);
        }
        finally {
            super.finalize();
        }
    }

    long ni() {
        return this.mNativePath;
    }

    @LayoutlibDelegate
    private static long init1() {
        return Path_Delegate.init1();
    }

    @LayoutlibDelegate
    private static long init2(long l) {
        return Path_Delegate.init2(l);
    }

    @LayoutlibDelegate
    private static void native_reset(long l) {
        Path_Delegate.native_reset(l);
    }

    @LayoutlibDelegate
    private static void native_rewind(long l) {
        Path_Delegate.native_rewind(l);
    }

    @LayoutlibDelegate
    private static void native_set(long l, long l2) {
        Path_Delegate.native_set(l, l2);
    }

    @LayoutlibDelegate
    private static int native_getFillType(long l) {
        return Path_Delegate.native_getFillType(l);
    }

    @LayoutlibDelegate
    private static void native_setFillType(long l, int n) {
        Path_Delegate.native_setFillType(l, n);
    }

    @LayoutlibDelegate
    private static boolean native_isEmpty(long l) {
        return Path_Delegate.native_isEmpty(l);
    }

    @LayoutlibDelegate
    private static boolean native_isRect(long l, RectF rectF) {
        return Path_Delegate.native_isRect(l, rectF);
    }

    @LayoutlibDelegate
    private static void native_computeBounds(long l, RectF rectF) {
        Path_Delegate.native_computeBounds(l, rectF);
    }

    @LayoutlibDelegate
    private static void native_incReserve(long l, int n) {
        Path_Delegate.native_incReserve(l, n);
    }

    @LayoutlibDelegate
    private static void native_moveTo(long l, float f, float f2) {
        Path_Delegate.native_moveTo(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_rMoveTo(long l, float f, float f2) {
        Path_Delegate.native_rMoveTo(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_lineTo(long l, float f, float f2) {
        Path_Delegate.native_lineTo(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_rLineTo(long l, float f, float f2) {
        Path_Delegate.native_rLineTo(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_quadTo(long l, float f, float f2, float f3, float f4) {
        Path_Delegate.native_quadTo(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_rQuadTo(long l, float f, float f2, float f3, float f4) {
        Path_Delegate.native_rQuadTo(l, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    private static void native_cubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        Path_Delegate.native_cubicTo(l, f, f2, f3, f4, f5, f6);
    }

    @LayoutlibDelegate
    private static void native_rCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        Path_Delegate.native_rCubicTo(l, f, f2, f3, f4, f5, f6);
    }

    @LayoutlibDelegate
    private static void native_arcTo(long l, RectF rectF, float f, float f2, boolean bl) {
        Path_Delegate.native_arcTo(l, rectF, f, f2, bl);
    }

    @LayoutlibDelegate
    private static void native_close(long l) {
        Path_Delegate.native_close(l);
    }

    @LayoutlibDelegate
    private static void native_addRect(long l, RectF rectF, int n) {
        Path_Delegate.native_addRect(l, rectF, n);
    }

    @LayoutlibDelegate
    private static void native_addRect(long l, float f, float f2, float f3, float f4, int n) {
        Path_Delegate.native_addRect(l, f, f2, f3, f4, n);
    }

    @LayoutlibDelegate
    private static void native_addOval(long l, RectF rectF, int n) {
        Path_Delegate.native_addOval(l, rectF, n);
    }

    @LayoutlibDelegate
    private static void native_addCircle(long l, float f, float f2, float f3, int n) {
        Path_Delegate.native_addCircle(l, f, f2, f3, n);
    }

    @LayoutlibDelegate
    private static void native_addArc(long l, RectF rectF, float f, float f2) {
        Path_Delegate.native_addArc(l, rectF, f, f2);
    }

    @LayoutlibDelegate
    private static void native_addRoundRect(long l, RectF rectF, float f, float f2, int n) {
        Path_Delegate.native_addRoundRect(l, rectF, f, f2, n);
    }

    @LayoutlibDelegate
    private static void native_addRoundRect(long l, RectF rectF, float[] fArray, int n) {
        Path_Delegate.native_addRoundRect(l, rectF, fArray, n);
    }

    @LayoutlibDelegate
    private static void native_addPath(long l, long l2, float f, float f2) {
        Path_Delegate.native_addPath(l, l2, f, f2);
    }

    @LayoutlibDelegate
    private static void native_addPath(long l, long l2) {
        Path_Delegate.native_addPath(l, l2);
    }

    @LayoutlibDelegate
    private static void native_addPath(long l, long l2, long l3) {
        Path_Delegate.native_addPath(l, l2, l3);
    }

    @LayoutlibDelegate
    private static void native_offset(long l, float f, float f2, long l2) {
        Path_Delegate.native_offset(l, f, f2, l2);
    }

    @LayoutlibDelegate
    private static void native_offset(long l, float f, float f2) {
        Path_Delegate.native_offset(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_setLastPoint(long l, float f, float f2) {
        Path_Delegate.native_setLastPoint(l, f, f2);
    }

    @LayoutlibDelegate
    private static void native_transform(long l, long l2, long l3) {
        Path_Delegate.native_transform(l, l2, l3);
    }

    @LayoutlibDelegate
    private static void native_transform(long l, long l2) {
        Path_Delegate.native_transform(l, l2);
    }

    @LayoutlibDelegate
    private static boolean native_op(long l, long l2, int n, long l3) {
        return Path_Delegate.native_op(l, l2, n, l3);
    }

    @LayoutlibDelegate
    private static void finalizer(long l) {
        Path_Delegate.finalizer(l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        CW(1),
        CCW(2);

        final int nativeInt;

        private Direction(int ni) {
            this.nativeInt = ni;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FillType {
        WINDING(0),
        EVEN_ODD(1),
        INVERSE_WINDING(2),
        INVERSE_EVEN_ODD(3);

        final int nativeInt;

        private FillType(int ni) {
            this.nativeInt = ni;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Op {
        DIFFERENCE,
        INTERSECT,
        UNION,
        XOR,
        REVERSE_DIFFERENCE;

    }
}

