/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.NinePatch_Delegate;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class NinePatch {
    private final Bitmap mBitmap;
    public final long mNativeChunk;
    private Paint mPaint;
    private String mSrcName;

    public NinePatch(Bitmap bitmap, byte[] chunk) {
        this(bitmap, chunk, null);
    }

    public NinePatch(Bitmap bitmap, byte[] chunk, String srcName) {
        this.mBitmap = bitmap;
        this.mSrcName = srcName;
        this.mNativeChunk = NinePatch.validateNinePatchChunk(this.mBitmap.ni(), chunk);
    }

    public NinePatch(NinePatch patch) {
        this.mBitmap = patch.mBitmap;
        this.mSrcName = patch.mSrcName;
        if (patch.mPaint != null) {
            this.mPaint = new Paint(patch.mPaint);
        }
        this.mNativeChunk = patch.mNativeChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            NinePatch.nativeFinalize(this.mNativeChunk);
        }
        finally {
            super.finalize();
        }
    }

    public String getName() {
        return this.mSrcName;
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public void setPaint(Paint p) {
        this.mPaint = p;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void draw(Canvas canvas, RectF location) {
        canvas.drawPatch(this, location, this.mPaint);
    }

    public void draw(Canvas canvas, Rect location) {
        canvas.drawPatch(this, location, this.mPaint);
    }

    public void draw(Canvas canvas, Rect location, Paint paint) {
        canvas.drawPatch(this, location, paint);
    }

    void drawSoftware(Canvas canvas, RectF location, Paint paint) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mNativeChunk, paint != null ? paint.mNativePaint : 0L, canvas.mDensity, this.mBitmap.mDensity);
    }

    void drawSoftware(Canvas canvas, Rect location, Paint paint) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mNativeChunk, paint != null ? paint.mNativePaint : 0L, canvas.mDensity, this.mBitmap.mDensity);
    }

    public int getDensity() {
        return this.mBitmap.mDensity;
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    public boolean hasAlpha() {
        return this.mBitmap.hasAlpha();
    }

    public Region getTransparentRegion(Rect bounds) {
        long r = NinePatch.nativeGetTransparentRegion(this.mBitmap.ni(), this.mNativeChunk, bounds);
        return r != 0L ? new Region(r) : null;
    }

    @LayoutlibDelegate
    public static boolean isNinePatchChunk(byte[] byArray) {
        return NinePatch_Delegate.isNinePatchChunk(byArray);
    }

    @LayoutlibDelegate
    private static long validateNinePatchChunk(long l, byte[] byArray) {
        return NinePatch_Delegate.validateNinePatchChunk(l, byArray);
    }

    @LayoutlibDelegate
    private static void nativeFinalize(long l) {
        NinePatch_Delegate.nativeFinalize(l);
    }

    @LayoutlibDelegate
    private static void nativeDraw(long l, RectF rectF, long l2, long l3, long l4, int n, int n2) {
        NinePatch_Delegate.nativeDraw(l, rectF, l2, l3, l4, n, n2);
    }

    @LayoutlibDelegate
    private static void nativeDraw(long l, Rect rect, long l2, long l3, long l4, int n, int n2) {
        NinePatch_Delegate.nativeDraw(l, rect, l2, l3, l4, n, n2);
    }

    @LayoutlibDelegate
    private static long nativeGetTransparentRegion(long l, long l2, Rect rect) {
        return NinePatch_Delegate.nativeGetTransparentRegion(l, l2, rect);
    }
}

