/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ComposeShader_Delegate;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class ComposeShader
extends Shader {
    private static final int TYPE_XFERMODE = 1;
    private static final int TYPE_PORTERDUFFMODE = 2;
    private int mType;
    private Xfermode mXferMode;
    private PorterDuff.Mode mPorterDuffMode;
    private final Shader mShaderA;
    private final Shader mShaderB;

    public ComposeShader(Shader shaderA, Shader shaderB, Xfermode mode) {
        this.mType = 1;
        this.mShaderA = shaderA;
        this.mShaderB = shaderB;
        this.mXferMode = mode;
        this.native_instance = ComposeShader.nativeCreate1(shaderA.native_instance, shaderB.native_instance, mode != null ? mode.native_instance : 0L);
        if (mode instanceof PorterDuffXfermode) {
            PorterDuff.Mode pdMode = ((PorterDuffXfermode)mode).mode;
            this.native_shader = ComposeShader.nativePostCreate2(this.native_instance, shaderA.native_shader, shaderB.native_shader, pdMode != null ? pdMode.nativeInt : 0);
        } else {
            this.native_shader = ComposeShader.nativePostCreate1(this.native_instance, shaderA.native_shader, shaderB.native_shader, mode != null ? mode.native_instance : 0L);
        }
    }

    public ComposeShader(Shader shaderA, Shader shaderB, PorterDuff.Mode mode) {
        this.mType = 2;
        this.mShaderA = shaderA;
        this.mShaderB = shaderB;
        this.mPorterDuffMode = mode;
        this.native_instance = ComposeShader.nativeCreate2(shaderA.native_instance, shaderB.native_instance, mode.nativeInt);
        this.native_shader = ComposeShader.nativePostCreate2(this.native_instance, shaderA.native_shader, shaderB.native_shader, mode.nativeInt);
    }

    protected Shader copy() {
        ComposeShader copy;
        switch (this.mType) {
            case 1: {
                copy = new ComposeShader(this.mShaderA.copy(), this.mShaderB.copy(), this.mXferMode);
                break;
            }
            case 2: {
                copy = new ComposeShader(this.mShaderA.copy(), this.mShaderB.copy(), this.mPorterDuffMode);
                break;
            }
            default: {
                throw new IllegalArgumentException("ComposeShader should be created with either Xfermode or PorterDuffMode");
            }
        }
        this.copyLocalMatrix(copy);
        return copy;
    }

    @LayoutlibDelegate
    private static long nativeCreate1(long l, long l2, long l3) {
        return ComposeShader_Delegate.nativeCreate1(l, l2, l3);
    }

    @LayoutlibDelegate
    private static long nativeCreate2(long l, long l2, int n) {
        return ComposeShader_Delegate.nativeCreate2(l, l2, n);
    }

    @LayoutlibDelegate
    private static long nativePostCreate1(long l, long l2, long l3, long l4) {
        return ComposeShader_Delegate.nativePostCreate1(l, l2, l3, l4);
    }

    @LayoutlibDelegate
    private static long nativePostCreate2(long l, long l2, long l3, int n) {
        return ComposeShader_Delegate.nativePostCreate2(l, l2, l3, n);
    }
}

