/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Canvas;
import android.graphics.Matrix;
import com.android.tools.layoutlib.create.OverrideMethod;

public class Camera {
    private Matrix mMatrix;
    long native_instance;

    public Camera() {
        this.nativeConstructor();
    }

    public void save() {
        OverrideMethod.invokeV("android.graphics.Camera#save()V", true, this);
    }

    public void restore() {
        OverrideMethod.invokeV("android.graphics.Camera#restore()V", true, this);
    }

    public void translate(float f, float f2, float f3) {
        OverrideMethod.invokeV("android.graphics.Camera#translate(FFF)V", true, this);
    }

    public void rotateX(float f) {
        OverrideMethod.invokeV("android.graphics.Camera#rotateX(F)V", true, this);
    }

    public void rotateY(float f) {
        OverrideMethod.invokeV("android.graphics.Camera#rotateY(F)V", true, this);
    }

    public void rotateZ(float f) {
        OverrideMethod.invokeV("android.graphics.Camera#rotateZ(F)V", true, this);
    }

    public void rotate(float f, float f2, float f3) {
        OverrideMethod.invokeV("android.graphics.Camera#rotate(FFF)V", true, this);
    }

    public float getLocationX() {
        return OverrideMethod.invokeF("android.graphics.Camera#getLocationX()F", true, this);
    }

    public float getLocationY() {
        return OverrideMethod.invokeF("android.graphics.Camera#getLocationY()F", true, this);
    }

    public float getLocationZ() {
        return OverrideMethod.invokeF("android.graphics.Camera#getLocationZ()F", true, this);
    }

    public void setLocation(float f, float f2, float f3) {
        OverrideMethod.invokeV("android.graphics.Camera#setLocation(FFF)V", true, this);
    }

    public void getMatrix(Matrix matrix) {
        this.nativeGetMatrix(matrix.native_instance);
    }

    public void applyToCanvas(Canvas canvas) {
        if (canvas.isHardwareAccelerated()) {
            if (this.mMatrix == null) {
                this.mMatrix = new Matrix();
            }
            this.getMatrix(this.mMatrix);
            canvas.concat(this.mMatrix);
        } else {
            this.nativeApplyToCanvas(canvas.mNativeCanvas);
        }
    }

    public float dotWithNormal(float f, float f2, float f3) {
        return OverrideMethod.invokeF("android.graphics.Camera#dotWithNormal(FFF)F", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.nativeDestructor();
        }
        finally {
            super.finalize();
        }
    }

    private void nativeConstructor() {
        OverrideMethod.invokeV("android.graphics.Camera#nativeConstructor()V", true, this);
    }

    private void nativeDestructor() {
        OverrideMethod.invokeV("android.graphics.Camera#nativeDestructor()V", true, this);
    }

    private void nativeGetMatrix(long l) {
        OverrideMethod.invokeV("android.graphics.Camera#nativeGetMatrix(J)V", true, this);
    }

    private void nativeApplyToCanvas(long l) {
        OverrideMethod.invokeV("android.graphics.Camera#nativeApplyToCanvas(J)V", true, this);
    }
}

