/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Paint_Delegate;
import android.os.Parcel;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.resources.Density;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bitmap_Delegate {
    private static final DelegateManager<Bitmap_Delegate> sManager = new DelegateManager<Bitmap_Delegate>(Bitmap_Delegate.class);
    private final Bitmap.Config mConfig;
    private BufferedImage mImage;
    private boolean mHasAlpha = true;
    private boolean mHasMipMap = false;
    private int mGenerationId = 0;

    public static Bitmap_Delegate getDelegate(Bitmap bitmap) {
        return sManager.getDelegate(bitmap.mNativeBitmap);
    }

    public static Bitmap_Delegate getDelegate(long l) {
        return sManager.getDelegate(l);
    }

    public static Bitmap createBitmap(File file, boolean bl, Density density) throws IOException {
        return Bitmap_Delegate.createBitmap(file, Bitmap_Delegate.getPremultipliedBitmapCreateFlags(bl), density);
    }

    public static Bitmap createBitmap(File file, Set<BitmapCreateFlags> set, Density density) throws IOException {
        Bitmap_Delegate bitmap_Delegate = new Bitmap_Delegate(ImageIO.read(file), Bitmap.Config.ARGB_8888);
        return Bitmap_Delegate.createBitmap(bitmap_Delegate, set, density.getDpiValue());
    }

    public static Bitmap createBitmap(InputStream inputStream, boolean bl, Density density) throws IOException {
        return Bitmap_Delegate.createBitmap(inputStream, Bitmap_Delegate.getPremultipliedBitmapCreateFlags(bl), density);
    }

    public static Bitmap createBitmap(InputStream inputStream, Set<BitmapCreateFlags> set, Density density) throws IOException {
        Bitmap_Delegate bitmap_Delegate = new Bitmap_Delegate(ImageIO.read(inputStream), Bitmap.Config.ARGB_8888);
        return Bitmap_Delegate.createBitmap(bitmap_Delegate, set, density.getDpiValue());
    }

    public static Bitmap createBitmap(BufferedImage bufferedImage, boolean bl, Density density) throws IOException {
        return Bitmap_Delegate.createBitmap(bufferedImage, Bitmap_Delegate.getPremultipliedBitmapCreateFlags(bl), density);
    }

    public static Bitmap createBitmap(BufferedImage bufferedImage, Set<BitmapCreateFlags> set, Density density) throws IOException {
        Bitmap_Delegate bitmap_Delegate = new Bitmap_Delegate(bufferedImage, Bitmap.Config.ARGB_8888);
        return Bitmap_Delegate.createBitmap(bitmap_Delegate, set, density.getDpiValue());
    }

    public static BufferedImage getImage(Bitmap bitmap) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(bitmap.mNativeBitmap);
        if (bitmap_Delegate == null) {
            return null;
        }
        return bitmap_Delegate.mImage;
    }

    public static int getBufferedImageType(int n) {
        switch (Bitmap.Config.nativeToConfig(n)) {
            case ALPHA_8: {
                return 2;
            }
            case RGB_565: {
                return 2;
            }
            case ARGB_4444: {
                return 2;
            }
            case ARGB_8888: {
                return 2;
            }
        }
        return 2;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public Bitmap.Config getConfig() {
        return this.mConfig;
    }

    public boolean hasAlpha() {
        return this.mHasAlpha && this.mConfig != Bitmap.Config.RGB_565;
    }

    public boolean hasMipMap() {
        return this.mHasMipMap;
    }

    public void change() {
        ++this.mGenerationId;
    }

    @LayoutlibDelegate
    static Bitmap nativeCreate(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = Bitmap_Delegate.getBufferedImageType(n5);
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n6);
        if (nArray != null) {
            bufferedImage.setRGB(0, 0, n3, n4, nArray, n, n2);
        }
        Bitmap_Delegate bitmap_Delegate = new Bitmap_Delegate(bufferedImage, Bitmap.Config.nativeToConfig(n5));
        return Bitmap_Delegate.createBitmap(bitmap_Delegate, Bitmap_Delegate.getPremultipliedBitmapCreateFlags(bl), Bitmap.getDefaultDensity());
    }

    @LayoutlibDelegate
    static Bitmap nativeCopy(long l, int n, boolean bl) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return null;
        }
        BufferedImage bufferedImage = bitmap_Delegate.getImage();
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = Bitmap_Delegate.getBufferedImageType(n);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, n4);
        int[] nArray = new int[n2 * n3];
        bufferedImage.getRGB(0, 0, n2, n3, nArray, 0, n2);
        bufferedImage2.setRGB(0, 0, n2, n3, nArray, 0, n2);
        Bitmap_Delegate bitmap_Delegate2 = new Bitmap_Delegate(bufferedImage2, Bitmap.Config.nativeToConfig(n));
        return Bitmap_Delegate.createBitmap(bitmap_Delegate2, Bitmap_Delegate.getPremultipliedBitmapCreateFlags(bl), Bitmap.getDefaultDensity());
    }

    @LayoutlibDelegate
    static void nativeDestructor(long l) {
        sManager.removeJavaReferenceFor(l);
    }

    @LayoutlibDelegate
    static boolean nativeRecycle(long l) {
        sManager.removeJavaReferenceFor(l);
        return true;
    }

    @LayoutlibDelegate
    static void nativeReconfigure(long l, int n, int n2, int n3, int n4) {
        Bridge.getLog().error("unsupported", "Bitmap.reconfigure() is not supported", null);
    }

    @LayoutlibDelegate
    static boolean nativeCompress(long l, int n, int n2, OutputStream outputStream, byte[] byArray) {
        Bridge.getLog().error("unsupported", "Bitmap.compress() is not supported", null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static void nativeErase(long l, int n) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return;
        }
        BufferedImage bufferedImage = bitmap_Delegate.mImage;
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setColor(new Color(n, true));
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        finally {
            graphics2D.dispose();
        }
    }

    @LayoutlibDelegate
    static int nativeRowBytes(long l) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return 0;
        }
        return bitmap_Delegate.mImage.getWidth();
    }

    @LayoutlibDelegate
    static int nativeConfig(long l) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return 0;
        }
        return bitmap_Delegate.mConfig.nativeInt;
    }

    @LayoutlibDelegate
    static boolean nativeHasAlpha(long l) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return true;
        }
        return bitmap_Delegate.mHasAlpha;
    }

    @LayoutlibDelegate
    static boolean nativeHasMipMap(long l) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return true;
        }
        return bitmap_Delegate.mHasMipMap;
    }

    @LayoutlibDelegate
    static int nativeGetPixel(long l, int n, int n2, boolean bl) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return 0;
        }
        return bitmap_Delegate.mImage.getRGB(n, n2);
    }

    @LayoutlibDelegate
    static void nativeGetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return;
        }
        bitmap_Delegate.getImage().getRGB(n3, n4, n5, n6, nArray, n, n2);
    }

    @LayoutlibDelegate
    static void nativeSetPixel(long l, int n, int n2, int n3, boolean bl) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return;
        }
        bitmap_Delegate.getImage().setRGB(n, n2, n3);
    }

    @LayoutlibDelegate
    static void nativeSetPixels(long l, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return;
        }
        bitmap_Delegate.getImage().setRGB(n3, n4, n5, n6, nArray, n, n2);
    }

    @LayoutlibDelegate
    static void nativeCopyPixelsToBuffer(long l, Buffer buffer) {
        Bridge.getLog().fidelityWarning("unsupported", "Bitmap.copyPixelsToBuffer is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void nativeCopyPixelsFromBuffer(long l, Buffer buffer) {
        Bridge.getLog().fidelityWarning("unsupported", "Bitmap.copyPixelsFromBuffer is not supported.", null, null);
    }

    @LayoutlibDelegate
    static int nativeGenerationId(long l) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return 0;
        }
        return bitmap_Delegate.mGenerationId;
    }

    @LayoutlibDelegate
    static Bitmap nativeCreateFromParcel(Parcel parcel) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Bitmaps cannot be created from parcels.", null);
        return null;
    }

    @LayoutlibDelegate
    static boolean nativeWriteToParcel(long l, boolean bl, int n, Parcel parcel) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Bitmaps cannot be written to parcels.", null);
        return false;
    }

    @LayoutlibDelegate
    static Bitmap nativeExtractAlpha(long l, long l2, int[] nArray) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return null;
        }
        Paint_Delegate paint_Delegate = Paint_Delegate.getDelegate(l2);
        if (paint_Delegate != null && paint_Delegate.getMaskFilter() != null) {
            Bridge.getLog().fidelityWarning("maskfilter", "MaskFilter not supported in Bitmap.extractAlpha", null, null);
        }
        int n = paint_Delegate != null ? paint_Delegate.getAlpha() : 255;
        BufferedImage bufferedImage = Bitmap_Delegate.createCopy(bitmap_Delegate.getImage(), 2, n);
        Bitmap_Delegate bitmap_Delegate2 = new Bitmap_Delegate(bufferedImage, Bitmap.Config.ALPHA_8);
        return Bitmap_Delegate.createBitmap(bitmap_Delegate2, EnumSet.of(BitmapCreateFlags.MUTABLE), 160);
    }

    @LayoutlibDelegate
    static void nativePrepareToDraw(long l) {
    }

    @LayoutlibDelegate
    static void nativeSetAlphaAndPremultiplied(long l, boolean bl, boolean bl2) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return;
        }
        bitmap_Delegate.mHasAlpha = bl;
    }

    @LayoutlibDelegate
    static void nativeSetHasMipMap(long l, boolean bl) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return;
        }
        bitmap_Delegate.mHasMipMap = bl;
    }

    @LayoutlibDelegate
    static boolean nativeSameAs(long l, long l2) {
        Bitmap_Delegate bitmap_Delegate = sManager.getDelegate(l);
        if (bitmap_Delegate == null) {
            return false;
        }
        Bitmap_Delegate bitmap_Delegate2 = sManager.getDelegate(l2);
        if (bitmap_Delegate2 == null) {
            return false;
        }
        BufferedImage bufferedImage = bitmap_Delegate.getImage();
        BufferedImage bufferedImage2 = bitmap_Delegate2.getImage();
        if (bitmap_Delegate.mConfig != bitmap_Delegate2.mConfig || bufferedImage.getWidth() != bufferedImage2.getWidth() || bufferedImage.getHeight() != bufferedImage2.getHeight()) {
            return false;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage2.getHeight();
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n * n2];
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        bufferedImage2.getRGB(0, 0, n, n2, nArray2, 0, n);
        if (bitmap_Delegate.mConfig == Bitmap.Config.ALPHA_8) {
            int n3 = n * n2;
            for (int i = 0; i < n3; ++i) {
                if ((nArray[i] & 0xFF000000) == (nArray2[i] & 0xFF000000)) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(nArray, nArray2);
    }

    private Bitmap_Delegate(BufferedImage bufferedImage, Bitmap.Config config) {
        this.mImage = bufferedImage;
        this.mConfig = config;
    }

    private static Bitmap createBitmap(Bitmap_Delegate bitmap_Delegate, Set<BitmapCreateFlags> set, int n) {
        long l = sManager.addNewDelegate(bitmap_Delegate);
        int n2 = bitmap_Delegate.mImage.getWidth();
        int n3 = bitmap_Delegate.mImage.getHeight();
        boolean bl = set.contains((Object)BitmapCreateFlags.MUTABLE);
        boolean bl2 = set.contains((Object)BitmapCreateFlags.PREMULTIPLIED);
        return new Bitmap(l, null, n2, n3, n, bl, bl2, null, null);
    }

    private static Set<BitmapCreateFlags> getPremultipliedBitmapCreateFlags(boolean bl) {
        EnumSet<BitmapCreateFlags> enumSet = EnumSet.of(BitmapCreateFlags.PREMULTIPLIED);
        if (bl) {
            enumSet.add(BitmapCreateFlags.MUTABLE);
        }
        return enumSet;
    }

    static BufferedImage createCopy(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, n);
        int[] nArray = new int[n3 * n4];
        bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        if (n2 != 255) {
            int n5 = nArray.length;
            for (int i = 0; i < n5; ++i) {
                int n6 = (nArray[i] >>> 24 * n2) / 255;
                nArray[i] = n6 << 24 | nArray[i] & 0xFFFFFF;
            }
        }
        bufferedImage2.setRGB(0, 0, n3, n4, nArray, 0, n3);
        return bufferedImage2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BitmapCreateFlags {
        PREMULTIPLIED,
        MUTABLE;

    }
}

