/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.BridgeResources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Bitmap_Delegate;
import android.graphics.NinePatch_Delegate;
import android.graphics.Rect;
import com.android.layoutlib.bridge.Bridge;
import com.android.ninepatch.NinePatch;
import com.android.ninepatch.NinePatchChunk;
import com.android.resources.Density;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;

class BitmapFactory_Delegate {
    BitmapFactory_Delegate() {
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeStream(InputStream inputStream, byte[] byArray, Rect rect, BitmapFactory.Options options) {
        Bitmap bitmap = null;
        Density density = Density.MEDIUM;
        EnumSet<Bitmap_Delegate.BitmapCreateFlags> enumSet = EnumSet.of(Bitmap_Delegate.BitmapCreateFlags.MUTABLE);
        if (options != null) {
            density = Density.getEnum((int)options.inDensity);
            if (options.inPremultiplied) {
                enumSet.add(Bitmap_Delegate.BitmapCreateFlags.PREMULTIPLIED);
            }
        }
        try {
            if (inputStream instanceof BridgeResources.NinePatchInputStream) {
                BridgeResources.NinePatchInputStream ninePatchInputStream = (BridgeResources.NinePatchInputStream)inputStream;
                ninePatchInputStream.disableFakeMarkSupport();
                NinePatch ninePatch = NinePatch.load(ninePatchInputStream, true, false);
                bitmap = Bitmap_Delegate.createBitmap(ninePatch.getImage(), enumSet, density);
                NinePatchChunk ninePatchChunk = ninePatch.getChunk();
                bitmap.setNinePatchChunk(NinePatch_Delegate.serialize(ninePatchChunk));
                int[] nArray = ninePatchChunk.getPadding();
                rect.left = nArray[0];
                rect.top = nArray[1];
                rect.right = nArray[2];
                rect.bottom = nArray[3];
            } else {
                bitmap = Bitmap_Delegate.createBitmap(inputStream, enumSet, density);
            }
        }
        catch (IOException iOException) {
            Bridge.getLog().error(null, "Failed to load image", (Throwable)iOException, null);
        }
        return bitmap;
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeFileDescriptor(FileDescriptor fileDescriptor, Rect rect, BitmapFactory.Options options) {
        options.inBitmap = null;
        return null;
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeAsset(long l, Rect rect, BitmapFactory.Options options) {
        options.inBitmap = null;
        return null;
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeByteArray(byte[] byArray, int n, int n2, BitmapFactory.Options options) {
        options.inBitmap = null;
        return null;
    }

    @LayoutlibDelegate
    static boolean nativeIsSeekable(FileDescriptor fileDescriptor) {
        return true;
    }
}

