/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Paint_Delegate;
import android.graphics.RectF;
import com.ibm.icu.lang.UScriptRun;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidiRenderer {
    private Graphics2D mGraphics;
    private Paint_Delegate mPaint;
    private char[] mText;
    private RectF mBounds;
    private float mBaseline;

    BidiRenderer(Graphics2D graphics2D, Paint_Delegate paint_Delegate, char[] cArray) {
        assert (paint_Delegate != null);
        this.mGraphics = graphics2D;
        this.mPaint = paint_Delegate;
        this.mText = cArray;
    }

    RectF renderText(int n, int n2, boolean bl, float[] fArray, int n3, boolean bl2, float f, float f2) {
        this.mBounds = new RectF(f, f2, f, f2);
        this.mBaseline = f2;
        for (ScriptRun scriptRun : BidiRenderer.getScriptRuns(this.mText, n, n2, bl, this.mPaint.getFonts())) {
            int n4 = 6;
            this.renderScript(scriptRun.start, scriptRun.limit, scriptRun.font, n4 |= bl ? 1 : 0, fArray, n3, bl2);
            n3 += scriptRun.limit - scriptRun.start;
        }
        return this.mBounds;
    }

    private void renderScript(int n, int n2, Paint_Delegate.FontInfo fontInfo, int n3, float[] fArray, int n4, boolean bl) {
        List<Paint_Delegate.FontInfo> list = this.mPaint.getFonts();
        if (list == null || fontInfo == null) {
            return;
        }
        while (n < n2) {
            boolean bl2 = false;
            int n5 = fontInfo.mFont.canDisplayUpTo(this.mText, n, n2);
            if (n5 == -1) {
                this.render(n, n2, fontInfo, n3, fArray, n4, bl);
                return;
            }
            if (n5 > n) {
                this.render(n, n5, fontInfo, n3, fArray, n4, bl);
                n4 += n5 - n;
                n = n5;
            }
            int n6 = Character.isHighSurrogate(this.mText[n]) ? 2 : 1;
            for (Paint_Delegate.FontInfo fontInfo2 : list) {
                n5 = fontInfo2.mFont.canDisplayUpTo(this.mText, n, n + n6);
                if (n5 != -1) continue;
                this.render(n, n + n6, fontInfo2, n3, fArray, n4, bl);
                n += n6;
                n4 += n6;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            this.render(n, n + n6, fontInfo, n3, fArray, n4, bl);
            n += n6;
            n4 += n6;
        }
    }

    private void render(int n, int n2, Paint_Delegate.FontInfo fontInfo, int n3, float[] fArray, int n4, boolean bl) {
        FontRenderContext fontRenderContext = fontInfo.mMetrics.getFontRenderContext();
        FontRenderContext fontRenderContext2 = new FontRenderContext(fontRenderContext.getTransform(), this.mPaint.isAntiAliased(), fontRenderContext.usesFractionalMetrics());
        GlyphVector glyphVector = fontInfo.mFont.layoutGlyphVector(fontRenderContext2, this.mText, n, n2, n3);
        int n5 = glyphVector.getNumGlyphs();
        int[] nArray = glyphVector.getGlyphCharIndices(0, n5, null);
        if (fArray != null) {
            for (int i = 0; i < n5; ++i) {
                int n6;
                int n7 = n6 = n4 + nArray[i];
                fArray[n7] = fArray[n7] + glyphVector.getGlyphMetrics(i).getAdvanceX();
            }
        }
        if (bl && this.mGraphics != null) {
            this.mGraphics.drawGlyphVector(glyphVector, this.mBounds.right, this.mBaseline);
        }
        Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
        RectF rectF = BidiRenderer.awtRectToAndroidRect(rectangle2D, this.mBounds.right, this.mBaseline);
        if (Math.abs(this.mBounds.right - this.mBounds.left) == 0.0f) {
            this.mBounds = rectF;
        } else {
            this.mBounds.union(rectF);
        }
    }

    private static RectF awtRectToAndroidRect(Rectangle2D rectangle2D, float f, float f2) {
        float f3 = (float)rectangle2D.getX();
        float f4 = (float)rectangle2D.getY();
        float f5 = (float)((double)f3 + rectangle2D.getWidth());
        float f6 = (float)((double)f4 + rectangle2D.getHeight());
        RectF rectF = new RectF(f3, f4, f5, f6);
        rectF.offset(f, f2);
        return rectF;
    }

    static List<ScriptRun> getScriptRuns(char[] cArray, int n, int n2, boolean bl, List<Paint_Delegate.FontInfo> list) {
        LinkedList<ScriptRun> linkedList = new LinkedList<ScriptRun>();
        int n3 = n2 - n;
        UScriptRun uScriptRun = new UScriptRun(cArray, n, n3);
        while (uScriptRun.next()) {
            int n4 = uScriptRun.getScriptStart();
            int n5 = uScriptRun.getScriptLimit();
            ScriptRun scriptRun = new ScriptRun(n4, n5, bl);
            scriptRun.scriptCode = uScriptRun.getScriptCode();
            BidiRenderer.setScriptFont(cArray, scriptRun, list);
            linkedList.add(scriptRun);
        }
        return linkedList;
    }

    private static void setScriptFont(char[] cArray, ScriptRun scriptRun, List<Paint_Delegate.FontInfo> list) {
        for (Paint_Delegate.FontInfo fontInfo : list) {
            if (fontInfo.mFont.canDisplayUpTo(cArray, scriptRun.start, scriptRun.limit) != -1) continue;
            scriptRun.font = fontInfo;
            return;
        }
        scriptRun.font = list.get(0);
    }

    static class ScriptRun {
        int start;
        int limit;
        boolean isRtl;
        int scriptCode;
        Paint_Delegate.FontInfo font;

        public ScriptRun(int n, int n2, boolean bl) {
            this.start = n;
            this.limit = n2;
            this.isRtl = bl;
            this.scriptCode = -1;
        }
    }
}

