/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import com.android.resources.ResourceType;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources_Theme_Delegate {
    int mThemeResId;
    boolean force;
    private static final DelegateManager<Resources_Theme_Delegate> sManager = new DelegateManager<Resources_Theme_Delegate>(Resources_Theme_Delegate.class);

    public static DelegateManager<Resources_Theme_Delegate> getDelegateManager() {
        return sManager;
    }

    @LayoutlibDelegate
    static TypedArray obtainStyledAttributes(Resources resources, Resources.Theme theme, int[] nArray) {
        boolean bl = Resources_Theme_Delegate.setupResources(theme);
        TypedArray typedArray = RenderSessionImpl.getCurrentContext().obtainStyledAttributes(nArray);
        Resources_Theme_Delegate.restoreResources(bl);
        return typedArray;
    }

    @LayoutlibDelegate
    static TypedArray obtainStyledAttributes(Resources resources, Resources.Theme theme, int n, int[] nArray) throws Resources.NotFoundException {
        boolean bl = Resources_Theme_Delegate.setupResources(theme);
        TypedArray typedArray = RenderSessionImpl.getCurrentContext().obtainStyledAttributes(n, nArray);
        Resources_Theme_Delegate.restoreResources(bl);
        return typedArray;
    }

    @LayoutlibDelegate
    static TypedArray obtainStyledAttributes(Resources resources, Resources.Theme theme, AttributeSet attributeSet, int[] nArray, int n, int n2) {
        boolean bl = Resources_Theme_Delegate.setupResources(theme);
        TypedArray typedArray = RenderSessionImpl.getCurrentContext().obtainStyledAttributes(attributeSet, nArray, n, n2);
        Resources_Theme_Delegate.restoreResources(bl);
        return typedArray;
    }

    @LayoutlibDelegate
    static boolean resolveAttribute(Resources resources, Resources.Theme theme, int n, TypedValue typedValue, boolean bl) {
        boolean bl2 = Resources_Theme_Delegate.setupResources(theme);
        boolean bl3 = RenderSessionImpl.getCurrentContext().resolveThemeAttribute(n, typedValue, bl);
        Resources_Theme_Delegate.restoreResources(bl2);
        return bl3;
    }

    private static boolean setupResources(Resources.Theme theme) {
        Resources_Theme_Delegate resources_Theme_Delegate = sManager.getDelegate(theme.getNativeTheme());
        StyleResourceValue styleResourceValue = Resources_Theme_Delegate.resolveStyle(resources_Theme_Delegate.mThemeResId);
        if (styleResourceValue != null) {
            RenderSessionImpl.getCurrentContext().getRenderResources().applyStyle(styleResourceValue, resources_Theme_Delegate.force);
            return true;
        }
        return false;
    }

    private static void restoreResources(boolean bl) {
        if (bl) {
            RenderSessionImpl.getCurrentContext().getRenderResources().clearStyles();
        }
    }

    @Nullable
    private static StyleResourceValue resolveStyle(int n) {
        if (n == 0) {
            return null;
        }
        BridgeContext bridgeContext = RenderSessionImpl.getCurrentContext();
        ResourceReference resourceReference = bridgeContext.resolveId(n);
        if (resourceReference.isFramework()) {
            return (StyleResourceValue)bridgeContext.getRenderResources().getFrameworkResource(ResourceType.STYLE, resourceReference.getName());
        }
        return (StyleResourceValue)bridgeContext.getRenderResources().getProjectResource(ResourceType.STYLE, resourceReference.getName());
    }
}

