/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Configuration;
import android.os.IBinder;

public class ResourcesKey {
    final String mResDir;
    final float mScale;
    private final int mHash;
    private final IBinder mToken;
    public final int mDisplayId;
    public final Configuration mOverrideConfiguration = new Configuration();

    public ResourcesKey(String resDir, int displayId, Configuration overrideConfiguration, float scale, IBinder token) {
        this.mResDir = resDir;
        this.mDisplayId = displayId;
        if (overrideConfiguration != null) {
            this.mOverrideConfiguration.setTo(overrideConfiguration);
        }
        this.mScale = scale;
        this.mToken = token;
        int hash = 17;
        hash = 31 * hash + (this.mResDir == null ? 0 : this.mResDir.hashCode());
        hash = 31 * hash + this.mDisplayId;
        hash = 31 * hash + (this.mOverrideConfiguration != null ? this.mOverrideConfiguration.hashCode() : 0);
        this.mHash = hash = 31 * hash + Float.floatToIntBits(this.mScale);
    }

    public boolean hasOverrideConfiguration() {
        return !Configuration.EMPTY.equals(this.mOverrideConfiguration);
    }

    public int hashCode() {
        return this.mHash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourcesKey)) {
            return false;
        }
        ResourcesKey peer = (ResourcesKey)obj;
        if (!this.mResDir.equals(peer.mResDir)) {
            return false;
        }
        if (this.mDisplayId != peer.mDisplayId) {
            return false;
        }
        if (this.mOverrideConfiguration != peer.mOverrideConfiguration) {
            if (this.mOverrideConfiguration == null || peer.mOverrideConfiguration == null) {
                return false;
            }
            if (!this.mOverrideConfiguration.equals(peer.mOverrideConfiguration)) {
                return false;
            }
        }
        return this.mScale == peer.mScale;
    }

    public String toString() {
        return Integer.toHexString(this.mHash);
    }
}

