/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Slog;
import com.android.tools.layoutlib.java.AutoCloseable;
import com.android.tools.layoutlib.java.IntegralToString;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import libcore.io.IoUtils;

public class ManifestDigest
implements Parcelable {
    private static final String TAG = "ManifestDigest";
    private final byte[] mDigest;
    private static final String TO_STRING_PREFIX = "ManifestDigest {mDigest=";
    private static final String DIGEST_ALGORITHM = "SHA-256";
    public static final Parcelable.Creator<ManifestDigest> CREATOR = new Parcelable.Creator<ManifestDigest>(){

        @Override
        public ManifestDigest createFromParcel(Parcel source) {
            return new ManifestDigest(source);
        }

        public ManifestDigest[] newArray(int size) {
            return new ManifestDigest[size];
        }
    };

    ManifestDigest(byte[] digest) {
        this.mDigest = digest;
    }

    private ManifestDigest(Parcel source) {
        this.mDigest = source.createByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ManifestDigest fromInputStream(InputStream fileIs) {
        MessageDigest md;
        if (fileIs == null) {
            return null;
        }
        try {
            md = MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 must be available", e);
        }
        DigestInputStream dis = new DigestInputStream(new BufferedInputStream(fileIs), md);
        try {
            byte[] readBuffer = new byte[8192];
            while (dis.read(readBuffer, 0, readBuffer.length) != -1) {
            }
        }
        catch (IOException e) {
            Slog.w(TAG, "Could not read manifest");
            ManifestDigest manifestDigest = null;
            return manifestDigest;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)((Object)dis));
        }
        byte[] digest = md.digest();
        return new ManifestDigest(digest);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestDigest)) {
            return false;
        }
        ManifestDigest other = (ManifestDigest)o;
        return this == other || Arrays.equals(this.mDigest, other.mDigest);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mDigest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(TO_STRING_PREFIX.length() + this.mDigest.length * 3 + 1);
        sb.append(TO_STRING_PREFIX);
        for (byte b : this.mDigest) {
            IntegralToString.appendByteAsHex(sb, b, false);
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mDigest);
    }
}

