/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.AppOpsManager;
import android.content.ClipDescription;
import android.content.ComponentCallbacks2;
import android.content.ContentProviderNative;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.pm.PathPermission;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ICancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.UserHandle;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentProvider
implements ComponentCallbacks2 {
    private static final String TAG = "ContentProvider";
    private Context mContext = null;
    private int mMyUid;
    private String mReadPermission;
    private String mWritePermission;
    private PathPermission[] mPathPermissions;
    private boolean mExported;
    private boolean mNoPerms;
    private final ThreadLocal<String> mCallingPackage = new ThreadLocal();
    private Transport mTransport = new Transport();

    public ContentProvider() {
    }

    public ContentProvider(Context context, String readPermission, String writePermission, PathPermission[] pathPermissions) {
        this.mContext = context;
        this.mReadPermission = readPermission;
        this.mWritePermission = writePermission;
        this.mPathPermissions = pathPermissions;
    }

    public static ContentProvider coerceToLocalContentProvider(IContentProvider abstractInterface) {
        if (abstractInterface instanceof Transport) {
            return ((Transport)abstractInterface).getContentProvider();
        }
        return null;
    }

    protected void enforceReadPermissionInner(Uri uri) throws SecurityException {
        Context context = this.getContext();
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        String missingPerm = null;
        if (UserHandle.isSameApp(uid, this.mMyUid)) {
            return;
        }
        if (this.mExported) {
            String componentPerm = this.getReadPermission();
            if (componentPerm != null) {
                if (context.checkPermission(componentPerm, pid, uid) == 0) {
                    return;
                }
                missingPerm = componentPerm;
            }
            boolean allowDefaultRead = componentPerm == null;
            PathPermission[] pps = this.getPathPermissions();
            if (pps != null) {
                String path = uri.getPath();
                for (PathPermission pp : pps) {
                    String pathPerm = pp.getReadPermission();
                    if (pathPerm == null || !pp.match(path)) continue;
                    if (context.checkPermission(pathPerm, pid, uid) == 0) {
                        return;
                    }
                    allowDefaultRead = false;
                    missingPerm = pathPerm;
                }
            }
            if (allowDefaultRead) {
                return;
            }
        }
        if (context.checkUriPermission(uri, pid, uid, 1) == 0) {
            return;
        }
        String failReason = this.mExported ? " requires " + missingPerm + ", or grantUriPermission()" : " requires the provider be exported, or grantUriPermission()";
        throw new SecurityException("Permission Denial: reading " + this.getClass().getName() + " uri " + uri + " from pid=" + pid + ", uid=" + uid + failReason);
    }

    protected void enforceWritePermissionInner(Uri uri) throws SecurityException {
        Context context = this.getContext();
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        String missingPerm = null;
        if (UserHandle.isSameApp(uid, this.mMyUid)) {
            return;
        }
        if (this.mExported) {
            String componentPerm = this.getWritePermission();
            if (componentPerm != null) {
                if (context.checkPermission(componentPerm, pid, uid) == 0) {
                    return;
                }
                missingPerm = componentPerm;
            }
            boolean allowDefaultWrite = componentPerm == null;
            PathPermission[] pps = this.getPathPermissions();
            if (pps != null) {
                String path = uri.getPath();
                for (PathPermission pp : pps) {
                    String pathPerm = pp.getWritePermission();
                    if (pathPerm == null || !pp.match(path)) continue;
                    if (context.checkPermission(pathPerm, pid, uid) == 0) {
                        return;
                    }
                    allowDefaultWrite = false;
                    missingPerm = pathPerm;
                }
            }
            if (allowDefaultWrite) {
                return;
            }
        }
        if (context.checkUriPermission(uri, pid, uid, 2) == 0) {
            return;
        }
        String failReason = this.mExported ? " requires " + missingPerm + ", or grantUriPermission()" : " requires the provider be exported, or grantUriPermission()";
        throw new SecurityException("Permission Denial: writing " + this.getClass().getName() + " uri " + uri + " from pid=" + pid + ", uid=" + uid + failReason);
    }

    public Context getContext() {
        return this.mContext;
    }

    private String setCallingPackage(String callingPackage) {
        String original = this.mCallingPackage.get();
        this.mCallingPackage.set(callingPackage);
        return original;
    }

    public String getCallingPackage() {
        String pkg = this.mCallingPackage.get();
        if (pkg != null) {
            this.mTransport.mAppOpsManager.checkPackage(Binder.getCallingUid(), pkg);
        }
        return pkg;
    }

    protected void setReadPermission(String permission2) {
        this.mReadPermission = permission2;
    }

    public String getReadPermission() {
        return this.mReadPermission;
    }

    protected void setWritePermission(String permission2) {
        this.mWritePermission = permission2;
    }

    public String getWritePermission() {
        return this.mWritePermission;
    }

    protected void setPathPermissions(PathPermission[] permissions) {
        this.mPathPermissions = permissions;
    }

    public PathPermission[] getPathPermissions() {
        return this.mPathPermissions;
    }

    public void setAppOps(int readOp, int writeOp) {
        if (!this.mNoPerms) {
            this.mTransport.mReadOp = readOp;
            this.mTransport.mWriteOp = writeOp;
        }
    }

    public AppOpsManager getAppOpsManager() {
        return this.mTransport.mAppOpsManager;
    }

    public abstract boolean onCreate();

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
    }

    @Override
    public void onLowMemory() {
    }

    @Override
    public void onTrimMemory(int level) {
    }

    public Cursor rejectQuery(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        selection = selection == null || selection.isEmpty() ? "'A' = 'B'" : "'A' = 'B' AND (" + selection + ")";
        return this.query(uri, projection, selection, selectionArgs, sortOrder, cancellationSignal);
    }

    public abstract Cursor query(Uri var1, String[] var2, String var3, String[] var4, String var5);

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        return this.query(uri, projection, selection, selectionArgs, sortOrder);
    }

    public abstract String getType(Uri var1);

    public Uri canonicalize(Uri url) {
        return null;
    }

    public Uri uncanonicalize(Uri url) {
        return url;
    }

    public Uri rejectInsert(Uri uri, ContentValues values) {
        return uri.buildUpon().appendPath("0").build();
    }

    public abstract Uri insert(Uri var1, ContentValues var2);

    public int bulkInsert(Uri uri, ContentValues[] values) {
        int numValues = values.length;
        for (int i = 0; i < numValues; ++i) {
            this.insert(uri, values[i]);
        }
        return numValues;
    }

    public abstract int delete(Uri var1, String var2, String[] var3);

    public abstract int update(Uri var1, ContentValues var2, String var3, String[] var4);

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        throw new FileNotFoundException("No files supported by provider at " + uri);
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        return this.openFile(uri, mode);
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        ParcelFileDescriptor fd = this.openFile(uri, mode);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        return this.openAssetFile(uri, mode);
    }

    protected ParcelFileDescriptor openFileHelper(Uri uri, String mode) throws FileNotFoundException {
        int count;
        Cursor c = this.query(uri, new String[]{"_data"}, null, null, null);
        int n = count = c != null ? c.getCount() : 0;
        if (count != 1) {
            if (c != null) {
                c.close();
            }
            if (count == 0) {
                throw new FileNotFoundException("No entry for " + uri);
            }
            throw new FileNotFoundException("Multiple items at " + uri);
        }
        c.moveToFirst();
        int i = c.getColumnIndex("_data");
        String path = i >= 0 ? c.getString(i) : null;
        c.close();
        if (path == null) {
            throw new FileNotFoundException("Column _data not found.");
        }
        int modeBits = ParcelFileDescriptor.parseMode(mode);
        return ParcelFileDescriptor.open(new File(path), modeBits);
    }

    public String[] getStreamTypes(Uri uri, String mimeTypeFilter) {
        return null;
    }

    public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        if ("*/*".equals(mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        String baseType = this.getType(uri);
        if (baseType != null && ClipDescription.compareMimeTypes(baseType, mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        throw new FileNotFoundException("Can't open " + uri + " as type " + mimeTypeFilter);
    }

    public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        return this.openTypedAssetFile(uri, mimeTypeFilter, opts);
    }

    public <T> ParcelFileDescriptor openPipeHelper(final Uri uri, final String mimeType, final Bundle opts, final T args, final PipeDataWriter<T> func) throws FileNotFoundException {
        try {
            final ParcelFileDescriptor[] fds = ParcelFileDescriptor.createPipe();
            AsyncTask<Object, Object, Object> task = new AsyncTask<Object, Object, Object>(){

                @Override
                protected Object doInBackground(Object ... params) {
                    func.writeDataToPipe(fds[1], uri, mimeType, opts, args);
                    try {
                        fds[1].close();
                    }
                    catch (IOException e) {
                        Log.w(ContentProvider.TAG, "Failure closing pipe", e);
                    }
                    return null;
                }
            };
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
            return fds[0];
        }
        catch (IOException e) {
            throw new FileNotFoundException("failure making pipe");
        }
    }

    protected boolean isTemporary() {
        return false;
    }

    public IContentProvider getIContentProvider() {
        return this.mTransport;
    }

    public void attachInfoForTesting(Context context, ProviderInfo info) {
        this.attachInfo(context, info, true);
    }

    public void attachInfo(Context context, ProviderInfo info) {
        this.attachInfo(context, info, false);
    }

    private void attachInfo(Context context, ProviderInfo info, boolean testing) {
        AsyncTask.init();
        this.mNoPerms = testing;
        if (this.mContext == null) {
            this.mContext = context;
            if (context != null) {
                this.mTransport.mAppOpsManager = (AppOpsManager)context.getSystemService("appops");
            }
            this.mMyUid = Process.myUid();
            if (info != null) {
                this.setReadPermission(info.readPermission);
                this.setWritePermission(info.writePermission);
                this.setPathPermissions(info.pathPermissions);
                this.mExported = info.exported;
            }
            this.onCreate();
        }
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        int numOperations = operations.size();
        ContentProviderResult[] results = new ContentProviderResult[numOperations];
        for (int i = 0; i < numOperations; ++i) {
            results[i] = operations.get(i).apply(this, results, i);
        }
        return results;
    }

    public Bundle call(String method, String arg, Bundle extras) {
        return null;
    }

    public void shutdown() {
        Log.w(TAG, "implement ContentProvider shutdown() to make sure all database connections are gracefully shutdown");
    }

    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.println("nothing to dump");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PipeDataWriter<T> {
        public void writeDataToPipe(ParcelFileDescriptor var1, Uri var2, String var3, Bundle var4, T var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Transport
    extends ContentProviderNative {
        AppOpsManager mAppOpsManager = null;
        int mReadOp = -1;
        int mWriteOp = -1;

        Transport() {
        }

        ContentProvider getContentProvider() {
            return ContentProvider.this;
        }

        @Override
        public String getProviderName() {
            return this.getContentProvider().getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cursor query(String callingPkg, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, ICancellationSignal cancellationSignal) {
            if (this.enforceReadPermission(callingPkg, uri) != 0) {
                return ContentProvider.this.rejectQuery(uri, projection, selection, selectionArgs, sortOrder, CancellationSignal.fromTransport(cancellationSignal));
            }
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                Cursor cursor = ContentProvider.this.query(uri, projection, selection, selectionArgs, sortOrder, CancellationSignal.fromTransport(cancellationSignal));
                return cursor;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        @Override
        public String getType(Uri uri) {
            return ContentProvider.this.getType(uri);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Uri insert(String callingPkg, Uri uri, ContentValues initialValues) {
            if (this.enforceWritePermission(callingPkg, uri) != 0) {
                return ContentProvider.this.rejectInsert(uri, initialValues);
            }
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                Uri uri2 = ContentProvider.this.insert(uri, initialValues);
                return uri2;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int bulkInsert(String callingPkg, Uri uri, ContentValues[] initialValues) {
            if (this.enforceWritePermission(callingPkg, uri) != 0) {
                return 0;
            }
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                int n = ContentProvider.this.bulkInsert(uri, initialValues);
                return n;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ContentProviderResult[] applyBatch(String callingPkg, ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
            for (ContentProviderOperation operation : operations) {
                if (operation.isReadOperation() && this.enforceReadPermission(callingPkg, operation.getUri()) != 0) {
                    throw new OperationApplicationException("App op not allowed", 0);
                }
                if (!operation.isWriteOperation() || this.enforceWritePermission(callingPkg, operation.getUri()) == 0) continue;
                throw new OperationApplicationException("App op not allowed", 0);
            }
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                ContentProviderResult[] contentProviderResultArray = ContentProvider.this.applyBatch(operations);
                return contentProviderResultArray;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int delete(String callingPkg, Uri uri, String selection, String[] selectionArgs) {
            if (this.enforceWritePermission(callingPkg, uri) != 0) {
                return 0;
            }
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                int n = ContentProvider.this.delete(uri, selection, selectionArgs);
                return n;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int update(String callingPkg, Uri uri, ContentValues values, String selection, String[] selectionArgs) {
            if (this.enforceWritePermission(callingPkg, uri) != 0) {
                return 0;
            }
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                int n = ContentProvider.this.update(uri, values, selection, selectionArgs);
                return n;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParcelFileDescriptor openFile(String callingPkg, Uri uri, String mode, ICancellationSignal cancellationSignal) throws FileNotFoundException {
            this.enforceFilePermission(callingPkg, uri, mode);
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                ParcelFileDescriptor parcelFileDescriptor = ContentProvider.this.openFile(uri, mode, CancellationSignal.fromTransport(cancellationSignal));
                return parcelFileDescriptor;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AssetFileDescriptor openAssetFile(String callingPkg, Uri uri, String mode, ICancellationSignal cancellationSignal) throws FileNotFoundException {
            this.enforceFilePermission(callingPkg, uri, mode);
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                AssetFileDescriptor assetFileDescriptor = ContentProvider.this.openAssetFile(uri, mode, CancellationSignal.fromTransport(cancellationSignal));
                return assetFileDescriptor;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bundle call(String callingPkg, String method, String arg, Bundle extras) {
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                Bundle bundle = ContentProvider.this.call(method, arg, extras);
                return bundle;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        @Override
        public String[] getStreamTypes(Uri uri, String mimeTypeFilter) {
            return ContentProvider.this.getStreamTypes(uri, mimeTypeFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AssetFileDescriptor openTypedAssetFile(String callingPkg, Uri uri, String mimeType, Bundle opts, ICancellationSignal cancellationSignal) throws FileNotFoundException {
            this.enforceFilePermission(callingPkg, uri, "r");
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                AssetFileDescriptor assetFileDescriptor = ContentProvider.this.openTypedAssetFile(uri, mimeType, opts, CancellationSignal.fromTransport(cancellationSignal));
                return assetFileDescriptor;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        @Override
        public ICancellationSignal createCancellationSignal() {
            return CancellationSignal.createTransport();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Uri canonicalize(String callingPkg, Uri uri) {
            if (this.enforceReadPermission(callingPkg, uri) != 0) {
                return null;
            }
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                Uri uri2 = ContentProvider.this.canonicalize(uri);
                return uri2;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Uri uncanonicalize(String callingPkg, Uri uri) {
            if (this.enforceReadPermission(callingPkg, uri) != 0) {
                return null;
            }
            String original = ContentProvider.this.setCallingPackage(callingPkg);
            try {
                Uri uri2 = ContentProvider.this.uncanonicalize(uri);
                return uri2;
            }
            finally {
                ContentProvider.this.setCallingPackage(original);
            }
        }

        private void enforceFilePermission(String callingPkg, Uri uri, String mode) throws FileNotFoundException, SecurityException {
            if (mode != null && mode.indexOf(119) != -1 ? this.enforceWritePermission(callingPkg, uri) != 0 : this.enforceReadPermission(callingPkg, uri) != 0) {
                throw new FileNotFoundException("App op not allowed");
            }
        }

        private int enforceReadPermission(String callingPkg, Uri uri) throws SecurityException {
            ContentProvider.this.enforceReadPermissionInner(uri);
            if (this.mReadOp != -1) {
                return this.mAppOpsManager.noteOp(this.mReadOp, Binder.getCallingUid(), callingPkg);
            }
            return 0;
        }

        private int enforceWritePermission(String callingPkg, Uri uri) throws SecurityException {
            ContentProvider.this.enforceWritePermissionInner(uri);
            if (this.mWriteOp != -1) {
                return this.mAppOpsManager.noteOp(this.mWriteOp, Binder.getCallingUid(), callingPkg);
            }
            return 0;
        }
    }
}

