/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.IBluetoothGatt;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothAdvScanData {
    public static final int AD = 0;
    public static final int SCAN_RESPONSE = 1;
    public static final int EIR = 2;
    private static final String TAG = "BluetoothAdvScanData";
    private final int mDataType;
    private IBluetoothGatt mBluetoothGatt;

    public BluetoothAdvScanData(IBluetoothGatt mBluetoothGatt, int dataType) {
        this.mBluetoothGatt = mBluetoothGatt;
        this.mDataType = dataType;
    }

    public int getDataType() {
        return this.mDataType;
    }

    public boolean setManufacturerData(int manufacturerCode, byte[] manufacturerData) {
        if (this.mDataType != 0) {
            return false;
        }
        try {
            return this.mBluetoothGatt.setAdvManufacturerCodeAndData(manufacturerCode, manufacturerData);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to set manufacturer id and data.", e);
            return false;
        }
    }

    public boolean setServiceData(byte[] serviceData) {
        if (this.mDataType != 0) {
            return false;
        }
        if (serviceData == null) {
            return false;
        }
        try {
            return this.mBluetoothGatt.setAdvServiceData(serviceData);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to set service data.", e);
            return false;
        }
    }

    public List<ParcelUuid> getServiceUuids() {
        try {
            return Collections.unmodifiableList(this.mBluetoothGatt.getAdvServiceUuids());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to get service uuids.", e);
            return null;
        }
    }

    public byte[] getManufacturerData() {
        if (this.mBluetoothGatt == null) {
            return null;
        }
        try {
            return this.mBluetoothGatt.getAdvManufacturerData();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to get manufacturer data.", e);
            return null;
        }
    }

    public byte[] getServiceData() {
        if (this.mBluetoothGatt == null) {
            return null;
        }
        try {
            return this.mBluetoothGatt.getAdvServiceData();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to get service data.", e);
            return null;
        }
    }

    public void removeManufacturerCodeAndData(int manufacturerCode) {
        if (this.mBluetoothGatt != null) {
            try {
                this.mBluetoothGatt.removeAdvManufacturerCodeAndData(manufacturerCode);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to remove manufacturer : " + manufacturerCode, e);
            }
        }
    }
}

