/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdvScanData;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHealth;
import android.bluetooth.BluetoothInputDevice;
import android.bluetooth.BluetoothMap;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattCallback;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Pair;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothAdapter {
    private static final String TAG = "BluetoothAdapter";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final int STATE_OFF = 10;
    public static final int STATE_TURNING_ON = 11;
    public static final int STATE_ON = 12;
    public static final int STATE_TURNING_OFF = 13;
    public static final String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static final String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    public static final String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    public static final String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static final String ACTION_BLUETOOTH_ADVERTISING_STARTED = "android.bluetooth.adapter.action.ADVERTISING_STARTED";
    public static final String ACTION_BLUETOOTH_ADVERTISING_STOPPED = "android.bluetooth.adapter.action.ADVERTISING_STOPPED";
    public static final String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static final String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static final int SCAN_MODE_NONE = 20;
    public static final int SCAN_MODE_CONNECTABLE = 21;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    public static final String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    public static final String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    public static final String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";
    public static final String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    public static final int STATE_ADVERTISE_STARTING = 0;
    public static final int STATE_ADVERTISE_STARTED = 1;
    public static final int STATE_ADVERTISE_STOPPING = 2;
    public static final int STATE_ADVERTISE_STOPPED = 3;
    public static final int STATE_ADVERTISE_FORCE_STOPPING = 4;
    public static final String BLUETOOTH_MANAGER_SERVICE = "bluetooth_manager";
    public static final int ADVERTISE_CALLBACK_SUCCESS = 0;
    private static final int ADDRESS_LENGTH = 17;
    private static BluetoothAdapter sAdapter;
    private final IBluetoothManager mManagerService;
    private IBluetooth mService;
    private final Map<LeScanCallback, GattCallbackWrapper> mLeScanClients;
    private BluetoothAdvScanData mBluetoothAdvScanData = null;
    private GattCallbackWrapper mAdvertisingGattCallback;
    private final Handler mHandler;
    private final Object mLock = new Object();
    private final IBluetoothManagerCallback mManagerCallback = new IBluetoothManagerCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBluetoothServiceUp(IBluetooth bluetoothService) {
            IBluetoothManagerCallback iBluetoothManagerCallback = BluetoothAdapter.this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                BluetoothAdapter.this.mService = bluetoothService;
                for (IBluetoothManagerCallback cb : BluetoothAdapter.this.mProxyServiceStateCallbacks) {
                    try {
                        if (cb != null) {
                            cb.onBluetoothServiceUp(bluetoothService);
                            continue;
                        }
                        Log.d(BluetoothAdapter.TAG, "onBluetoothServiceUp: cb is null!!!");
                    }
                    catch (Exception e) {
                        Log.e(BluetoothAdapter.TAG, "", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBluetoothServiceDown() {
            IBluetoothManagerCallback iBluetoothManagerCallback = BluetoothAdapter.this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                BluetoothAdapter.this.mService = null;
                BluetoothAdapter.this.mBluetoothAdvScanData = null;
                for (IBluetoothManagerCallback cb : BluetoothAdapter.this.mProxyServiceStateCallbacks) {
                    try {
                        if (cb != null) {
                            cb.onBluetoothServiceDown();
                            continue;
                        }
                        Log.d(BluetoothAdapter.TAG, "onBluetoothServiceDown: cb is null!!!");
                    }
                    catch (Exception e) {
                        Log.e(BluetoothAdapter.TAG, "", e);
                    }
                }
            }
        }
    };
    private ArrayList<IBluetoothManagerCallback> mProxyServiceStateCallbacks = new ArrayList();

    public static synchronized BluetoothAdapter getDefaultAdapter() {
        if (sAdapter == null) {
            IBinder b = ServiceManager.getService(BLUETOOTH_MANAGER_SERVICE);
            if (b != null) {
                IBluetoothManager managerService = IBluetoothManager.Stub.asInterface(b);
                sAdapter = new BluetoothAdapter(managerService);
            } else {
                Log.e(TAG, "Bluetooth binder is null");
            }
        }
        return sAdapter;
    }

    BluetoothAdapter(IBluetoothManager managerService) {
        if (managerService == null) {
            throw new IllegalArgumentException("bluetooth manager service is null");
        }
        try {
            this.mService = managerService.registerAdapter(this.mManagerCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        this.mManagerService = managerService;
        this.mLeScanClients = new HashMap<LeScanCallback, GattCallbackWrapper>();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public BluetoothDevice getRemoteDevice(String address) {
        return new BluetoothDevice(address);
    }

    public BluetoothDevice getRemoteDevice(byte[] address) {
        if (address == null || address.length != 6) {
            throw new IllegalArgumentException("Bluetooth address must have 6 bytes");
        }
        return new BluetoothDevice(String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]));
    }

    public BluetoothAdvScanData getAdvScanData() {
        try {
            IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
            if (iGatt == null) {
                Log.e(TAG, "failed to start, iGatt null");
                return null;
            }
            if (this.mBluetoothAdvScanData == null) {
                this.mBluetoothAdvScanData = new BluetoothAdvScanData(iGatt, 0);
            }
            return this.mBluetoothAdvScanData;
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get advScanData, error: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAdvertising(final AdvertiseCallback callback) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
            if (iGatt == null) {
                return false;
            }
            if (this.isAdvertising()) {
                if (this.mAdvertisingGattCallback == null || this.mAdvertisingGattCallback.mLeHandle == -1) {
                    Log.e(TAG, "failed to restart advertising, invalid callback");
                    return false;
                }
                iGatt.startAdvertising(this.mAdvertisingGattCallback.mLeHandle);
                this.mHandler.post(new Runnable(){

                    public void run() {
                        callback.onAdvertiseStart(0);
                    }
                });
                return true;
            }
            UUID uuid = UUID.randomUUID();
            GattCallbackWrapper wrapper = new GattCallbackWrapper(this, null, null, callback);
            iGatt.registerClient(new ParcelUuid(uuid), wrapper);
            if (!wrapper.advertiseStarted()) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                this.mAdvertisingGattCallback = wrapper;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean stopAdvertising(AdvertiseCallback callback) {
        try {
            IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
            if (iGatt == null) {
                return false;
            }
            if (this.mAdvertisingGattCallback == null) {
                return false;
            }
            if (callback != this.mAdvertisingGattCallback.mAdvertiseCallback) {
                Log.e(TAG, "must use the same callback for star/stop advertising");
                return false;
            }
            this.mAdvertisingGattCallback.stopAdvertising();
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.isEnabled();
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    int state = this.mService.getState();
                    return state;
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        Log.d(TAG, "" + this.hashCode() + ": getState() :  mService = null. Returning STATE_OFF");
        return 10;
    }

    public boolean enable() {
        if (this.isEnabled()) {
            Log.d(TAG, "enable(): BT is already enabled..!");
            return true;
        }
        try {
            return this.mManagerService.enable();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean disable() {
        try {
            return this.mManagerService.disable(true);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean disable(boolean persist) {
        try {
            return this.mManagerService.disable(persist);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public String getAddress() {
        try {
            return this.mManagerService.getAddress();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getName() {
        try {
            return this.mManagerService.getName();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configHciSnoopLog(boolean enable) {
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.configHciSnoopLog(enable);
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelUuid[] getUuids() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getUuids();
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setName(String name) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.setName(name);
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getScanMode();
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScanMode(int mode, int duration) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.setScanMode(mode, duration);
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return false;
    }

    public boolean setScanMode(int mode) {
        if (this.getState() != 12) {
            return false;
        }
        return this.setScanMode(mode, this.getDiscoverableTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return -1;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getDiscoverableTimeout();
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscoverableTimeout(int timeout) {
        if (this.getState() != 12) {
            return;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    this.mService.setDiscoverableTimeout(timeout);
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.startDiscovery();
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.cancelDiscovery();
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.isDiscovering();
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return false;
    }

    public boolean isAdvertising() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
            return iGatt.isAdvertising();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BluetoothDevice> getBondedDevices() {
        if (this.getState() != 12) {
            return this.toDeviceSet(new BluetoothDevice[0]);
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.toDeviceSet(this.mService.getBondedDevices());
                }
            }
            return this.toDeviceSet(new BluetoothDevice[0]);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionState() {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getAdapterConnectionState();
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getConnectionState:", e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProfileConnectionState(int profile) {
        if (this.getState() != 12) {
            return 0;
        }
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    return this.mService.getProfileConnectionState(profile);
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getProfileConnectionState:", e);
        }
        return 0;
    }

    public BluetoothServerSocket listenUsingRfcommOn(int channel) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, true, true, channel);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, true, true);
    }

    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, false);
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, true);
    }

    private BluetoothServerSocket createNewRfcommSocketAndRecord(String name, UUID uuid, boolean auth, boolean encrypt) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, auth, encrypt, new ParcelUuid(uuid));
        socket.setServiceName(name);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingInsecureRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, false, port);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public BluetoothServerSocket listenUsingEncryptedRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, true, port);
        int errno = socket.mSocket.bindListen();
        if (errno < 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    public static BluetoothServerSocket listenUsingScoOn() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(2, false, false, -1);
        int errno = socket.mSocket.bindListen();
        if (errno < 0) {
            // empty if block
        }
        return socket;
    }

    public Pair<byte[], byte[]> readOutOfBandData() {
        if (this.getState() != 12) {
            return null;
        }
        return null;
    }

    public boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (context == null || listener == null) {
            return false;
        }
        if (profile == 1) {
            BluetoothHeadset headset = new BluetoothHeadset(context, listener);
            return true;
        }
        if (profile == 2) {
            BluetoothA2dp a2dp = new BluetoothA2dp(context, listener);
            return true;
        }
        if (profile == 4) {
            BluetoothInputDevice iDev = new BluetoothInputDevice(context, listener);
            return true;
        }
        if (profile == 5) {
            BluetoothPan pan = new BluetoothPan(context, listener);
            return true;
        }
        if (profile == 3) {
            BluetoothHealth health = new BluetoothHealth(context, listener);
            return true;
        }
        if (profile == 9) {
            BluetoothMap map = new BluetoothMap(context, listener);
            return true;
        }
        return false;
    }

    public void closeProfileProxy(int profile, BluetoothProfile proxy) {
        if (proxy == null) {
            return;
        }
        switch (profile) {
            case 1: {
                BluetoothHeadset headset = (BluetoothHeadset)proxy;
                headset.close();
                break;
            }
            case 2: {
                BluetoothA2dp a2dp = (BluetoothA2dp)proxy;
                a2dp.close();
                break;
            }
            case 4: {
                BluetoothInputDevice iDev = (BluetoothInputDevice)proxy;
                iDev.close();
                break;
            }
            case 5: {
                BluetoothPan pan = (BluetoothPan)proxy;
                pan.close();
                break;
            }
            case 3: {
                BluetoothHealth health = (BluetoothHealth)proxy;
                health.close();
                break;
            }
            case 7: {
                BluetoothGatt gatt = (BluetoothGatt)proxy;
                gatt.close();
                break;
            }
            case 8: {
                BluetoothGattServer gattServer = (BluetoothGattServer)proxy;
                gattServer.close();
                break;
            }
            case 9: {
                BluetoothMap map = (BluetoothMap)proxy;
                map.close();
            }
        }
    }

    public boolean enableNoAutoConnect() {
        if (this.isEnabled()) {
            Log.d(TAG, "enableNoAutoConnect(): BT is already enabled..!");
            return true;
        }
        try {
            return this.mManagerService.enableNoAutoConnect();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean changeApplicationBluetoothState(boolean on, BluetoothStateChangeCallback callback) {
        if (callback == null) {
            return false;
        }
        return false;
    }

    private Set<BluetoothDevice> toDeviceSet(BluetoothDevice[] devices) {
        HashSet<BluetoothDevice> deviceSet = new HashSet<BluetoothDevice>(Arrays.asList(devices));
        return Collections.unmodifiableSet(deviceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.mManagerService.unregisterAdapter(this.mManagerCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            super.finalize();
        }
    }

    public static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    IBluetoothManager getBluetoothManager() {
        return this.mManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBluetooth getBluetoothService(IBluetoothManagerCallback cb) {
        IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
        synchronized (iBluetoothManagerCallback) {
            if (cb == null) {
                Log.w(TAG, "getBluetoothService() called with no BluetoothManagerCallback");
            } else if (!this.mProxyServiceStateCallbacks.contains(cb)) {
                this.mProxyServiceStateCallbacks.add(cb);
            }
        }
        return this.mService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceStateCallback(IBluetoothManagerCallback cb) {
        IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
        synchronized (iBluetoothManagerCallback) {
            this.mProxyServiceStateCallbacks.remove(cb);
        }
    }

    public boolean startLeScan(LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startLeScan(UUID[] serviceUuids, LeScanCallback callback) {
        Log.d(TAG, "startLeScan(): " + serviceUuids);
        if (callback == null) {
            Log.e(TAG, "startLeScan: null callback");
            return false;
        }
        Map<LeScanCallback, GattCallbackWrapper> map = this.mLeScanClients;
        synchronized (map) {
            if (this.mLeScanClients.containsKey(callback)) {
                Log.e(TAG, "LE Scan has already started");
                return false;
            }
            try {
                IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
                if (iGatt == null) {
                    return false;
                }
                UUID uuid = UUID.randomUUID();
                GattCallbackWrapper wrapper = new GattCallbackWrapper(this, callback, serviceUuids);
                iGatt.registerClient(new ParcelUuid(uuid), wrapper);
                if (wrapper.scanStarted()) {
                    this.mLeScanClients.put(callback, wrapper);
                    return true;
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLeScan(LeScanCallback callback) {
        GattCallbackWrapper wrapper;
        Log.d(TAG, "stopLeScan()");
        Map<LeScanCallback, GattCallbackWrapper> map = this.mLeScanClients;
        synchronized (map) {
            wrapper = this.mLeScanClients.remove(callback);
            if (wrapper == null) {
                return;
            }
        }
        wrapper.stopLeScan();
    }

    private static class GattCallbackWrapper
    extends IBluetoothGattCallback.Stub {
        private static final int LE_CALLBACK_REG_TIMEOUT = 2000;
        private static final int LE_CALLBACK_REG_WAIT_COUNT = 5;
        private final AdvertiseCallback mAdvertiseCallback;
        private final LeScanCallback mLeScanCb;
        private int mLeHandle;
        private final UUID[] mScanFilter;
        private WeakReference<BluetoothAdapter> mBluetoothAdapter;

        public GattCallbackWrapper(BluetoothAdapter bluetoothAdapter, LeScanCallback leScanCb, UUID[] uuid) {
            this.mBluetoothAdapter = new WeakReference<BluetoothAdapter>(bluetoothAdapter);
            this.mLeScanCb = leScanCb;
            this.mScanFilter = uuid;
            this.mLeHandle = 0;
            this.mAdvertiseCallback = null;
        }

        public GattCallbackWrapper(BluetoothAdapter bluetoothAdapter, LeScanCallback leScanCb, UUID[] uuid, AdvertiseCallback callback) {
            this.mBluetoothAdapter = new WeakReference<BluetoothAdapter>(bluetoothAdapter);
            this.mLeScanCb = leScanCb;
            this.mScanFilter = uuid;
            this.mLeHandle = 0;
            this.mAdvertiseCallback = callback;
        }

        public boolean scanStarted() {
            return this.waitForRegisteration(5);
        }

        public boolean advertiseStarted() {
            return this.waitForRegisteration(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForRegisteration(int maxWaitCount) {
            boolean started = false;
            GattCallbackWrapper gattCallbackWrapper = this;
            synchronized (gattCallbackWrapper) {
                if (this.mLeHandle == -1) {
                    return false;
                }
                for (int count = 0; this.mLeHandle == 0 && count < maxWaitCount; ++count) {
                    try {
                        this.wait(2000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Log.e(BluetoothAdapter.TAG, "Callback reg wait interrupted: " + e);
                    }
                }
                started = this.mLeHandle > 0;
            }
            return started;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAdvertising() {
            GattCallbackWrapper gattCallbackWrapper = this;
            synchronized (gattCallbackWrapper) {
                if (this.mLeHandle <= 0) {
                    Log.e(BluetoothAdapter.TAG, "Error state, mLeHandle: " + this.mLeHandle);
                    return;
                }
                BluetoothAdapter adapter = (BluetoothAdapter)this.mBluetoothAdapter.get();
                if (adapter != null) {
                    try {
                        IBluetoothGatt iGatt = adapter.getBluetoothManager().getBluetoothGatt();
                        iGatt.stopAdvertising();
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothAdapter.TAG, "Failed to stop advertising" + e);
                    }
                } else {
                    Log.e(BluetoothAdapter.TAG, "stopAdvertising, BluetoothAdapter is null");
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopLeScan() {
            GattCallbackWrapper gattCallbackWrapper = this;
            synchronized (gattCallbackWrapper) {
                if (this.mLeHandle <= 0) {
                    Log.e(BluetoothAdapter.TAG, "Error state, mLeHandle: " + this.mLeHandle);
                    return;
                }
                BluetoothAdapter adapter = (BluetoothAdapter)this.mBluetoothAdapter.get();
                if (adapter != null) {
                    try {
                        IBluetoothGatt iGatt = adapter.getBluetoothManager().getBluetoothGatt();
                        iGatt.stopScan(this.mLeHandle, false);
                        iGatt.unregisterClient(this.mLeHandle);
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothAdapter.TAG, "Failed to stop scan and unregister" + e);
                    }
                } else {
                    Log.e(BluetoothAdapter.TAG, "stopLeScan, BluetoothAdapter is null");
                }
                this.mLeHandle = -1;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClientRegistered(int status, int clientIf) {
            Log.d(BluetoothAdapter.TAG, "onClientRegistered() - status=" + status + " clientIf=" + clientIf);
            GattCallbackWrapper gattCallbackWrapper = this;
            synchronized (gattCallbackWrapper) {
                if (this.mLeHandle == -1) {
                    Log.d(BluetoothAdapter.TAG, "onClientRegistered LE scan canceled");
                }
                if (status == 0) {
                    this.mLeHandle = clientIf;
                    IBluetoothGatt iGatt = null;
                    try {
                        BluetoothAdapter adapter = (BluetoothAdapter)this.mBluetoothAdapter.get();
                        if (adapter != null) {
                            iGatt = adapter.getBluetoothManager().getBluetoothGatt();
                            if (this.mAdvertiseCallback != null) {
                                iGatt.startAdvertising(this.mLeHandle);
                            } else if (this.mScanFilter == null) {
                                iGatt.startScan(this.mLeHandle, false);
                            } else {
                                ParcelUuid[] uuids = new ParcelUuid[this.mScanFilter.length];
                                for (int i = 0; i != uuids.length; ++i) {
                                    uuids[i] = new ParcelUuid(this.mScanFilter[i]);
                                }
                                iGatt.startScanWithUuids(this.mLeHandle, false, uuids);
                            }
                        } else {
                            Log.e(BluetoothAdapter.TAG, "onClientRegistered, BluetoothAdapter null");
                            this.mLeHandle = -1;
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothAdapter.TAG, "fail to start le scan: " + e);
                        this.mLeHandle = -1;
                    }
                    if (this.mLeHandle == -1 && iGatt != null) {
                        try {
                            iGatt.unregisterClient(this.mLeHandle);
                        }
                        catch (RemoteException e) {
                            Log.e(BluetoothAdapter.TAG, "fail to unregister callback: " + this.mLeHandle + " error: " + e);
                        }
                    }
                } else {
                    this.mLeHandle = -1;
                }
                this.notifyAll();
            }
        }

        public void onClientConnectionState(int status, int clientIf, boolean connected, String address) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(String address, int rssi, byte[] advData) {
            GattCallbackWrapper gattCallbackWrapper = this;
            synchronized (gattCallbackWrapper) {
                if (this.mLeHandle <= 0) {
                    return;
                }
            }
            try {
                BluetoothAdapter adapter = (BluetoothAdapter)this.mBluetoothAdapter.get();
                if (adapter == null) {
                    Log.d(BluetoothAdapter.TAG, "onScanResult, BluetoothAdapter null");
                    return;
                }
                this.mLeScanCb.onLeScan(adapter.getRemoteDevice(address), rssi, advData);
            }
            catch (Exception ex) {
                Log.w(BluetoothAdapter.TAG, "Unhandled exception: " + ex);
            }
        }

        public void onGetService(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid) {
        }

        public void onGetIncludedService(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int inclSrvcType, int inclSrvcInstId, ParcelUuid inclSrvcUuid) {
        }

        public void onGetCharacteristic(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, int charProps) {
        }

        public void onGetDescriptor(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, int descInstId, ParcelUuid descUuid) {
        }

        public void onSearchComplete(String address, int status) {
        }

        public void onCharacteristicRead(String address, int status, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, byte[] value) {
        }

        public void onCharacteristicWrite(String address, int status, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid) {
        }

        public void onNotify(String address, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, byte[] value) {
        }

        public void onDescriptorRead(String address, int status, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, int descInstId, ParcelUuid descrUuid, byte[] value) {
        }

        public void onDescriptorWrite(String address, int status, int srvcType, int srvcInstId, ParcelUuid srvcUuid, int charInstId, ParcelUuid charUuid, int descInstId, ParcelUuid descrUuid) {
        }

        public void onExecuteWrite(String address, int status) {
        }

        public void onReadRemoteRssi(String address, int rssi, int status) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAdvertiseStateChange(int advertiseState, int status) {
            Log.d(BluetoothAdapter.TAG, "on advertise call back, state: " + advertiseState + " status: " + status);
            if (advertiseState == 1) {
                if (status == 0) {
                    this.mAdvertiseCallback.onAdvertiseStart(status);
                } else {
                    this.mAdvertiseCallback.onAdvertiseStop(status);
                }
            } else {
                GattCallbackWrapper gattCallbackWrapper = this;
                synchronized (gattCallbackWrapper) {
                    if (status == 0) {
                        BluetoothAdapter adapter = (BluetoothAdapter)this.mBluetoothAdapter.get();
                        if (adapter != null) {
                            try {
                                IBluetoothGatt iGatt = adapter.getBluetoothManager().getBluetoothGatt();
                                Log.d(BluetoothAdapter.TAG, "unregistering client " + this.mLeHandle);
                                iGatt.unregisterClient(this.mLeHandle);
                                this.mLeHandle = -1;
                                adapter.mAdvertisingGattCallback = null;
                            }
                            catch (RemoteException e) {
                                Log.e(BluetoothAdapter.TAG, "Failed to unregister client" + e);
                            }
                        } else {
                            Log.e(BluetoothAdapter.TAG, "cannot unregister client, BluetoothAdapter is null");
                        }
                    }
                }
                if (status == 0) {
                    this.mAdvertiseCallback.onAdvertiseStop(status);
                } else {
                    this.mAdvertiseCallback.onAdvertiseStart(status);
                }
            }
        }

        public void onConfigureMTU(String address, int mtu, int status) {
        }
    }

    public static interface LeScanCallback {
        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);
    }

    public class StateChangeCallbackWrapper
    extends IBluetoothStateChangeCallback.Stub {
        private BluetoothStateChangeCallback mCallback;

        StateChangeCallbackWrapper(BluetoothStateChangeCallback callback) {
            this.mCallback = callback;
        }

        public void onBluetoothStateChange(boolean on) {
            this.mCallback.onBluetoothStateChange(on);
        }
    }

    public static interface BluetoothStateChangeCallback {
        public void onBluetoothStateChange(boolean var1);
    }

    public static interface AdvertiseCallback {
        public void onAdvertiseStart(int var1);

        public void onAdvertiseStop(int var1);
    }
}

