/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.WallpaperInfo;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.view.WindowManagerGlobal;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class WallpaperManager {
    private static String TAG = "WallpaperManager";
    private static boolean DEBUG = false;
    private float mWallpaperXStep = -1.0f;
    private float mWallpaperYStep = -1.0f;
    public static final String ACTION_CROP_AND_SET_WALLPAPER = "android.service.wallpaper.CROP_AND_SET_WALLPAPER";
    public static final String ACTION_LIVE_WALLPAPER_CHOOSER = "android.service.wallpaper.LIVE_WALLPAPER_CHOOSER";
    public static final String ACTION_CHANGE_LIVE_WALLPAPER = "android.service.wallpaper.CHANGE_LIVE_WALLPAPER";
    public static final String EXTRA_LIVE_WALLPAPER_COMPONENT = "android.service.wallpaper.extra.LIVE_WALLPAPER_COMPONENT";
    public static final String WALLPAPER_PREVIEW_META_DATA = "android.wallpaper.preview";
    public static final String COMMAND_TAP = "android.wallpaper.tap";
    public static final String COMMAND_SECONDARY_TAP = "android.wallpaper.secondaryTap";
    public static final String COMMAND_DROP = "android.home.drop";
    private final Context mContext;
    private static final Object sSync = new Object[0];
    private static Globals sGlobals;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initGlobals(Looper looper) {
        Object object = sSync;
        synchronized (object) {
            if (sGlobals == null) {
                sGlobals = new Globals(looper);
            }
        }
    }

    WallpaperManager(Context context, Handler handler) {
        this.mContext = context;
        WallpaperManager.initGlobals(context.getMainLooper());
    }

    public static WallpaperManager getInstance(Context context) {
        return (WallpaperManager)context.getSystemService("wallpaper");
    }

    public IWallpaperManager getIWallpaperManager() {
        return sGlobals.mService;
    }

    public Drawable getDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, true);
        if (bm != null) {
            BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bm);
            ((Drawable)dr).setDither(false);
            return dr;
        }
        return null;
    }

    public Drawable getBuiltInDrawable() {
        return this.getBuiltInDrawable(0, 0, false, 0.0f, 0.0f);
    }

    public Drawable getBuiltInDrawable(int outWidth, int outHeight, boolean scaleToFit, float horizontalAlignment, float verticalAlignment) {
        RectF cropRectF;
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return null;
        }
        Resources resources = this.mContext.getResources();
        horizontalAlignment = Math.max(0.0f, Math.min(1.0f, horizontalAlignment));
        verticalAlignment = Math.max(0.0f, Math.min(1.0f, verticalAlignment));
        BufferedInputStream is = new BufferedInputStream(resources.openRawResource(17302048));
        if (is == null) {
            Log.e(TAG, "default wallpaper input stream is null");
            return null;
        }
        if (outWidth <= 0 || outHeight <= 0) {
            Bitmap fullSize = BitmapFactory.decodeStream(is, null, null);
            return new BitmapDrawable(resources, fullSize);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream(is, null, options);
        if (options.outWidth == 0 || options.outHeight == 0) {
            Log.e(TAG, "default wallpaper dimensions are 0");
            return null;
        }
        int inWidth = options.outWidth;
        int inHeight = options.outHeight;
        is = new BufferedInputStream(resources.openRawResource(17302048));
        outWidth = Math.min(inWidth, outWidth);
        outHeight = Math.min(inHeight, outHeight);
        if (scaleToFit) {
            cropRectF = WallpaperManager.getMaxCropRect(inWidth, inHeight, outWidth, outHeight, horizontalAlignment, verticalAlignment);
        } else {
            float left = (float)(inWidth - outWidth) * horizontalAlignment;
            float right = left + (float)outWidth;
            float top = (float)(inHeight - outHeight) * verticalAlignment;
            float bottom = top + (float)outHeight;
            cropRectF = new RectF(left, top, right, bottom);
        }
        Rect roundedTrueCrop = new Rect();
        cropRectF.roundOut(roundedTrueCrop);
        if (roundedTrueCrop.width() <= 0 || roundedTrueCrop.height() <= 0) {
            Log.w(TAG, "crop has bad values for full size image");
            return null;
        }
        int scaleDownSampleSize = Math.min(roundedTrueCrop.width() / outWidth, roundedTrueCrop.height() / outHeight);
        BitmapRegionDecoder decoder = null;
        try {
            decoder = BitmapRegionDecoder.newInstance(is, true);
        }
        catch (IOException e) {
            Log.w(TAG, "cannot open region decoder for default wallpaper");
        }
        Bitmap crop = null;
        if (decoder != null) {
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            if (scaleDownSampleSize > 1) {
                options2.inSampleSize = scaleDownSampleSize;
            }
            crop = decoder.decodeRegion(roundedTrueCrop, options2);
            decoder.recycle();
        }
        if (crop == null) {
            is = new BufferedInputStream(resources.openRawResource(17302048));
            Bitmap fullSize = null;
            if (is != null) {
                BitmapFactory.Options options3 = new BitmapFactory.Options();
                if (scaleDownSampleSize > 1) {
                    options3.inSampleSize = scaleDownSampleSize;
                }
                fullSize = BitmapFactory.decodeStream(is, null, options3);
            }
            if (fullSize != null) {
                crop = Bitmap.createBitmap(fullSize, roundedTrueCrop.left, roundedTrueCrop.top, roundedTrueCrop.width(), roundedTrueCrop.height());
            }
        }
        if (crop == null) {
            Log.w(TAG, "cannot decode default wallpaper");
            return null;
        }
        if (outWidth > 0 && outHeight > 0 && (crop.getWidth() != outWidth || crop.getHeight() != outHeight)) {
            Matrix m = new Matrix();
            RectF cropRect = new RectF(0.0f, 0.0f, crop.getWidth(), crop.getHeight());
            RectF returnRect = new RectF(0.0f, 0.0f, outWidth, outHeight);
            m.setRectToRect(cropRect, returnRect, Matrix.ScaleToFit.FILL);
            Bitmap tmp = Bitmap.createBitmap((int)returnRect.width(), (int)returnRect.height(), Bitmap.Config.ARGB_8888);
            if (tmp != null) {
                Canvas c = new Canvas(tmp);
                Paint p = new Paint();
                p.setFilterBitmap(true);
                c.drawBitmap(crop, m, p);
                crop = tmp;
            }
        }
        return new BitmapDrawable(resources, crop);
    }

    private static RectF getMaxCropRect(int inWidth, int inHeight, int outWidth, int outHeight, float horizontalAlignment, float verticalAlignment) {
        RectF cropRect = new RectF();
        if ((float)inWidth / (float)inHeight > (float)outWidth / (float)outHeight) {
            cropRect.top = 0.0f;
            cropRect.bottom = inHeight;
            float cropWidth = (float)outWidth * ((float)inHeight / (float)outHeight);
            cropRect.left = ((float)inWidth - cropWidth) * horizontalAlignment;
            cropRect.right = cropRect.left + cropWidth;
        } else {
            cropRect.left = 0.0f;
            cropRect.right = inWidth;
            float cropHeight = (float)outHeight * ((float)inWidth / (float)outWidth);
            cropRect.top = ((float)inHeight - cropHeight) * verticalAlignment;
            cropRect.bottom = cropRect.top + cropHeight;
        }
        return cropRect;
    }

    public Drawable peekDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, false);
        if (bm != null) {
            BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bm);
            ((Drawable)dr).setDither(false);
            return dr;
        }
        return null;
    }

    public Drawable getFastDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, true);
        if (bm != null) {
            return new FastBitmapDrawable(bm);
        }
        return null;
    }

    public Drawable peekFastDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, false);
        if (bm != null) {
            return new FastBitmapDrawable(bm);
        }
        return null;
    }

    public Bitmap getBitmap() {
        return sGlobals.peekWallpaperBitmap(this.mContext, true);
    }

    public void forgetLoadedWallpaper() {
        sGlobals.forgetLoadedWallpaper();
    }

    public WallpaperInfo getWallpaperInfo() {
        try {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                return null;
            }
            return sGlobals.mService.getWallpaperInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public Intent getCropAndSetWallpaperIntent(Uri imageUri) {
        List<ResolveInfo> cropAppList;
        if (!"content".equals(imageUri.getScheme())) {
            throw new IllegalArgumentException("Image URI must be of the content scheme type");
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent cropAndSetWallpaperIntent = new Intent(ACTION_CROP_AND_SET_WALLPAPER, imageUri);
        cropAndSetWallpaperIntent.addFlags(1);
        Intent homeIntent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME");
        ResolveInfo resolvedHome = packageManager.resolveActivity(homeIntent, 65536);
        if (resolvedHome != null) {
            cropAndSetWallpaperIntent.setPackage(resolvedHome.activityInfo.packageName);
            cropAppList = packageManager.queryIntentActivities(cropAndSetWallpaperIntent, 0);
            if (cropAppList.size() > 0) {
                return cropAndSetWallpaperIntent;
            }
        }
        cropAndSetWallpaperIntent.setPackage("com.android.wallpapercropper");
        cropAppList = packageManager.queryIntentActivities(cropAndSetWallpaperIntent, 0);
        if (cropAppList.size() > 0) {
            return cropAndSetWallpaperIntent;
        }
        throw new IllegalArgumentException("Cannot use passed URI to set wallpaper; check that the type returned by ContentProvider matches image/*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResource(int resid) throws IOException {
        block7: {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                return;
            }
            try {
                Resources resources = this.mContext.getResources();
                ParcelFileDescriptor fd = sGlobals.mService.setWallpaper("res:" + resources.getResourceName(resid));
                if (fd == null) break block7;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    this.setWallpaper(resources.openRawResource(resid), fos);
                }
                finally {
                    if (fos != null) {
                        ((FileOutputStream)fos).close();
                    }
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBitmap(Bitmap bitmap) throws IOException {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return;
        }
        try {
            ParcelFileDescriptor fd = sGlobals.mService.setWallpaper(null);
            if (fd == null) {
                return;
            }
            ParcelFileDescriptor.AutoCloseOutputStream fos = null;
            try {
                fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                bitmap.compress(Bitmap.CompressFormat.PNG, 90, fos);
            }
            finally {
                if (fos != null) {
                    ((FileOutputStream)fos).close();
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStream(InputStream data) throws IOException {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return;
        }
        try {
            ParcelFileDescriptor fd = sGlobals.mService.setWallpaper(null);
            if (fd == null) {
                return;
            }
            ParcelFileDescriptor.AutoCloseOutputStream fos = null;
            try {
                fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                this.setWallpaper(data, fos);
            }
            finally {
                if (fos != null) {
                    ((FileOutputStream)fos).close();
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setWallpaper(InputStream data, FileOutputStream fos) throws IOException {
        int amt;
        byte[] buffer = new byte[32768];
        while ((amt = data.read(buffer)) > 0) {
            fos.write(buffer, 0, amt);
        }
    }

    public boolean hasResourceWallpaper(int resid) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return false;
        }
        try {
            Resources resources = this.mContext.getResources();
            String name = "res:" + resources.getResourceName(resid);
            return sGlobals.mService.hasNamedWallpaper(name);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public int getDesiredMinimumWidth() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return 0;
        }
        try {
            return sGlobals.mService.getWidthHint();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public int getDesiredMinimumHeight() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return 0;
        }
        try {
            return sGlobals.mService.getHeightHint();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void suggestDesiredDimensions(int minimumWidth, int minimumHeight) {
        try {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
            } else {
                sGlobals.mService.setDimensionHints(minimumWidth, minimumHeight);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setWallpaperOffsets(IBinder windowToken, float xOffset, float yOffset) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(windowToken, xOffset, yOffset, this.mWallpaperXStep, this.mWallpaperYStep);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void setWallpaperOffsetSteps(float xStep, float yStep) {
        this.mWallpaperXStep = xStep;
        this.mWallpaperYStep = yStep;
    }

    public void sendWallpaperCommand(IBinder windowToken, String action, int x, int y, int z, Bundle extras) {
        try {
            WindowManagerGlobal.getWindowSession().sendWallpaperCommand(windowToken, action, x, y, z, extras, false);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void clearWallpaperOffsets(IBinder windowToken) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(windowToken, -1.0f, -1.0f, -1.0f, -1.0f);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void clear() throws IOException {
        this.setResource(17302048);
    }

    static class Globals
    extends IWallpaperManagerCallback.Stub {
        private IWallpaperManager mService;
        private Bitmap mWallpaper;
        private Bitmap mDefaultWallpaper;
        private static final int MSG_CLEAR_WALLPAPER = 1;
        private final Handler mHandler;

        Globals(Looper looper) {
            IBinder b = ServiceManager.getService("wallpaper");
            this.mService = IWallpaperManager.Stub.asInterface(b);
            this.mHandler = new Handler(looper){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                Globals.this.mWallpaper = null;
                                Globals.this.mDefaultWallpaper = null;
                                break;
                            }
                        }
                    }
                }
            };
        }

        public void onWallpaperChanged() {
            this.mHandler.sendEmptyMessage(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bitmap peekWallpaperBitmap(Context context, boolean returnDefault) {
            Globals globals = this;
            synchronized (globals) {
                if (this.mWallpaper != null) {
                    return this.mWallpaper;
                }
                if (this.mDefaultWallpaper != null) {
                    return this.mDefaultWallpaper;
                }
                this.mWallpaper = null;
                try {
                    this.mWallpaper = this.getCurrentWallpaperLocked(context);
                }
                catch (OutOfMemoryError e) {
                    Log.w(TAG, "No memory load current wallpaper", e);
                }
                if (returnDefault) {
                    if (this.mWallpaper == null) {
                        this.mDefaultWallpaper = this.getDefaultWallpaperLocked(context);
                        return this.mDefaultWallpaper;
                    }
                    this.mDefaultWallpaper = null;
                }
                return this.mWallpaper;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forgetLoadedWallpaper() {
            Globals globals = this;
            synchronized (globals) {
                this.mWallpaper = null;
                this.mDefaultWallpaper = null;
                this.mHandler.removeMessages(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Bitmap getCurrentWallpaperLocked(Context context) {
            if (this.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                return null;
            }
            try {
                Bundle params = new Bundle();
                ParcelFileDescriptor fd = this.mService.getWallpaper(this, params);
                if (fd == null) return null;
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    Bitmap bitmap = BitmapFactory.decodeFileDescriptor(fd.getFileDescriptor(), null, options);
                    return bitmap;
                }
                catch (OutOfMemoryError e) {
                    Log.w(TAG, "Can't decode file", e);
                    return null;
                }
                finally {
                    try {
                        fd.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Bitmap getDefaultWallpaperLocked(Context context) {
            InputStream is = context.getResources().openRawResource(17302048);
            if (is != null) {
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    Bitmap bitmap = BitmapFactory.decodeStream(is, null, options);
                    return bitmap;
                }
                catch (OutOfMemoryError e) {
                    Log.w(TAG, "Can't decode stream", e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
    }

    static class FastBitmapDrawable
    extends Drawable {
        private final Bitmap mBitmap;
        private final int mWidth;
        private final int mHeight;
        private int mDrawLeft;
        private int mDrawTop;
        private final Paint mPaint;

        private FastBitmapDrawable(Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mWidth = bitmap.getWidth();
            this.mHeight = bitmap.getHeight();
            this.setBounds(0, 0, this.mWidth, this.mHeight);
            this.mPaint = new Paint();
            this.mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC));
        }

        public void draw(Canvas canvas) {
            canvas.drawBitmap(this.mBitmap, this.mDrawLeft, this.mDrawTop, this.mPaint);
        }

        public int getOpacity() {
            return -1;
        }

        public void setBounds(int left, int top, int right, int bottom) {
            this.mDrawLeft = left + (right - left - this.mWidth) / 2;
            this.mDrawTop = top + (bottom - top - this.mHeight) / 2;
        }

        public void setAlpha(int alpha) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        public void setColorFilter(ColorFilter cf) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        public void setDither(boolean dither) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        public void setFilterBitmap(boolean filter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        public int getIntrinsicWidth() {
            return this.mWidth;
        }

        public int getIntrinsicHeight() {
            return this.mHeight;
        }

        public int getMinimumWidth() {
            return this.mWidth;
        }

        public int getMinimumHeight() {
            return this.mHeight;
        }
    }
}

