/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ContextImpl;
import android.app.LoadedApk;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Bundle;
import java.util.ArrayList;

public class Application
extends ContextWrapper
implements ComponentCallbacks2 {
    private ArrayList<ComponentCallbacks> mComponentCallbacks = new ArrayList();
    private ArrayList<ActivityLifecycleCallbacks> mActivityLifecycleCallbacks = new ArrayList();
    private ArrayList<OnProvideAssistDataListener> mAssistCallbacks = null;
    public LoadedApk mLoadedApk;

    public Application() {
        super(null);
    }

    public void onCreate() {
    }

    public void onTerminate() {
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Object[] callbacks = this.collectComponentCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ComponentCallbacks)callbacks[i]).onConfigurationChanged(newConfig);
            }
        }
    }

    public void onLowMemory() {
        Object[] callbacks = this.collectComponentCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ComponentCallbacks)callbacks[i]).onLowMemory();
            }
        }
    }

    public void onTrimMemory(int level) {
        Object[] callbacks = this.collectComponentCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                Object c = callbacks[i];
                if (!(c instanceof ComponentCallbacks2)) continue;
                ((ComponentCallbacks2)c).onTrimMemory(level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerComponentCallbacks(ComponentCallbacks callback) {
        ArrayList<ComponentCallbacks> arrayList = this.mComponentCallbacks;
        synchronized (arrayList) {
            this.mComponentCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterComponentCallbacks(ComponentCallbacks callback) {
        ArrayList<ComponentCallbacks> arrayList = this.mComponentCallbacks;
        synchronized (arrayList) {
            this.mComponentCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivityLifecycleCallbacks(ActivityLifecycleCallbacks callback) {
        ArrayList<ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            this.mActivityLifecycleCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterActivityLifecycleCallbacks(ActivityLifecycleCallbacks callback) {
        ArrayList<ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            this.mActivityLifecycleCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnProvideAssistDataListener(OnProvideAssistDataListener callback) {
        Application application = this;
        synchronized (application) {
            if (this.mAssistCallbacks == null) {
                this.mAssistCallbacks = new ArrayList();
            }
            this.mAssistCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnProvideAssistDataListener(OnProvideAssistDataListener callback) {
        Application application = this;
        synchronized (application) {
            if (this.mAssistCallbacks != null) {
                this.mAssistCallbacks.remove(callback);
            }
        }
    }

    void attach(Context context) {
        this.attachBaseContext(context);
        this.mLoadedApk = ContextImpl.getImpl((Context)context).mPackageInfo;
    }

    void dispatchActivityCreated(Activity activity, Bundle savedInstanceState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityCreated(activity, savedInstanceState);
            }
        }
    }

    void dispatchActivityStarted(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityStarted(activity);
            }
        }
    }

    void dispatchActivityResumed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityResumed(activity);
            }
        }
    }

    void dispatchActivityPaused(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityPaused(activity);
            }
        }
    }

    void dispatchActivityStopped(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityStopped(activity);
            }
        }
    }

    void dispatchActivitySaveInstanceState(Activity activity, Bundle outState) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivitySaveInstanceState(activity, outState);
            }
        }
    }

    void dispatchActivityDestroyed(Activity activity) {
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((ActivityLifecycleCallbacks)callbacks[i]).onActivityDestroyed(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] collectComponentCallbacks() {
        Object[] callbacks = null;
        ArrayList<ComponentCallbacks> arrayList = this.mComponentCallbacks;
        synchronized (arrayList) {
            if (this.mComponentCallbacks.size() > 0) {
                callbacks = this.mComponentCallbacks.toArray();
            }
        }
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] collectActivityLifecycleCallbacks() {
        Object[] callbacks = null;
        ArrayList<ActivityLifecycleCallbacks> arrayList = this.mActivityLifecycleCallbacks;
        synchronized (arrayList) {
            if (this.mActivityLifecycleCallbacks.size() > 0) {
                callbacks = this.mActivityLifecycleCallbacks.toArray();
            }
        }
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchOnProvideAssistData(Activity activity, Bundle data) {
        Object[] callbacks;
        Application application = this;
        synchronized (application) {
            if (this.mAssistCallbacks == null) {
                return;
            }
            callbacks = this.mAssistCallbacks.toArray();
        }
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((OnProvideAssistDataListener)callbacks[i]).onProvideAssistData(activity, data);
            }
        }
    }

    public static interface OnProvideAssistDataListener {
        public void onProvideAssistData(Activity var1, Bundle var2);
    }

    public static interface ActivityLifecycleCallbacks {
        public void onActivityCreated(Activity var1, Bundle var2);

        public void onActivityStarted(Activity var1);

        public void onActivityResumed(Activity var1);

        public void onActivityPaused(Activity var1);

        public void onActivityStopped(Activity var1);

        public void onActivitySaveInstanceState(Activity var1, Bundle var2);

        public void onActivityDestroyed(Activity var1);
    }
}

