/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.util.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectAnimator
extends ValueAnimator {
    private static final boolean DBG = false;
    private Object mTarget;
    private String mPropertyName;
    private Property mProperty;
    private boolean mAutoCancel = false;

    public void setPropertyName(String propertyName) {
        if (this.mValues != null) {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            String oldName = valuesHolder.getPropertyName();
            valuesHolder.setPropertyName(propertyName);
            this.mValuesMap.remove(oldName);
            this.mValuesMap.put(propertyName, valuesHolder);
        }
        this.mPropertyName = propertyName;
        this.mInitialized = false;
    }

    public void setProperty(Property property) {
        if (this.mValues != null) {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            String oldName = valuesHolder.getPropertyName();
            valuesHolder.setProperty(property);
            this.mValuesMap.remove(oldName);
            this.mValuesMap.put(this.mPropertyName, valuesHolder);
        }
        if (this.mProperty != null) {
            this.mPropertyName = property.getName();
        }
        this.mProperty = property;
        this.mInitialized = false;
    }

    public String getPropertyName() {
        String propertyName = null;
        if (this.mPropertyName != null) {
            propertyName = this.mPropertyName;
        } else if (this.mProperty != null) {
            propertyName = this.mProperty.getName();
        } else if (this.mValues != null && this.mValues.length > 0) {
            for (int i = 0; i < this.mValues.length; ++i) {
                propertyName = i == 0 ? "" : propertyName + ",";
                propertyName = propertyName + this.mValues[i].getPropertyName();
            }
        }
        return propertyName;
    }

    @Override
    String getNameForTrace() {
        return "animator:" + this.getPropertyName();
    }

    public ObjectAnimator() {
    }

    private ObjectAnimator(Object target, String propertyName) {
        this.mTarget = target;
        this.setPropertyName(propertyName);
    }

    private <T> ObjectAnimator(T target, Property<T, ?> property) {
        this.mTarget = target;
        this.setProperty(property);
    }

    public static ObjectAnimator ofInt(Object target, String propertyName, int ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, propertyName);
        anim2.setIntValues(values);
        return anim2;
    }

    public static <T> ObjectAnimator ofInt(T target, Property<T, Integer> property, int ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, property);
        anim2.setIntValues(values);
        return anim2;
    }

    public static ObjectAnimator ofFloat(Object target, String propertyName, float ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, propertyName);
        anim2.setFloatValues(values);
        return anim2;
    }

    public static <T> ObjectAnimator ofFloat(T target, Property<T, Float> property, float ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, property);
        anim2.setFloatValues(values);
        return anim2;
    }

    public static ObjectAnimator ofObject(Object target, String propertyName, TypeEvaluator evaluator, Object ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, propertyName);
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    public static <T, V> ObjectAnimator ofObject(T target, Property<T, V> property, TypeEvaluator<V> evaluator, V ... values) {
        ObjectAnimator anim2 = new ObjectAnimator(target, property);
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    public static ObjectAnimator ofPropertyValuesHolder(Object target, PropertyValuesHolder ... values) {
        ObjectAnimator anim2 = new ObjectAnimator();
        anim2.mTarget = target;
        anim2.setValues(values);
        return anim2;
    }

    @Override
    public void setIntValues(int ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofInt(this.mProperty, values));
            } else {
                this.setValues(PropertyValuesHolder.ofInt(this.mPropertyName, values));
            }
        } else {
            super.setIntValues(values);
        }
    }

    @Override
    public void setFloatValues(float ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofFloat(this.mProperty, values));
            } else {
                this.setValues(PropertyValuesHolder.ofFloat(this.mPropertyName, values));
            }
        } else {
            super.setFloatValues(values);
        }
    }

    @Override
    public void setObjectValues(Object ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofObject(this.mProperty, (TypeEvaluator)null, values));
            } else {
                this.setValues(PropertyValuesHolder.ofObject(this.mPropertyName, (TypeEvaluator)null, values));
            }
        } else {
            super.setObjectValues(values);
        }
    }

    public void setAutoCancel(boolean cancel) {
        this.mAutoCancel = cancel;
    }

    private boolean hasSameTargetAndProperties(Animator anim2) {
        if (anim2 instanceof ObjectAnimator) {
            PropertyValuesHolder[] theirValues = ((ObjectAnimator)anim2).getValues();
            if (((ObjectAnimator)anim2).getTarget() == this.mTarget && this.mValues.length == theirValues.length) {
                for (int i = 0; i < this.mValues.length; ++i) {
                    PropertyValuesHolder pvhMine = this.mValues[i];
                    PropertyValuesHolder pvhTheirs = theirValues[i];
                    if (pvhMine.getPropertyName() != null && pvhMine.getPropertyName().equals(pvhTheirs.getPropertyName())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void start() {
        ValueAnimator.AnimationHandler handler = (ValueAnimator.AnimationHandler)sAnimationHandler.get();
        if (handler != null) {
            ObjectAnimator anim2;
            int i;
            int numAnims = handler.mAnimations.size();
            for (i = numAnims - 1; i >= 0; --i) {
                if (!(handler.mAnimations.get(i) instanceof ObjectAnimator)) continue;
                anim2 = (ObjectAnimator)handler.mAnimations.get(i);
                if (!anim2.mAutoCancel || !this.hasSameTargetAndProperties(anim2)) continue;
                anim2.cancel();
            }
            numAnims = handler.mPendingAnimations.size();
            for (i = numAnims - 1; i >= 0; --i) {
                if (!(handler.mPendingAnimations.get(i) instanceof ObjectAnimator)) continue;
                anim2 = (ObjectAnimator)handler.mPendingAnimations.get(i);
                if (!anim2.mAutoCancel || !this.hasSameTargetAndProperties(anim2)) continue;
                anim2.cancel();
            }
            numAnims = handler.mDelayedAnims.size();
            for (i = numAnims - 1; i >= 0; --i) {
                if (!(handler.mDelayedAnims.get(i) instanceof ObjectAnimator)) continue;
                anim2 = (ObjectAnimator)handler.mDelayedAnims.get(i);
                if (!anim2.mAutoCancel || !this.hasSameTargetAndProperties(anim2)) continue;
                anim2.cancel();
            }
        }
        super.start();
    }

    @Override
    void initAnimation() {
        if (!this.mInitialized) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].setupSetterAndGetter(this.mTarget);
            }
            super.initAnimation();
        }
    }

    @Override
    public ObjectAnimator setDuration(long duration) {
        super.setDuration(duration);
        return this;
    }

    public Object getTarget() {
        return this.mTarget;
    }

    @Override
    public void setTarget(Object target) {
        if (this.mTarget != target) {
            Object oldTarget = this.mTarget;
            this.mTarget = target;
            if (oldTarget != null && target != null && oldTarget.getClass() == target.getClass()) {
                return;
            }
            this.mInitialized = false;
        }
    }

    @Override
    public void setupStartValues() {
        this.initAnimation();
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].setupStartValue(this.mTarget);
        }
    }

    @Override
    public void setupEndValues() {
        this.initAnimation();
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].setupEndValue(this.mTarget);
        }
    }

    @Override
    void animateValue(float fraction2) {
        super.animateValue(fraction2);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].setAnimatedValue(this.mTarget);
        }
    }

    @Override
    public ObjectAnimator clone() {
        ObjectAnimator anim2 = (ObjectAnimator)super.clone();
        return anim2;
    }

    @Override
    public String toString() {
        String returnVal = "ObjectAnimator@" + Integer.toHexString(this.hashCode()) + ", target " + this.mTarget;
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                returnVal = returnVal + "\n    " + this.mValues[i].toString();
            }
        }
        return returnVal;
    }
}

